<?php

namespace CUCM\EnumType;

/**
 * This class stands for XUseEntity EnumType
 * @subpackage Enumerations
 */
class XUseEntity
{
    /**
     * Constant for value 'ENDUSER'
     * @return string 'ENDUSER'
     */
    const VALUE_ENDUSER = 'ENDUSER';
    /**
     * Constant for value 'DEPARTMENT'
     * @return string 'DEPARTMENT'
     */
    const VALUE_DEPARTMENT = 'DEPARTMENT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENDUSER
     * @uses self::VALUE_DEPARTMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENDUSER,
            self::VALUE_DEPARTMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
