<?php

namespace CUCM\EnumType;

/**
 * This class stands for XUsageProfileFeature EnumType
 * @subpackage Enumerations
 */
class XUsageProfileFeature
{
    /**
     * Constant for value 'Park'
     * @return string 'Park'
     */
    const VALUE_PARK = 'Park';
    /**
     * Constant for value 'Call Pickup'
     * @return string 'Call Pickup'
     */
    const VALUE_CALL_PICKUP = 'Call Pickup';
    /**
     * Constant for value 'Barge'
     * @return string 'Barge'
     */
    const VALUE_BARGE = 'Barge';
    /**
     * Constant for value 'Divert'
     * @return string 'Divert'
     */
    const VALUE_DIVERT = 'Divert';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PARK
     * @uses self::VALUE_CALL_PICKUP
     * @uses self::VALUE_BARGE
     * @uses self::VALUE_DIVERT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PARK,
            self::VALUE_CALL_PICKUP,
            self::VALUE_BARGE,
            self::VALUE_DIVERT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
