<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTrunk EnumType
 * @subpackage Enumerations
 */
class XTrunk
{
    /**
     * Constant for value 'Ground Start'
     * @return string 'Ground Start'
     */
    const VALUE_GROUND_START = 'Ground Start';
    /**
     * Constant for value 'Loop Start'
     * @return string 'Loop Start'
     */
    const VALUE_LOOP_START = 'Loop Start';
    /**
     * Constant for value 'DID'
     * @return string 'DID'
     */
    const VALUE_DID = 'DID';
    /**
     * Constant for value 'POTS'
     * @return string 'POTS'
     */
    const VALUE_POTS = 'POTS';
    /**
     * Constant for value 'EANDM'
     * @return string 'EANDM'
     */
    const VALUE_EANDM = 'EANDM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GROUND_START
     * @uses self::VALUE_LOOP_START
     * @uses self::VALUE_DID
     * @uses self::VALUE_POTS
     * @uses self::VALUE_EANDM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GROUND_START,
            self::VALUE_LOOP_START,
            self::VALUE_DID,
            self::VALUE_POTS,
            self::VALUE_EANDM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
