<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTraceLevelGroups EnumType
 * @subpackage Enumerations
 */
class XTraceLevelGroups
{
    /**
     * Constant for value 'TraceLevelGroup0'
     * @return string 'TraceLevelGroup0'
     */
    const VALUE_TRACE_LEVEL_GROUP_0 = 'TraceLevelGroup0';
    /**
     * Constant for value 'TraceLevelGroup1'
     * @return string 'TraceLevelGroup1'
     */
    const VALUE_TRACE_LEVEL_GROUP_1 = 'TraceLevelGroup1';
    /**
     * Constant for value 'TraceLevelGroup2'
     * @return string 'TraceLevelGroup2'
     */
    const VALUE_TRACE_LEVEL_GROUP_2 = 'TraceLevelGroup2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRACE_LEVEL_GROUP_0
     * @uses self::VALUE_TRACE_LEVEL_GROUP_1
     * @uses self::VALUE_TRACE_LEVEL_GROUP_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRACE_LEVEL_GROUP_0,
            self::VALUE_TRACE_LEVEL_GROUP_1,
            self::VALUE_TRACE_LEVEL_GROUP_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
