<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSystemFeature EnumType
 * @subpackage Enumerations
 */
class XSystemFeature
{
    /**
     * Constant for value 'VoiceMail'
     * @return string 'VoiceMail'
     */
    const VALUE_VOICE_MAIL = 'VoiceMail';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOICE_MAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOICE_MAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
