<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSipAssertedType EnumType
 * @subpackage Enumerations
 */
class XSipAssertedType
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'PAI'
     * @return string 'PAI'
     */
    const VALUE_PAI = 'PAI';
    /**
     * Constant for value 'PPI'
     * @return string 'PPI'
     */
    const VALUE_PPI = 'PPI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_PAI
     * @uses self::VALUE_PPI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_PAI,
            self::VALUE_PPI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
