<?php

namespace CUCM\EnumType;

/**
 * This class stands for XServiceCategory EnumType
 * @subpackage Enumerations
 */
class XServiceCategory
{
    /**
     * Constant for value 'Service'
     * @return string 'Service'
     */
    const VALUE_SERVICE = 'Service';
    /**
     * Constant for value 'Servlet'
     * @return string 'Servlet'
     */
    const VALUE_SERVLET = 'Servlet';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERVICE
     * @uses self::VALUE_SERVLET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERVICE,
            self::VALUE_SERVLET,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
