<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSRSTOption EnumType
 * @subpackage Enumerations
 */
class XSRSTOption
{
    /**
     * Constant for value 'Disable'
     * @return string 'Disable'
     */
    const VALUE_DISABLE = 'Disable';
    /**
     * Constant for value 'Use Default Gateway'
     * @return string 'Use Default Gateway'
     */
    const VALUE_USE_DEFAULT_GATEWAY = 'Use Default Gateway';
    /**
     * Constant for value 'Legacy Configuration'
     * @return string 'Legacy Configuration'
     */
    const VALUE_LEGACY_CONFIGURATION = 'Legacy Configuration';
    /**
     * Constant for value 'User Specific'
     * @return string 'User Specific'
     */
    const VALUE_USER_SPECIFIC = 'User Specific';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLE
     * @uses self::VALUE_USE_DEFAULT_GATEWAY
     * @uses self::VALUE_LEGACY_CONFIGURATION
     * @uses self::VALUE_USER_SPECIFIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLE,
            self::VALUE_USE_DEFAULT_GATEWAY,
            self::VALUE_LEGACY_CONFIGURATION,
            self::VALUE_USER_SPECIFIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
