<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSIPReroute EnumType
 * @subpackage Enumerations
 */
class XSIPReroute
{
    /**
     * Constant for value 'Never'
     * @return string 'Never'
     */
    const VALUE_NEVER = 'Never';
    /**
     * Constant for value 'Contact Header'
     * @return string 'Contact Header'
     */
    const VALUE_CONTACT_HEADER = 'Contact Header';
    /**
     * Constant for value 'Call-Info Header with purpose=x-cisco-origIP'
     * @return string 'Call-Info Header with purpose=x-cisco-origIP'
     */
    const VALUE_CALL_INFO_HEADER_WITH_PURPOSE_X_CISCO_ORIG_IP = 'Call-Info Header with purpose=x-cisco-origIP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEVER
     * @uses self::VALUE_CONTACT_HEADER
     * @uses self::VALUE_CALL_INFO_HEADER_WITH_PURPOSE_X_CISCO_ORIG_IP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEVER,
            self::VALUE_CONTACT_HEADER,
            self::VALUE_CALL_INFO_HEADER_WITH_PURPOSE_X_CISCO_ORIG_IP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
