<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSAFService EnumType
 * @subpackage Enumerations
 */
class XSAFService
{
    /**
     * Constant for value 'Call Control Discovery Advertising Service'
     * @return string 'Call Control Discovery Advertising Service'
     */
    const VALUE_CALL_CONTROL_DISCOVERY_ADVERTISING_SERVICE = 'Call Control Discovery Advertising Service';
    /**
     * Constant for value 'Call Control Discovery Requesting Service'
     * @return string 'Call Control Discovery Requesting Service'
     */
    const VALUE_CALL_CONTROL_DISCOVERY_REQUESTING_SERVICE = 'Call Control Discovery Requesting Service';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CALL_CONTROL_DISCOVERY_ADVERTISING_SERVICE
     * @uses self::VALUE_CALL_CONTROL_DISCOVERY_REQUESTING_SERVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CALL_CONTROL_DISCOVERY_ADVERTISING_SERVICE,
            self::VALUE_CALL_CONTROL_DISCOVERY_REQUESTING_SERVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
