<?php

namespace CUCM\EnumType;

/**
 * This class stands for XRisClass EnumType
 * @subpackage Enumerations
 */
class XRisClass
{
    /**
     * Constant for value 'Not Applicable'
     * @return string 'Not Applicable'
     */
    const VALUE_NOT_APPLICABLE = 'Not Applicable';
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Constant for value 'Gateway'
     * @return string 'Gateway'
     */
    const VALUE_GATEWAY = 'Gateway';
    /**
     * Constant for value 'H.323'
     * @return string 'H.323'
     */
    const VALUE_H_323 = 'H.323';
    /**
     * Constant for value 'CTI'
     * @return string 'CTI'
     */
    const VALUE_CTI = 'CTI';
    /**
     * Constant for value 'Voice Mail'
     * @return string 'Voice Mail'
     */
    const VALUE_VOICE_MAIL = 'Voice Mail';
    /**
     * Constant for value 'MediaResources'
     * @return string 'MediaResources'
     */
    const VALUE_MEDIA_RESOURCES = 'MediaResources';
    /**
     * Constant for value 'Hunt List'
     * @return string 'Hunt List'
     */
    const VALUE_HUNT_LIST = 'Hunt List';
    /**
     * Constant for value 'SIP'
     * @return string 'SIP'
     */
    const VALUE_SIP = 'SIP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_APPLICABLE
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_GATEWAY
     * @uses self::VALUE_H_323
     * @uses self::VALUE_CTI
     * @uses self::VALUE_VOICE_MAIL
     * @uses self::VALUE_MEDIA_RESOURCES
     * @uses self::VALUE_HUNT_LIST
     * @uses self::VALUE_SIP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_APPLICABLE,
            self::VALUE_PHONE,
            self::VALUE_GATEWAY,
            self::VALUE_H_323,
            self::VALUE_CTI,
            self::VALUE_VOICE_MAIL,
            self::VALUE_MEDIA_RESOURCES,
            self::VALUE_HUNT_LIST,
            self::VALUE_SIP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
