<?php

namespace CUCM\EnumType;

/**
 * This class stands for XResetHandShake EnumType
 * @subpackage Enumerations
 */
class XResetHandShake
{
    /**
     * Constant for value 'new'
     * @return string 'new'
     */
    const VALUE_NEW = 'new';
    /**
     * Constant for value 'done'
     * @return string 'done'
     */
    const VALUE_DONE = 'done';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_DONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_DONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
