<?php

namespace CUCM\EnumType;

/**
 * This class stands for XProduct EnumType
 * @subpackage Enumerations
 */
class XProduct
{
    /**
     * Constant for value 'Pilot'
     * @return string 'Pilot'
     */
    const VALUE_PILOT = 'Pilot';
    /**
     * Constant for value 'Cisco Catalyst 6000 T1 VoIP Gateway'
     * @return string 'Cisco Catalyst 6000 T1 VoIP Gateway'
     */
    const VALUE_CISCO_CATALYST_6000_T_1_VO_IP_GATEWAY = 'Cisco Catalyst 6000 T1 VoIP Gateway';
    /**
     * Constant for value 'Cisco Catalyst 6000 E1 VoIP Gateway'
     * @return string 'Cisco Catalyst 6000 E1 VoIP Gateway'
     */
    const VALUE_CISCO_CATALYST_6000_E_1_VO_IP_GATEWAY = 'Cisco Catalyst 6000 E1 VoIP Gateway';
    /**
     * Constant for value 'Cisco Catalyst 6000 24 port FXS Gateway'
     * @return string 'Cisco Catalyst 6000 24 port FXS Gateway'
     */
    const VALUE_CISCO_CATALYST_6000_24_PORT_FXS_GATEWAY = 'Cisco Catalyst 6000 24 port FXS Gateway';
    /**
     * Constant for value 'Cisco Catalyst 6000 12 port FXO Gateway'
     * @return string 'Cisco Catalyst 6000 12 port FXO Gateway'
     */
    const VALUE_CISCO_CATALYST_6000_12_PORT_FXO_GATEWAY = 'Cisco Catalyst 6000 12 port FXO Gateway';
    /**
     * Constant for value 'EMCC Base Phone'
     * @return string 'EMCC Base Phone'
     */
    const VALUE_EMCC_BASE_PHONE = 'EMCC Base Phone';
    /**
     * Constant for value 'H.323 Client'
     * @return string 'H.323 Client'
     */
    const VALUE_H_323_CLIENT = 'H.323 Client';
    /**
     * Constant for value 'H.323 Gateway'
     * @return string 'H.323 Gateway'
     */
    const VALUE_H_323_GATEWAY = 'H.323 Gateway';
    /**
     * Constant for value 'Cisco MGCP FXO Port'
     * @return string 'Cisco MGCP FXO Port'
     */
    const VALUE_CISCO_MGCP_FXO_PORT = 'Cisco MGCP FXO Port';
    /**
     * Constant for value 'Cisco MGCP FXS Port'
     * @return string 'Cisco MGCP FXS Port'
     */
    const VALUE_CISCO_MGCP_FXS_PORT = 'Cisco MGCP FXS Port';
    /**
     * Constant for value 'Cisco 12 SP+'
     * @return string 'Cisco 12 SP+'
     */
    const VALUE_CISCO_12_SP = 'Cisco 12 SP+';
    /**
     * Constant for value 'Cisco 12 SP'
     * @return string 'Cisco 12 SP'
     */
    const VALUE_CISCO_12_SP_1 = 'Cisco 12 SP';
    /**
     * Constant for value 'Cisco 12 S'
     * @return string 'Cisco 12 S'
     */
    const VALUE_CISCO_12_S = 'Cisco 12 S';
    /**
     * Constant for value 'Cisco 30 SP+'
     * @return string 'Cisco 30 SP+'
     */
    const VALUE_CISCO_30_SP = 'Cisco 30 SP+';
    /**
     * Constant for value 'Cisco 30 VIP'
     * @return string 'Cisco 30 VIP'
     */
    const VALUE_CISCO_30_VIP = 'Cisco 30 VIP';
    /**
     * Constant for value 'CTI Port'
     * @return string 'CTI Port'
     */
    const VALUE_CTI_PORT = 'CTI Port';
    /**
     * Constant for value 'Cisco Voice Mail Port'
     * @return string 'Cisco Voice Mail Port'
     */
    const VALUE_CISCO_VOICE_MAIL_PORT = 'Cisco Voice Mail Port';
    /**
     * Constant for value 'Cisco Conference Bridge Software'
     * @return string 'Cisco Conference Bridge Software'
     */
    const VALUE_CISCO_CONFERENCE_BRIDGE_SOFTWARE = 'Cisco Conference Bridge Software';
    /**
     * Constant for value 'Cisco Conference Bridge Hardware'
     * @return string 'Cisco Conference Bridge Hardware'
     */
    const VALUE_CISCO_CONFERENCE_BRIDGE_HARDWARE = 'Cisco Conference Bridge Hardware';
    /**
     * Constant for value 'Cisco Media Termination Point Software'
     * @return string 'Cisco Media Termination Point Software'
     */
    const VALUE_CISCO_MEDIA_TERMINATION_POINT_SOFTWARE = 'Cisco Media Termination Point Software';
    /**
     * Constant for value 'Cisco Media Termination Point Hardware'
     * @return string 'Cisco Media Termination Point Hardware'
     */
    const VALUE_CISCO_MEDIA_TERMINATION_POINT_HARDWARE = 'Cisco Media Termination Point Hardware';
    /**
     * Constant for value 'Cisco 7935'
     * @return string 'Cisco 7935'
     */
    const VALUE_CISCO_7935 = 'Cisco 7935';
    /**
     * Constant for value 'SCCP Device'
     * @return string 'SCCP Device'
     */
    const VALUE_SCCP_DEVICE = 'SCCP Device';
    /**
     * Constant for value 'Cisco 7910'
     * @return string 'Cisco 7910'
     */
    const VALUE_CISCO_7910 = 'Cisco 7910';
    /**
     * Constant for value 'Cisco 7960'
     * @return string 'Cisco 7960'
     */
    const VALUE_CISCO_7960 = 'Cisco 7960';
    /**
     * Constant for value 'Cisco 7940'
     * @return string 'Cisco 7940'
     */
    const VALUE_CISCO_7940 = 'Cisco 7940';
    /**
     * Constant for value 'Route List'
     * @return string 'Route List'
     */
    const VALUE_ROUTE_LIST = 'Route List';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Load Simulator'
     * @return string 'Load Simulator'
     */
    const VALUE_LOAD_SIMULATOR = 'Load Simulator';
    /**
     * Constant for value 'Gatekeeper'
     * @return string 'Gatekeeper'
     */
    const VALUE_GATEKEEPER = 'Gatekeeper';
    /**
     * Constant for value 'NM-1V'
     * @return string 'NM-1V'
     */
    const VALUE_NM_1_V = 'NM-1V';
    /**
     * Constant for value 'NM-2V'
     * @return string 'NM-2V'
     */
    const VALUE_NM_2_V = 'NM-2V';
    /**
     * Constant for value 'Cisco VG200'
     * @return string 'Cisco VG200'
     */
    const VALUE_CISCO_VG_200 = 'Cisco VG200';
    /**
     * Constant for value 'Cisco 26XX'
     * @return string 'Cisco 26XX'
     */
    const VALUE_CISCO_26_XX = 'Cisco 26XX';
    /**
     * Constant for value 'Cisco 362X'
     * @return string 'Cisco 362X'
     */
    const VALUE_CISCO_362_X = 'Cisco 362X';
    /**
     * Constant for value 'Cisco 364X'
     * @return string 'Cisco 364X'
     */
    const VALUE_CISCO_364_X = 'Cisco 364X';
    /**
     * Constant for value 'Cisco 366X'
     * @return string 'Cisco 366X'
     */
    const VALUE_CISCO_366_X = 'Cisco 366X';
    /**
     * Constant for value 'CTI Route Point'
     * @return string 'CTI Route Point'
     */
    const VALUE_CTI_ROUTE_POINT = 'CTI Route Point';
    /**
     * Constant for value 'Music On Hold'
     * @return string 'Music On Hold'
     */
    const VALUE_MUSIC_ON_HOLD = 'Music On Hold';
    /**
     * Constant for value 'Cisco MGCP T1 Port'
     * @return string 'Cisco MGCP T1 Port'
     */
    const VALUE_CISCO_MGCP_T_1_PORT = 'Cisco MGCP T1 Port';
    /**
     * Constant for value 'NM-HDV'
     * @return string 'NM-HDV'
     */
    const VALUE_NM_HDV = 'NM-HDV';
    /**
     * Constant for value 'VIC_SLOT'
     * @return string 'VIC_SLOT'
     */
    const VALUE_VIC_SLOT = 'VIC_SLOT';
    /**
     * Constant for value 'Cisco MGCP E1 Port'
     * @return string 'Cisco MGCP E1 Port'
     */
    const VALUE_CISCO_MGCP_E_1_PORT = 'Cisco MGCP E1 Port';
    /**
     * Constant for value 'VWIC_SLOT'
     * @return string 'VWIC_SLOT'
     */
    const VALUE_VWIC_SLOT = 'VWIC_SLOT';
    /**
     * Constant for value 'FLEX_SLOT'
     * @return string 'FLEX_SLOT'
     */
    const VALUE_FLEX_SLOT = 'FLEX_SLOT';
    /**
     * Constant for value 'Cisco Catalyst 4224 Voice Gateway Switch'
     * @return string 'Cisco Catalyst 4224 Voice Gateway Switch'
     */
    const VALUE_CISCO_CATALYST_4224_VOICE_GATEWAY_SWITCH = 'Cisco Catalyst 4224 Voice Gateway Switch';
    /**
     * Constant for value 'Cisco Catalyst 4000 Access Gateway  Module'
     * @return string 'Cisco Catalyst 4000 Access Gateway  Module'
     */
    const VALUE_CISCO_CATALYST_4000_ACCESS_GATEWAY_MODULE = 'Cisco Catalyst 4000 Access Gateway  Module';
    /**
     * Constant for value 'Cisco IOS Conference Bridge'
     * @return string 'Cisco IOS Conference Bridge'
     */
    const VALUE_CISCO_IOS_CONFERENCE_BRIDGE = 'Cisco IOS Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Media Termination Point'
     * @return string 'Cisco IOS Media Termination Point'
     */
    const VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT = 'Cisco IOS Media Termination Point';
    /**
     * Constant for value 'Cisco  IAD2400'
     * @return string 'Cisco  IAD2400'
     */
    const VALUE_CISCO_IAD_2400 = 'Cisco  IAD2400';
    /**
     * Constant for value 'IAD2400_ANALOG'
     * @return string 'IAD2400_ANALOG'
     */
    const VALUE_IAD_2400_ANALOG = 'IAD2400_ANALOG';
    /**
     * Constant for value 'IAD2400_DIGITAL'
     * @return string 'IAD2400_DIGITAL'
     */
    const VALUE_IAD_2400_DIGITAL = 'IAD2400_DIGITAL';
    /**
     * Constant for value 'Cisco VGC Phone'
     * @return string 'Cisco VGC Phone'
     */
    const VALUE_CISCO_VGC_PHONE = 'Cisco VGC Phone';
    /**
     * Constant for value 'Cisco VG248 Gateway'
     * @return string 'Cisco VG248 Gateway'
     */
    const VALUE_CISCO_VG_248_GATEWAY = 'Cisco VG248 Gateway';
    /**
     * Constant for value 'VGC Port'
     * @return string 'VGC Port'
     */
    const VALUE_VGC_PORT = 'VGC Port';
    /**
     * Constant for value 'Cisco VGC Virtual Phone'
     * @return string 'Cisco VGC Virtual Phone'
     */
    const VALUE_CISCO_VGC_VIRTUAL_PHONE = 'Cisco VGC Virtual Phone';
    /**
     * Constant for value 'Cisco ATA 186'
     * @return string 'Cisco ATA 186'
     */
    const VALUE_CISCO_ATA_186 = 'Cisco ATA 186';
    /**
     * Constant for value 'H.225 Trunk (Gatekeeper Controlled)'
     * @return string 'H.225 Trunk (Gatekeeper Controlled)'
     */
    const VALUE_H_225_TRUNK_GATEKEEPER_CONTROLLED = 'H.225 Trunk (Gatekeeper Controlled)';
    /**
     * Constant for value 'Inter-Cluster Trunk (Gatekeeper Controlled)'
     * @return string 'Inter-Cluster Trunk (Gatekeeper Controlled)'
     */
    const VALUE_INTER_CLUSTER_TRUNK_GATEKEEPER_CONTROLLED = 'Inter-Cluster Trunk (Gatekeeper Controlled)';
    /**
     * Constant for value 'Inter-Cluster Trunk (Non-Gatekeeper Controlled)'
     * @return string 'Inter-Cluster Trunk (Non-Gatekeeper Controlled)'
     */
    const VALUE_INTER_CLUSTER_TRUNK_NON_GATEKEEPER_CONTROLLED = 'Inter-Cluster Trunk (Non-Gatekeeper Controlled)';
    /**
     * Constant for value 'Communication Media Module'
     * @return string 'Communication Media Module'
     */
    const VALUE_COMMUNICATION_MEDIA_MODULE = 'Communication Media Module';
    /**
     * Constant for value 'WS-X6600'
     * @return string 'WS-X6600'
     */
    const VALUE_WS_X_6600 = 'WS-X6600';
    /**
     * Constant for value 'AIM-VOICE-30'
     * @return string 'AIM-VOICE-30'
     */
    const VALUE_AIM_VOICE_30 = 'AIM-VOICE-30';
    /**
     * Constant for value 'NM-HDA'
     * @return string 'NM-HDA'
     */
    const VALUE_NM_HDA = 'NM-HDA';
    /**
     * Constant for value 'PA-VXA'
     * @return string 'PA-VXA'
     */
    const VALUE_PA_VXA = 'PA-VXA';
    /**
     * Constant for value 'PA-VXB'
     * @return string 'PA-VXB'
     */
    const VALUE_PA_VXB = 'PA-VXB';
    /**
     * Constant for value 'PA-VXC'
     * @return string 'PA-VXC'
     */
    const VALUE_PA_VXC = 'PA-VXC';
    /**
     * Constant for value 'PA-MCX'
     * @return string 'PA-MCX'
     */
    const VALUE_PA_MCX = 'PA-MCX';
    /**
     * Constant for value 'Annunciator'
     * @return string 'Annunciator'
     */
    const VALUE_ANNUNCIATOR = 'Annunciator';
    /**
     * Constant for value 'Cisco MGCP BRI Port'
     * @return string 'Cisco MGCP BRI Port'
     */
    const VALUE_CISCO_MGCP_BRI_PORT = 'Cisco MGCP BRI Port';
    /**
     * Constant for value 'NM-HD-1V'
     * @return string 'NM-HD-1V'
     */
    const VALUE_NM_HD_1_V = 'NM-HD-1V';
    /**
     * Constant for value 'NM-HD-2V'
     * @return string 'NM-HD-2V'
     */
    const VALUE_NM_HD_2_V = 'NM-HD-2V';
    /**
     * Constant for value 'NM-HD-2VE'
     * @return string 'NM-HD-2VE'
     */
    const VALUE_NM_HD_2_VE = 'NM-HD-2VE';
    /**
     * Constant for value 'SIP Trunk'
     * @return string 'SIP Trunk'
     */
    const VALUE_SIP_TRUNK = 'SIP Trunk';
    /**
     * Constant for value 'Cisco Conference Bridge (WS-SVC-CMM)'
     * @return string 'Cisco Conference Bridge (WS-SVC-CMM)'
     */
    const VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM = 'Cisco Conference Bridge (WS-SVC-CMM)';
    /**
     * Constant for value 'Cisco Media Server (WS-SVC-CMM-MS)'
     * @return string 'Cisco Media Server (WS-SVC-CMM-MS)'
     */
    const VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS = 'Cisco Media Server (WS-SVC-CMM-MS)';
    /**
     * Constant for value 'Cisco Media Termination Point (WS-SVC-CMM)'
     * @return string 'Cisco Media Termination Point (WS-SVC-CMM)'
     */
    const VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM = 'Cisco Media Termination Point (WS-SVC-CMM)';
    /**
     * Constant for value 'Cisco IOS Enhanced Software Media Termination Point'
     * @return string 'Cisco IOS Enhanced Software Media Termination Point'
     */
    const VALUE_CISCO_IOS_ENHANCED_SOFTWARE_MEDIA_TERMINATION_POINT = 'Cisco IOS Enhanced Software Media Termination Point';
    /**
     * Constant for value '7914 14-Button Line Expansion Module'
     * @return string '7914 14-Button Line Expansion Module'
     */
    const VALUE_7914_14_BUTTON_LINE_EXPANSION_MODULE = '7914 14-Button Line Expansion Module';
    /**
     * Constant for value 'Cisco IOS Enhanced Conference Bridge'
     * @return string 'Cisco IOS Enhanced Conference Bridge'
     */
    const VALUE_CISCO_IOS_ENHANCED_CONFERENCE_BRIDGE = 'Cisco IOS Enhanced Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Enhanced Media Termination Point'
     * @return string 'Cisco IOS Enhanced Media Termination Point'
     */
    const VALUE_CISCO_IOS_ENHANCED_MEDIA_TERMINATION_POINT = 'Cisco IOS Enhanced Media Termination Point';
    /**
     * Constant for value 'Cisco Video Conference Bridge(IPVC-35xx)'
     * @return string 'Cisco Video Conference Bridge(IPVC-35xx)'
     */
    const VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX = 'Cisco Video Conference Bridge(IPVC-35xx)';
    /**
     * Constant for value 'Cisco IOS Heterogeneous Video Conference Bridge'
     * @return string 'Cisco IOS Heterogeneous Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Heterogeneous Video Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Guaranteed Audio Video Conference Bridge'
     * @return string 'Cisco IOS Guaranteed Audio Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Guaranteed Audio Video Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Homogeneous Video Conference Bridge'
     * @return string 'Cisco IOS Homogeneous Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Homogeneous Video Conference Bridge';
    /**
     * Constant for value 'Hunt List'
     * @return string 'Hunt List'
     */
    const VALUE_HUNT_LIST = 'Hunt List';
    /**
     * Constant for value 'SIP WSM Connection'
     * @return string 'SIP WSM Connection'
     */
    const VALUE_SIP_WSM_CONNECTION = 'SIP WSM Connection';
    /**
     * Constant for value 'Remote Destination Profile'
     * @return string 'Remote Destination Profile'
     */
    const VALUE_REMOTE_DESTINATION_PROFILE = 'Remote Destination Profile';
    /**
     * Constant for value 'Cisco 7941'
     * @return string 'Cisco 7941'
     */
    const VALUE_CISCO_7941 = 'Cisco 7941';
    /**
     * Constant for value 'Cisco 7971'
     * @return string 'Cisco 7971'
     */
    const VALUE_CISCO_7971 = 'Cisco 7971';
    /**
     * Constant for value 'Cisco 7985'
     * @return string 'Cisco 7985'
     */
    const VALUE_CISCO_7985 = 'Cisco 7985';
    /**
     * Constant for value 'Cisco 7911'
     * @return string 'Cisco 7911'
     */
    const VALUE_CISCO_7911 = 'Cisco 7911';
    /**
     * Constant for value 'Cisco 7961G-GE'
     * @return string 'Cisco 7961G-GE'
     */
    const VALUE_CISCO_7961_G_GE = 'Cisco 7961G-GE';
    /**
     * Constant for value 'Cisco 7941G-GE'
     * @return string 'Cisco 7941G-GE'
     */
    const VALUE_CISCO_7941_G_GE = 'Cisco 7941G-GE';
    /**
     * Constant for value '7915 12-Button Line Expansion Module'
     * @return string '7915 12-Button Line Expansion Module'
     */
    const VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE = '7915 12-Button Line Expansion Module';
    /**
     * Constant for value '7915 24-Button Line Expansion Module'
     * @return string '7915 24-Button Line Expansion Module'
     */
    const VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE = '7915 24-Button Line Expansion Module';
    /**
     * Constant for value '7916 12-Button Line Expansion Module'
     * @return string '7916 12-Button Line Expansion Module'
     */
    const VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE = '7916 12-Button Line Expansion Module';
    /**
     * Constant for value '7916 24-Button Line Expansion Module'
     * @return string '7916 24-Button Line Expansion Module'
     */
    const VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE = '7916 24-Button Line Expansion Module';
    /**
     * Constant for value 'CKEM 36-Button Line Expansion Module'
     * @return string 'CKEM 36-Button Line Expansion Module'
     */
    const VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE = 'CKEM 36-Button Line Expansion Module';
    /**
     * Constant for value 'Motorola CN622'
     * @return string 'Motorola CN622'
     */
    const VALUE_MOTOROLA_CN_622 = 'Motorola CN622';
    /**
     * Constant for value 'Third-party SIP Device (Basic)'
     * @return string 'Third-party SIP Device (Basic)'
     */
    const VALUE_THIRD_PARTY_SIP_DEVICE_BASIC = 'Third-party SIP Device (Basic)';
    /**
     * Constant for value 'Cisco 7931'
     * @return string 'Cisco 7931'
     */
    const VALUE_CISCO_7931 = 'Cisco 7931';
    /**
     * Constant for value 'Cisco Unified Personal Communicator'
     * @return string 'Cisco Unified Personal Communicator'
     */
    const VALUE_CISCO_UNIFIED_PERSONAL_COMMUNICATOR = 'Cisco Unified Personal Communicator';
    /**
     * Constant for value 'Cisco 7921'
     * @return string 'Cisco 7921'
     */
    const VALUE_CISCO_7921 = 'Cisco 7921';
    /**
     * Constant for value 'Cisco 7906'
     * @return string 'Cisco 7906'
     */
    const VALUE_CISCO_7906 = 'Cisco 7906';
    /**
     * Constant for value 'Third-party SIP Device (Advanced)'
     * @return string 'Third-party SIP Device (Advanced)'
     */
    const VALUE_THIRD_PARTY_SIP_DEVICE_ADVANCED = 'Third-party SIP Device (Advanced)';
    /**
     * Constant for value 'Cisco TelePresence'
     * @return string 'Cisco TelePresence'
     */
    const VALUE_CISCO_TELE_PRESENCE = 'Cisco TelePresence';
    /**
     * Constant for value 'Nokia S60'
     * @return string 'Nokia S60'
     */
    const VALUE_NOKIA_S_60 = 'Nokia S60';
    /**
     * Constant for value 'Cisco 7962'
     * @return string 'Cisco 7962'
     */
    const VALUE_CISCO_7962 = 'Cisco 7962';
    /**
     * Constant for value 'Cisco 3951'
     * @return string 'Cisco 3951'
     */
    const VALUE_CISCO_3951 = 'Cisco 3951';
    /**
     * Constant for value 'Cisco 7937'
     * @return string 'Cisco 7937'
     */
    const VALUE_CISCO_7937 = 'Cisco 7937';
    /**
     * Constant for value 'Cisco 7942'
     * @return string 'Cisco 7942'
     */
    const VALUE_CISCO_7942 = 'Cisco 7942';
    /**
     * Constant for value 'Cisco 7945'
     * @return string 'Cisco 7945'
     */
    const VALUE_CISCO_7945 = 'Cisco 7945';
    /**
     * Constant for value 'Cisco 7965'
     * @return string 'Cisco 7965'
     */
    const VALUE_CISCO_7965 = 'Cisco 7965';
    /**
     * Constant for value 'Cisco 7975'
     * @return string 'Cisco 7975'
     */
    const VALUE_CISCO_7975 = 'Cisco 7975';
    /**
     * Constant for value 'Cisco 3911'
     * @return string 'Cisco 3911'
     */
    const VALUE_CISCO_3911 = 'Cisco 3911';
    /**
     * Constant for value 'Cisco Unified Mobile Communicator'
     * @return string 'Cisco Unified Mobile Communicator'
     */
    const VALUE_CISCO_UNIFIED_MOBILE_COMMUNICATOR = 'Cisco Unified Mobile Communicator';
    /**
     * Constant for value 'Cisco TelePresence 1000'
     * @return string 'Cisco TelePresence 1000'
     */
    const VALUE_CISCO_TELE_PRESENCE_1000 = 'Cisco TelePresence 1000';
    /**
     * Constant for value 'Cisco TelePresence 3000'
     * @return string 'Cisco TelePresence 3000'
     */
    const VALUE_CISCO_TELE_PRESENCE_3000 = 'Cisco TelePresence 3000';
    /**
     * Constant for value 'Cisco TelePresence 3200'
     * @return string 'Cisco TelePresence 3200'
     */
    const VALUE_CISCO_TELE_PRESENCE_3200 = 'Cisco TelePresence 3200';
    /**
     * Constant for value 'Cisco TelePresence 500-37'
     * @return string 'Cisco TelePresence 500-37'
     */
    const VALUE_CISCO_TELE_PRESENCE_500_37 = 'Cisco TelePresence 500-37';
    /**
     * Constant for value 'Cisco 7925'
     * @return string 'Cisco 7925'
     */
    const VALUE_CISCO_7925 = 'Cisco 7925';
    /**
     * Constant for value 'Cisco 9971'
     * @return string 'Cisco 9971'
     */
    const VALUE_CISCO_9971 = 'Cisco 9971';
    /**
     * Constant for value 'Cisco 6921'
     * @return string 'Cisco 6921'
     */
    const VALUE_CISCO_6921 = 'Cisco 6921';
    /**
     * Constant for value 'Cisco 6941'
     * @return string 'Cisco 6941'
     */
    const VALUE_CISCO_6941 = 'Cisco 6941';
    /**
     * Constant for value 'Cisco 6961'
     * @return string 'Cisco 6961'
     */
    const VALUE_CISCO_6961 = 'Cisco 6961';
    /**
     * Constant for value 'Cisco Unified Client Services Framework'
     * @return string 'Cisco Unified Client Services Framework'
     */
    const VALUE_CISCO_UNIFIED_CLIENT_SERVICES_FRAMEWORK = 'Cisco Unified Client Services Framework';
    /**
     * Constant for value 'Cisco TelePresence 1300-65'
     * @return string 'Cisco TelePresence 1300-65'
     */
    const VALUE_CISCO_TELE_PRESENCE_1300_65 = 'Cisco TelePresence 1300-65';
    /**
     * Constant for value 'Cisco TelePresence 1100'
     * @return string 'Cisco TelePresence 1100'
     */
    const VALUE_CISCO_TELE_PRESENCE_1100 = 'Cisco TelePresence 1100';
    /**
     * Constant for value 'Transnova S3'
     * @return string 'Transnova S3'
     */
    const VALUE_TRANSNOVA_S_3 = 'Transnova S3';
    /**
     * Constant for value 'Cisco 9951'
     * @return string 'Cisco 9951'
     */
    const VALUE_CISCO_9951 = 'Cisco 9951';
    /**
     * Constant for value 'Cisco 8961'
     * @return string 'Cisco 8961'
     */
    const VALUE_CISCO_8961 = 'Cisco 8961';
    /**
     * Constant for value 'Cisco 6901'
     * @return string 'Cisco 6901'
     */
    const VALUE_CISCO_6901 = 'Cisco 6901';
    /**
     * Constant for value 'Cisco 6911'
     * @return string 'Cisco 6911'
     */
    const VALUE_CISCO_6911 = 'Cisco 6911';
    /**
     * Constant for value 'Cisco ATA 187'
     * @return string 'Cisco ATA 187'
     */
    const VALUE_CISCO_ATA_187 = 'Cisco ATA 187';
    /**
     * Constant for value 'Cisco TelePresence 200'
     * @return string 'Cisco TelePresence 200'
     */
    const VALUE_CISCO_TELE_PRESENCE_200 = 'Cisco TelePresence 200';
    /**
     * Constant for value 'Cisco TelePresence 400'
     * @return string 'Cisco TelePresence 400'
     */
    const VALUE_CISCO_TELE_PRESENCE_400 = 'Cisco TelePresence 400';
    /**
     * Constant for value 'Cisco Dual Mode for iPhone'
     * @return string 'Cisco Dual Mode for iPhone'
     */
    const VALUE_CISCO_DUAL_MODE_FOR_I_PHONE = 'Cisco Dual Mode for iPhone';
    /**
     * Constant for value 'Cisco 6945'
     * @return string 'Cisco 6945'
     */
    const VALUE_CISCO_6945 = 'Cisco 6945';
    /**
     * Constant for value 'Cisco Dual Mode for Android'
     * @return string 'Cisco Dual Mode for Android'
     */
    const VALUE_CISCO_DUAL_MODE_FOR_ANDROID = 'Cisco Dual Mode for Android';
    /**
     * Constant for value 'Cisco 7926'
     * @return string 'Cisco 7926'
     */
    const VALUE_CISCO_7926 = 'Cisco 7926';
    /**
     * Constant for value 'Cisco E20'
     * @return string 'Cisco E20'
     */
    const VALUE_CISCO_E_20 = 'Cisco E20';
    /**
     * Constant for value 'Generic Single Screen Room System'
     * @return string 'Generic Single Screen Room System'
     */
    const VALUE_GENERIC_SINGLE_SCREEN_ROOM_SYSTEM = 'Generic Single Screen Room System';
    /**
     * Constant for value 'Generic Multiple Screen Room System'
     * @return string 'Generic Multiple Screen Room System'
     */
    const VALUE_GENERIC_MULTIPLE_SCREEN_ROOM_SYSTEM = 'Generic Multiple Screen Room System';
    /**
     * Constant for value 'Cisco TelePresence EX90'
     * @return string 'Cisco TelePresence EX90'
     */
    const VALUE_CISCO_TELE_PRESENCE_EX_90 = 'Cisco TelePresence EX90';
    /**
     * Constant for value 'Cisco 8945'
     * @return string 'Cisco 8945'
     */
    const VALUE_CISCO_8945 = 'Cisco 8945';
    /**
     * Constant for value 'Cisco 8941'
     * @return string 'Cisco 8941'
     */
    const VALUE_CISCO_8941 = 'Cisco 8941';
    /**
     * Constant for value 'Generic Desktop Video Endpoint'
     * @return string 'Generic Desktop Video Endpoint'
     */
    const VALUE_GENERIC_DESKTOP_VIDEO_ENDPOINT = 'Generic Desktop Video Endpoint';
    /**
     * Constant for value 'Cisco TelePresence 500-32'
     * @return string 'Cisco TelePresence 500-32'
     */
    const VALUE_CISCO_TELE_PRESENCE_500_32 = 'Cisco TelePresence 500-32';
    /**
     * Constant for value 'Cisco TelePresence 1300-47'
     * @return string 'Cisco TelePresence 1300-47'
     */
    const VALUE_CISCO_TELE_PRESENCE_1300_47 = 'Cisco TelePresence 1300-47';
    /**
     * Constant for value 'Cisco 3905'
     * @return string 'Cisco 3905'
     */
    const VALUE_CISCO_3905 = 'Cisco 3905';
    /**
     * Constant for value 'Cisco Cius'
     * @return string 'Cisco Cius'
     */
    const VALUE_CISCO_CIUS = 'Cisco Cius';
    /**
     * Constant for value 'VKEM 36-Button Line Expansion Module'
     * @return string 'VKEM 36-Button Line Expansion Module'
     */
    const VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE = 'VKEM 36-Button Line Expansion Module';
    /**
     * Constant for value 'Cisco TelePresence 1310-65'
     * @return string 'Cisco TelePresence 1310-65'
     */
    const VALUE_CISCO_TELE_PRESENCE_1310_65 = 'Cisco TelePresence 1310-65';
    /**
     * Constant for value 'Cisco TelePresence MCU'
     * @return string 'Cisco TelePresence MCU'
     */
    const VALUE_CISCO_TELE_PRESENCE_MCU = 'Cisco TelePresence MCU';
    /**
     * Constant for value 'Cisco TelePresence EX60'
     * @return string 'Cisco TelePresence EX60'
     */
    const VALUE_CISCO_TELE_PRESENCE_EX_60 = 'Cisco TelePresence EX60';
    /**
     * Constant for value 'Cisco TelePresence Codec C90'
     * @return string 'Cisco TelePresence Codec C90'
     */
    const VALUE_CISCO_TELE_PRESENCE_CODEC_C_90 = 'Cisco TelePresence Codec C90';
    /**
     * Constant for value 'Cisco TelePresence Codec C60'
     * @return string 'Cisco TelePresence Codec C60'
     */
    const VALUE_CISCO_TELE_PRESENCE_CODEC_C_60 = 'Cisco TelePresence Codec C60';
    /**
     * Constant for value 'Cisco TelePresence Codec C40'
     * @return string 'Cisco TelePresence Codec C40'
     */
    const VALUE_CISCO_TELE_PRESENCE_CODEC_C_40 = 'Cisco TelePresence Codec C40';
    /**
     * Constant for value 'Cisco TelePresence Quick Set C20'
     * @return string 'Cisco TelePresence Quick Set C20'
     */
    const VALUE_CISCO_TELE_PRESENCE_QUICK_SET_C_20 = 'Cisco TelePresence Quick Set C20';
    /**
     * Constant for value 'Cisco Telepresence Profile 42 (C20)'
     * @return string 'Cisco Telepresence Profile 42 (C20)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_20 = 'Cisco Telepresence Profile 42 (C20)';
    /**
     * Constant for value 'Cisco Telepresence Profile 42 (C60)'
     * @return string 'Cisco Telepresence Profile 42 (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_60 = 'Cisco Telepresence Profile 42 (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 52 (C40)'
     * @return string 'Cisco Telepresence Profile 52 (C40)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_40 = 'Cisco Telepresence Profile 52 (C40)';
    /**
     * Constant for value 'Cisco Telepresence Profile 52 (C60)'
     * @return string 'Cisco Telepresence Profile 52 (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_60 = 'Cisco Telepresence Profile 52 (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 52 Dual (C60)'
     * @return string 'Cisco Telepresence Profile 52 Dual (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_52_DUAL_C_60 = 'Cisco Telepresence Profile 52 Dual (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 65 (C60)'
     * @return string 'Cisco Telepresence Profile 65 (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_65_C_60 = 'Cisco Telepresence Profile 65 (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 65 Dual (C90)'
     * @return string 'Cisco Telepresence Profile 65 Dual (C90)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_65_DUAL_C_90 = 'Cisco Telepresence Profile 65 Dual (C90)';
    /**
     * Constant for value 'Cisco TelePresence MX200'
     * @return string 'Cisco TelePresence MX200'
     */
    const VALUE_CISCO_TELE_PRESENCE_MX_200 = 'Cisco TelePresence MX200';
    /**
     * Constant for value 'IMS-integrated Mobile (Basic)'
     * @return string 'IMS-integrated Mobile (Basic)'
     */
    const VALUE_IMS_INTEGRATED_MOBILE_BASIC = 'IMS-integrated Mobile (Basic)';
    /**
     * Constant for value 'Cisco Cius SP'
     * @return string 'Cisco Cius SP'
     */
    const VALUE_CISCO_CIUS_SP = 'Cisco Cius SP';
    /**
     * Constant for value 'Cisco TelePresence Profile 42 (C40)'
     * @return string 'Cisco TelePresence Profile 42 (C40)'
     */
    const VALUE_CISCO_TELE_PRESENCE_PROFILE_42_C_40 = 'Cisco TelePresence Profile 42 (C40)';
    /**
     * Constant for value 'WS-SVC-CMM-MS'
     * @return string 'WS-SVC-CMM-MS'
     */
    const VALUE_WS_SVC_CMM_MS = 'WS-SVC-CMM-MS';
    /**
     * Constant for value 'NM-4VWIC-MBRD'
     * @return string 'NM-4VWIC-MBRD'
     */
    const VALUE_NM_4_VWIC_MBRD = 'NM-4VWIC-MBRD';
    /**
     * Constant for value 'VNM-HDA'
     * @return string 'VNM-HDA'
     */
    const VALUE_VNM_HDA = 'VNM-HDA';
    /**
     * Constant for value 'NM-HDV2-0PORT'
     * @return string 'NM-HDV2-0PORT'
     */
    const VALUE_NM_HDV_2_0_PORT = 'NM-HDV2-0PORT';
    /**
     * Constant for value 'NM-HDV2-1PORT'
     * @return string 'NM-HDV2-1PORT'
     */
    const VALUE_NM_HDV_2_1_PORT = 'NM-HDV2-1PORT';
    /**
     * Constant for value 'NM-HDV2-2PORT'
     * @return string 'NM-HDV2-2PORT'
     */
    const VALUE_NM_HDV_2_2_PORT = 'NM-HDV2-2PORT';
    /**
     * Constant for value 'Cisco 3745'
     * @return string 'Cisco 3745'
     */
    const VALUE_CISCO_3745 = 'Cisco 3745';
    /**
     * Constant for value 'Cisco 3725'
     * @return string 'Cisco 3725'
     */
    const VALUE_CISCO_3725 = 'Cisco 3725';
    /**
     * Constant for value 'Cisco 7905'
     * @return string 'Cisco 7905'
     */
    const VALUE_CISCO_7905 = 'Cisco 7905';
    /**
     * Constant for value 'Cisco 7920'
     * @return string 'Cisco 7920'
     */
    const VALUE_CISCO_7920 = 'Cisco 7920';
    /**
     * Constant for value 'Cisco 269X'
     * @return string 'Cisco 269X'
     */
    const VALUE_CISCO_269_X = 'Cisco 269X';
    /**
     * Constant for value 'Cisco 7970'
     * @return string 'Cisco 7970'
     */
    const VALUE_CISCO_7970 = 'Cisco 7970';
    /**
     * Constant for value 'Cisco 1760'
     * @return string 'Cisco 1760'
     */
    const VALUE_CISCO_1760 = 'Cisco 1760';
    /**
     * Constant for value 'Cisco 1751'
     * @return string 'Cisco 1751'
     */
    const VALUE_CISCO_1751 = 'Cisco 1751';
    /**
     * Constant for value 'Cisco 7912'
     * @return string 'Cisco 7912'
     */
    const VALUE_CISCO_7912 = 'Cisco 7912';
    /**
     * Constant for value 'Cisco 7902'
     * @return string 'Cisco 7902'
     */
    const VALUE_CISCO_7902 = 'Cisco 7902';
    /**
     * Constant for value 'VG224'
     * @return string 'VG224'
     */
    const VALUE_VG_224 = 'VG224';
    /**
     * Constant for value 'Cisco 2821'
     * @return string 'Cisco 2821'
     */
    const VALUE_CISCO_2821 = 'Cisco 2821';
    /**
     * Constant for value 'Cisco IP Communicator'
     * @return string 'Cisco IP Communicator'
     */
    const VALUE_CISCO_IP_COMMUNICATOR = 'Cisco IP Communicator';
    /**
     * Constant for value 'Cisco 7961'
     * @return string 'Cisco 7961'
     */
    const VALUE_CISCO_7961 = 'Cisco 7961';
    /**
     * Constant for value 'Cisco 7936'
     * @return string 'Cisco 7936'
     */
    const VALUE_CISCO_7936 = 'Cisco 7936';
    /**
     * Constant for value 'Cisco 3825'
     * @return string 'Cisco 3825'
     */
    const VALUE_CISCO_3825 = 'Cisco 3825';
    /**
     * Constant for value 'Cisco 3845'
     * @return string 'Cisco 3845'
     */
    const VALUE_CISCO_3845 = 'Cisco 3845';
    /**
     * Constant for value 'Cisco 2811'
     * @return string 'Cisco 2811'
     */
    const VALUE_CISCO_2811 = 'Cisco 2811';
    /**
     * Constant for value 'Cisco 2851'
     * @return string 'Cisco 2851'
     */
    const VALUE_CISCO_2851 = 'Cisco 2851';
    /**
     * Constant for value 'Analog Phone'
     * @return string 'Analog Phone'
     */
    const VALUE_ANALOG_PHONE = 'Analog Phone';
    /**
     * Constant for value 'ISDN BRI Phone'
     * @return string 'ISDN BRI Phone'
     */
    const VALUE_ISDN_BRI_PHONE = 'ISDN BRI Phone';
    /**
     * Constant for value 'SCCP gateway virtual phone'
     * @return string 'SCCP gateway virtual phone'
     */
    const VALUE_SCCP_GATEWAY_VIRTUAL_PHONE = 'SCCP gateway virtual phone';
    /**
     * Constant for value 'IP-STE'
     * @return string 'IP-STE'
     */
    const VALUE_IP_STE = 'IP-STE';
    /**
     * Constant for value 'Cisco 2801'
     * @return string 'Cisco 2801'
     */
    const VALUE_CISCO_2801 = 'Cisco 2801';
    /**
     * Constant for value 'Cisco 1861'
     * @return string 'Cisco 1861'
     */
    const VALUE_CISCO_1861 = 'Cisco 1861';
    /**
     * Constant for value 'VG204'
     * @return string 'VG204'
     */
    const VALUE_VG_204 = 'VG204';
    /**
     * Constant for value 'Cisco VGD-1T3'
     * @return string 'Cisco VGD-1T3'
     */
    const VALUE_CISCO_VGD_1_T_3 = 'Cisco VGD-1T3';
    /**
     * Constant for value 'VG202'
     * @return string 'VG202'
     */
    const VALUE_VG_202 = 'VG202';
    /**
     * Constant for value 'Cisco 881'
     * @return string 'Cisco 881'
     */
    const VALUE_CISCO_881 = 'Cisco 881';
    /**
     * Constant for value 'Cisco 2951'
     * @return string 'Cisco 2951'
     */
    const VALUE_CISCO_2951 = 'Cisco 2951';
    /**
     * Constant for value 'Cisco 3945'
     * @return string 'Cisco 3945'
     */
    const VALUE_CISCO_3945 = 'Cisco 3945';
    /**
     * Constant for value 'Cisco 888/887/886'
     * @return string 'Cisco 888/887/886'
     */
    const VALUE_CISCO_888_887_886 = 'Cisco 888/887/886';
    /**
     * Constant for value 'Cisco 2911'
     * @return string 'Cisco 2911'
     */
    const VALUE_CISCO_2911 = 'Cisco 2911';
    /**
     * Constant for value 'Cisco 3925'
     * @return string 'Cisco 3925'
     */
    const VALUE_CISCO_3925 = 'Cisco 3925';
    /**
     * Constant for value 'Cisco 2921'
     * @return string 'Cisco 2921'
     */
    const VALUE_CISCO_2921 = 'Cisco 2921';
    /**
     * Constant for value 'Cisco 2901'
     * @return string 'Cisco 2901'
     */
    const VALUE_CISCO_2901 = 'Cisco 2901';
    /**
     * Constant for value 'Cisco 3945E'
     * @return string 'Cisco 3945E'
     */
    const VALUE_CISCO_3945_E = 'Cisco 3945E';
    /**
     * Constant for value 'Cisco 3925E'
     * @return string 'Cisco 3925E'
     */
    const VALUE_CISCO_3925_E = 'Cisco 3925E';
    /**
     * Constant for value 'SPA8800'
     * @return string 'SPA8800'
     */
    const VALUE_SPA_8800 = 'SPA8800';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PILOT
     * @uses self::VALUE_CISCO_CATALYST_6000_T_1_VO_IP_GATEWAY
     * @uses self::VALUE_CISCO_CATALYST_6000_E_1_VO_IP_GATEWAY
     * @uses self::VALUE_CISCO_CATALYST_6000_24_PORT_FXS_GATEWAY
     * @uses self::VALUE_CISCO_CATALYST_6000_12_PORT_FXO_GATEWAY
     * @uses self::VALUE_EMCC_BASE_PHONE
     * @uses self::VALUE_H_323_CLIENT
     * @uses self::VALUE_H_323_GATEWAY
     * @uses self::VALUE_CISCO_MGCP_FXO_PORT
     * @uses self::VALUE_CISCO_MGCP_FXS_PORT
     * @uses self::VALUE_CISCO_12_SP
     * @uses self::VALUE_CISCO_12_SP_1
     * @uses self::VALUE_CISCO_12_S
     * @uses self::VALUE_CISCO_30_SP
     * @uses self::VALUE_CISCO_30_VIP
     * @uses self::VALUE_CTI_PORT
     * @uses self::VALUE_CISCO_VOICE_MAIL_PORT
     * @uses self::VALUE_CISCO_CONFERENCE_BRIDGE_SOFTWARE
     * @uses self::VALUE_CISCO_CONFERENCE_BRIDGE_HARDWARE
     * @uses self::VALUE_CISCO_MEDIA_TERMINATION_POINT_SOFTWARE
     * @uses self::VALUE_CISCO_MEDIA_TERMINATION_POINT_HARDWARE
     * @uses self::VALUE_CISCO_7935
     * @uses self::VALUE_SCCP_DEVICE
     * @uses self::VALUE_CISCO_7910
     * @uses self::VALUE_CISCO_7960
     * @uses self::VALUE_CISCO_7940
     * @uses self::VALUE_ROUTE_LIST
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_LOAD_SIMULATOR
     * @uses self::VALUE_GATEKEEPER
     * @uses self::VALUE_NM_1_V
     * @uses self::VALUE_NM_2_V
     * @uses self::VALUE_CISCO_VG_200
     * @uses self::VALUE_CISCO_26_XX
     * @uses self::VALUE_CISCO_362_X
     * @uses self::VALUE_CISCO_364_X
     * @uses self::VALUE_CISCO_366_X
     * @uses self::VALUE_CTI_ROUTE_POINT
     * @uses self::VALUE_MUSIC_ON_HOLD
     * @uses self::VALUE_CISCO_MGCP_T_1_PORT
     * @uses self::VALUE_NM_HDV
     * @uses self::VALUE_VIC_SLOT
     * @uses self::VALUE_CISCO_MGCP_E_1_PORT
     * @uses self::VALUE_VWIC_SLOT
     * @uses self::VALUE_FLEX_SLOT
     * @uses self::VALUE_CISCO_CATALYST_4224_VOICE_GATEWAY_SWITCH
     * @uses self::VALUE_CISCO_CATALYST_4000_ACCESS_GATEWAY_MODULE
     * @uses self::VALUE_CISCO_IOS_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_CISCO_IAD_2400
     * @uses self::VALUE_IAD_2400_ANALOG
     * @uses self::VALUE_IAD_2400_DIGITAL
     * @uses self::VALUE_CISCO_VGC_PHONE
     * @uses self::VALUE_CISCO_VG_248_GATEWAY
     * @uses self::VALUE_VGC_PORT
     * @uses self::VALUE_CISCO_VGC_VIRTUAL_PHONE
     * @uses self::VALUE_CISCO_ATA_186
     * @uses self::VALUE_H_225_TRUNK_GATEKEEPER_CONTROLLED
     * @uses self::VALUE_INTER_CLUSTER_TRUNK_GATEKEEPER_CONTROLLED
     * @uses self::VALUE_INTER_CLUSTER_TRUNK_NON_GATEKEEPER_CONTROLLED
     * @uses self::VALUE_COMMUNICATION_MEDIA_MODULE
     * @uses self::VALUE_WS_X_6600
     * @uses self::VALUE_AIM_VOICE_30
     * @uses self::VALUE_NM_HDA
     * @uses self::VALUE_PA_VXA
     * @uses self::VALUE_PA_VXB
     * @uses self::VALUE_PA_VXC
     * @uses self::VALUE_PA_MCX
     * @uses self::VALUE_ANNUNCIATOR
     * @uses self::VALUE_CISCO_MGCP_BRI_PORT
     * @uses self::VALUE_NM_HD_1_V
     * @uses self::VALUE_NM_HD_2_V
     * @uses self::VALUE_NM_HD_2_VE
     * @uses self::VALUE_SIP_TRUNK
     * @uses self::VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM
     * @uses self::VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS
     * @uses self::VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM
     * @uses self::VALUE_CISCO_IOS_ENHANCED_SOFTWARE_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_7914_14_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_CISCO_IOS_ENHANCED_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_ENHANCED_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX
     * @uses self::VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_HUNT_LIST
     * @uses self::VALUE_SIP_WSM_CONNECTION
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILE
     * @uses self::VALUE_CISCO_7941
     * @uses self::VALUE_CISCO_7971
     * @uses self::VALUE_CISCO_7985
     * @uses self::VALUE_CISCO_7911
     * @uses self::VALUE_CISCO_7961_G_GE
     * @uses self::VALUE_CISCO_7941_G_GE
     * @uses self::VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_MOTOROLA_CN_622
     * @uses self::VALUE_THIRD_PARTY_SIP_DEVICE_BASIC
     * @uses self::VALUE_CISCO_7931
     * @uses self::VALUE_CISCO_UNIFIED_PERSONAL_COMMUNICATOR
     * @uses self::VALUE_CISCO_7921
     * @uses self::VALUE_CISCO_7906
     * @uses self::VALUE_THIRD_PARTY_SIP_DEVICE_ADVANCED
     * @uses self::VALUE_CISCO_TELE_PRESENCE
     * @uses self::VALUE_NOKIA_S_60
     * @uses self::VALUE_CISCO_7962
     * @uses self::VALUE_CISCO_3951
     * @uses self::VALUE_CISCO_7937
     * @uses self::VALUE_CISCO_7942
     * @uses self::VALUE_CISCO_7945
     * @uses self::VALUE_CISCO_7965
     * @uses self::VALUE_CISCO_7975
     * @uses self::VALUE_CISCO_3911
     * @uses self::VALUE_CISCO_UNIFIED_MOBILE_COMMUNICATOR
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1000
     * @uses self::VALUE_CISCO_TELE_PRESENCE_3000
     * @uses self::VALUE_CISCO_TELE_PRESENCE_3200
     * @uses self::VALUE_CISCO_TELE_PRESENCE_500_37
     * @uses self::VALUE_CISCO_7925
     * @uses self::VALUE_CISCO_9971
     * @uses self::VALUE_CISCO_6921
     * @uses self::VALUE_CISCO_6941
     * @uses self::VALUE_CISCO_6961
     * @uses self::VALUE_CISCO_UNIFIED_CLIENT_SERVICES_FRAMEWORK
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1300_65
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1100
     * @uses self::VALUE_TRANSNOVA_S_3
     * @uses self::VALUE_CISCO_9951
     * @uses self::VALUE_CISCO_8961
     * @uses self::VALUE_CISCO_6901
     * @uses self::VALUE_CISCO_6911
     * @uses self::VALUE_CISCO_ATA_187
     * @uses self::VALUE_CISCO_TELE_PRESENCE_200
     * @uses self::VALUE_CISCO_TELE_PRESENCE_400
     * @uses self::VALUE_CISCO_DUAL_MODE_FOR_I_PHONE
     * @uses self::VALUE_CISCO_6945
     * @uses self::VALUE_CISCO_DUAL_MODE_FOR_ANDROID
     * @uses self::VALUE_CISCO_7926
     * @uses self::VALUE_CISCO_E_20
     * @uses self::VALUE_GENERIC_SINGLE_SCREEN_ROOM_SYSTEM
     * @uses self::VALUE_GENERIC_MULTIPLE_SCREEN_ROOM_SYSTEM
     * @uses self::VALUE_CISCO_TELE_PRESENCE_EX_90
     * @uses self::VALUE_CISCO_8945
     * @uses self::VALUE_CISCO_8941
     * @uses self::VALUE_GENERIC_DESKTOP_VIDEO_ENDPOINT
     * @uses self::VALUE_CISCO_TELE_PRESENCE_500_32
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1300_47
     * @uses self::VALUE_CISCO_3905
     * @uses self::VALUE_CISCO_CIUS
     * @uses self::VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1310_65
     * @uses self::VALUE_CISCO_TELE_PRESENCE_MCU
     * @uses self::VALUE_CISCO_TELE_PRESENCE_EX_60
     * @uses self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_90
     * @uses self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_60
     * @uses self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_40
     * @uses self::VALUE_CISCO_TELE_PRESENCE_QUICK_SET_C_20
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_20
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_40
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_DUAL_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_DUAL_C_90
     * @uses self::VALUE_CISCO_TELE_PRESENCE_MX_200
     * @uses self::VALUE_IMS_INTEGRATED_MOBILE_BASIC
     * @uses self::VALUE_CISCO_CIUS_SP
     * @uses self::VALUE_CISCO_TELE_PRESENCE_PROFILE_42_C_40
     * @uses self::VALUE_WS_SVC_CMM_MS
     * @uses self::VALUE_NM_4_VWIC_MBRD
     * @uses self::VALUE_VNM_HDA
     * @uses self::VALUE_NM_HDV_2_0_PORT
     * @uses self::VALUE_NM_HDV_2_1_PORT
     * @uses self::VALUE_NM_HDV_2_2_PORT
     * @uses self::VALUE_CISCO_3745
     * @uses self::VALUE_CISCO_3725
     * @uses self::VALUE_CISCO_7905
     * @uses self::VALUE_CISCO_7920
     * @uses self::VALUE_CISCO_269_X
     * @uses self::VALUE_CISCO_7970
     * @uses self::VALUE_CISCO_1760
     * @uses self::VALUE_CISCO_1751
     * @uses self::VALUE_CISCO_7912
     * @uses self::VALUE_CISCO_7902
     * @uses self::VALUE_VG_224
     * @uses self::VALUE_CISCO_2821
     * @uses self::VALUE_CISCO_IP_COMMUNICATOR
     * @uses self::VALUE_CISCO_7961
     * @uses self::VALUE_CISCO_7936
     * @uses self::VALUE_CISCO_3825
     * @uses self::VALUE_CISCO_3845
     * @uses self::VALUE_CISCO_2811
     * @uses self::VALUE_CISCO_2851
     * @uses self::VALUE_ANALOG_PHONE
     * @uses self::VALUE_ISDN_BRI_PHONE
     * @uses self::VALUE_SCCP_GATEWAY_VIRTUAL_PHONE
     * @uses self::VALUE_IP_STE
     * @uses self::VALUE_CISCO_2801
     * @uses self::VALUE_CISCO_1861
     * @uses self::VALUE_VG_204
     * @uses self::VALUE_CISCO_VGD_1_T_3
     * @uses self::VALUE_VG_202
     * @uses self::VALUE_CISCO_881
     * @uses self::VALUE_CISCO_2951
     * @uses self::VALUE_CISCO_3945
     * @uses self::VALUE_CISCO_888_887_886
     * @uses self::VALUE_CISCO_2911
     * @uses self::VALUE_CISCO_3925
     * @uses self::VALUE_CISCO_2921
     * @uses self::VALUE_CISCO_2901
     * @uses self::VALUE_CISCO_3945_E
     * @uses self::VALUE_CISCO_3925_E
     * @uses self::VALUE_SPA_8800
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PILOT,
            self::VALUE_CISCO_CATALYST_6000_T_1_VO_IP_GATEWAY,
            self::VALUE_CISCO_CATALYST_6000_E_1_VO_IP_GATEWAY,
            self::VALUE_CISCO_CATALYST_6000_24_PORT_FXS_GATEWAY,
            self::VALUE_CISCO_CATALYST_6000_12_PORT_FXO_GATEWAY,
            self::VALUE_EMCC_BASE_PHONE,
            self::VALUE_H_323_CLIENT,
            self::VALUE_H_323_GATEWAY,
            self::VALUE_CISCO_MGCP_FXO_PORT,
            self::VALUE_CISCO_MGCP_FXS_PORT,
            self::VALUE_CISCO_12_SP,
            self::VALUE_CISCO_12_SP_1,
            self::VALUE_CISCO_12_S,
            self::VALUE_CISCO_30_SP,
            self::VALUE_CISCO_30_VIP,
            self::VALUE_CTI_PORT,
            self::VALUE_CISCO_VOICE_MAIL_PORT,
            self::VALUE_CISCO_CONFERENCE_BRIDGE_SOFTWARE,
            self::VALUE_CISCO_CONFERENCE_BRIDGE_HARDWARE,
            self::VALUE_CISCO_MEDIA_TERMINATION_POINT_SOFTWARE,
            self::VALUE_CISCO_MEDIA_TERMINATION_POINT_HARDWARE,
            self::VALUE_CISCO_7935,
            self::VALUE_SCCP_DEVICE,
            self::VALUE_CISCO_7910,
            self::VALUE_CISCO_7960,
            self::VALUE_CISCO_7940,
            self::VALUE_ROUTE_LIST,
            self::VALUE_UNKNOWN,
            self::VALUE_LOAD_SIMULATOR,
            self::VALUE_GATEKEEPER,
            self::VALUE_NM_1_V,
            self::VALUE_NM_2_V,
            self::VALUE_CISCO_VG_200,
            self::VALUE_CISCO_26_XX,
            self::VALUE_CISCO_362_X,
            self::VALUE_CISCO_364_X,
            self::VALUE_CISCO_366_X,
            self::VALUE_CTI_ROUTE_POINT,
            self::VALUE_MUSIC_ON_HOLD,
            self::VALUE_CISCO_MGCP_T_1_PORT,
            self::VALUE_NM_HDV,
            self::VALUE_VIC_SLOT,
            self::VALUE_CISCO_MGCP_E_1_PORT,
            self::VALUE_VWIC_SLOT,
            self::VALUE_FLEX_SLOT,
            self::VALUE_CISCO_CATALYST_4224_VOICE_GATEWAY_SWITCH,
            self::VALUE_CISCO_CATALYST_4000_ACCESS_GATEWAY_MODULE,
            self::VALUE_CISCO_IOS_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT,
            self::VALUE_CISCO_IAD_2400,
            self::VALUE_IAD_2400_ANALOG,
            self::VALUE_IAD_2400_DIGITAL,
            self::VALUE_CISCO_VGC_PHONE,
            self::VALUE_CISCO_VG_248_GATEWAY,
            self::VALUE_VGC_PORT,
            self::VALUE_CISCO_VGC_VIRTUAL_PHONE,
            self::VALUE_CISCO_ATA_186,
            self::VALUE_H_225_TRUNK_GATEKEEPER_CONTROLLED,
            self::VALUE_INTER_CLUSTER_TRUNK_GATEKEEPER_CONTROLLED,
            self::VALUE_INTER_CLUSTER_TRUNK_NON_GATEKEEPER_CONTROLLED,
            self::VALUE_COMMUNICATION_MEDIA_MODULE,
            self::VALUE_WS_X_6600,
            self::VALUE_AIM_VOICE_30,
            self::VALUE_NM_HDA,
            self::VALUE_PA_VXA,
            self::VALUE_PA_VXB,
            self::VALUE_PA_VXC,
            self::VALUE_PA_MCX,
            self::VALUE_ANNUNCIATOR,
            self::VALUE_CISCO_MGCP_BRI_PORT,
            self::VALUE_NM_HD_1_V,
            self::VALUE_NM_HD_2_V,
            self::VALUE_NM_HD_2_VE,
            self::VALUE_SIP_TRUNK,
            self::VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM,
            self::VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS,
            self::VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM,
            self::VALUE_CISCO_IOS_ENHANCED_SOFTWARE_MEDIA_TERMINATION_POINT,
            self::VALUE_7914_14_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_CISCO_IOS_ENHANCED_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_ENHANCED_MEDIA_TERMINATION_POINT,
            self::VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX,
            self::VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_HUNT_LIST,
            self::VALUE_SIP_WSM_CONNECTION,
            self::VALUE_REMOTE_DESTINATION_PROFILE,
            self::VALUE_CISCO_7941,
            self::VALUE_CISCO_7971,
            self::VALUE_CISCO_7985,
            self::VALUE_CISCO_7911,
            self::VALUE_CISCO_7961_G_GE,
            self::VALUE_CISCO_7941_G_GE,
            self::VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_MOTOROLA_CN_622,
            self::VALUE_THIRD_PARTY_SIP_DEVICE_BASIC,
            self::VALUE_CISCO_7931,
            self::VALUE_CISCO_UNIFIED_PERSONAL_COMMUNICATOR,
            self::VALUE_CISCO_7921,
            self::VALUE_CISCO_7906,
            self::VALUE_THIRD_PARTY_SIP_DEVICE_ADVANCED,
            self::VALUE_CISCO_TELE_PRESENCE,
            self::VALUE_NOKIA_S_60,
            self::VALUE_CISCO_7962,
            self::VALUE_CISCO_3951,
            self::VALUE_CISCO_7937,
            self::VALUE_CISCO_7942,
            self::VALUE_CISCO_7945,
            self::VALUE_CISCO_7965,
            self::VALUE_CISCO_7975,
            self::VALUE_CISCO_3911,
            self::VALUE_CISCO_UNIFIED_MOBILE_COMMUNICATOR,
            self::VALUE_CISCO_TELE_PRESENCE_1000,
            self::VALUE_CISCO_TELE_PRESENCE_3000,
            self::VALUE_CISCO_TELE_PRESENCE_3200,
            self::VALUE_CISCO_TELE_PRESENCE_500_37,
            self::VALUE_CISCO_7925,
            self::VALUE_CISCO_9971,
            self::VALUE_CISCO_6921,
            self::VALUE_CISCO_6941,
            self::VALUE_CISCO_6961,
            self::VALUE_CISCO_UNIFIED_CLIENT_SERVICES_FRAMEWORK,
            self::VALUE_CISCO_TELE_PRESENCE_1300_65,
            self::VALUE_CISCO_TELE_PRESENCE_1100,
            self::VALUE_TRANSNOVA_S_3,
            self::VALUE_CISCO_9951,
            self::VALUE_CISCO_8961,
            self::VALUE_CISCO_6901,
            self::VALUE_CISCO_6911,
            self::VALUE_CISCO_ATA_187,
            self::VALUE_CISCO_TELE_PRESENCE_200,
            self::VALUE_CISCO_TELE_PRESENCE_400,
            self::VALUE_CISCO_DUAL_MODE_FOR_I_PHONE,
            self::VALUE_CISCO_6945,
            self::VALUE_CISCO_DUAL_MODE_FOR_ANDROID,
            self::VALUE_CISCO_7926,
            self::VALUE_CISCO_E_20,
            self::VALUE_GENERIC_SINGLE_SCREEN_ROOM_SYSTEM,
            self::VALUE_GENERIC_MULTIPLE_SCREEN_ROOM_SYSTEM,
            self::VALUE_CISCO_TELE_PRESENCE_EX_90,
            self::VALUE_CISCO_8945,
            self::VALUE_CISCO_8941,
            self::VALUE_GENERIC_DESKTOP_VIDEO_ENDPOINT,
            self::VALUE_CISCO_TELE_PRESENCE_500_32,
            self::VALUE_CISCO_TELE_PRESENCE_1300_47,
            self::VALUE_CISCO_3905,
            self::VALUE_CISCO_CIUS,
            self::VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_CISCO_TELE_PRESENCE_1310_65,
            self::VALUE_CISCO_TELE_PRESENCE_MCU,
            self::VALUE_CISCO_TELE_PRESENCE_EX_60,
            self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_90,
            self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_60,
            self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_40,
            self::VALUE_CISCO_TELE_PRESENCE_QUICK_SET_C_20,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_20,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_40,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_DUAL_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_DUAL_C_90,
            self::VALUE_CISCO_TELE_PRESENCE_MX_200,
            self::VALUE_IMS_INTEGRATED_MOBILE_BASIC,
            self::VALUE_CISCO_CIUS_SP,
            self::VALUE_CISCO_TELE_PRESENCE_PROFILE_42_C_40,
            self::VALUE_WS_SVC_CMM_MS,
            self::VALUE_NM_4_VWIC_MBRD,
            self::VALUE_VNM_HDA,
            self::VALUE_NM_HDV_2_0_PORT,
            self::VALUE_NM_HDV_2_1_PORT,
            self::VALUE_NM_HDV_2_2_PORT,
            self::VALUE_CISCO_3745,
            self::VALUE_CISCO_3725,
            self::VALUE_CISCO_7905,
            self::VALUE_CISCO_7920,
            self::VALUE_CISCO_269_X,
            self::VALUE_CISCO_7970,
            self::VALUE_CISCO_1760,
            self::VALUE_CISCO_1751,
            self::VALUE_CISCO_7912,
            self::VALUE_CISCO_7902,
            self::VALUE_VG_224,
            self::VALUE_CISCO_2821,
            self::VALUE_CISCO_IP_COMMUNICATOR,
            self::VALUE_CISCO_7961,
            self::VALUE_CISCO_7936,
            self::VALUE_CISCO_3825,
            self::VALUE_CISCO_3845,
            self::VALUE_CISCO_2811,
            self::VALUE_CISCO_2851,
            self::VALUE_ANALOG_PHONE,
            self::VALUE_ISDN_BRI_PHONE,
            self::VALUE_SCCP_GATEWAY_VIRTUAL_PHONE,
            self::VALUE_IP_STE,
            self::VALUE_CISCO_2801,
            self::VALUE_CISCO_1861,
            self::VALUE_VG_204,
            self::VALUE_CISCO_VGD_1_T_3,
            self::VALUE_VG_202,
            self::VALUE_CISCO_881,
            self::VALUE_CISCO_2951,
            self::VALUE_CISCO_3945,
            self::VALUE_CISCO_888_887_886,
            self::VALUE_CISCO_2911,
            self::VALUE_CISCO_3925,
            self::VALUE_CISCO_2921,
            self::VALUE_CISCO_2901,
            self::VALUE_CISCO_3945_E,
            self::VALUE_CISCO_3925_E,
            self::VALUE_SPA_8800,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
