<?php

namespace CUCM\EnumType;

/**
 * This class stands for XPermission EnumType
 * @subpackage Enumerations
 */
class XPermission
{
    /**
     * Constant for value 'NoAccess'
     * @return string 'NoAccess'
     */
    const VALUE_NO_ACCESS = 'NoAccess';
    /**
     * Constant for value 'ReadOnly'
     * @return string 'ReadOnly'
     */
    const VALUE_READ_ONLY = 'ReadOnly';
    /**
     * Constant for value 'FullAccess'
     * @return string 'FullAccess'
     */
    const VALUE_FULL_ACCESS = 'FullAccess';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_ACCESS
     * @uses self::VALUE_READ_ONLY
     * @uses self::VALUE_FULL_ACCESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_ACCESS,
            self::VALUE_READ_ONLY,
            self::VALUE_FULL_ACCESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
