<?php

namespace CUCM\EnumType;

/**
 * This class stands for XParam EnumType
 * @subpackage Enumerations
 */
class XParam
{
    /**
     * Constant for value 'boolean'
     * @return string 'boolean'
     */
    const VALUE_BOOLEAN = 'boolean';
    /**
     * Constant for value 'double'
     * @return string 'double'
     */
    const VALUE_DOUBLE = 'double';
    /**
     * Constant for value 'long'
     * @return string 'long'
     */
    const VALUE_LONG = 'long';
    /**
     * Constant for value 'string'
     * @return string 'string'
     */
    const VALUE_STRING = 'string';
    /**
     * Constant for value 'date/time'
     * @return string 'date/time'
     */
    const VALUE_DATE_TIME = 'date/time';
    /**
     * Constant for value 'any digit'
     * @return string 'any digit'
     */
    const VALUE_ANY_DIGIT = 'any digit';
    /**
     * Constant for value 'digits'
     * @return string 'digits'
     */
    const VALUE_DIGITS = 'digits';
    /**
     * Constant for value 'timeout'
     * @return string 'timeout'
     */
    const VALUE_TIMEOUT = 'timeout';
    /**
     * Constant for value 'terminating'
     * @return string 'terminating'
     */
    const VALUE_TERMINATING = 'terminating';
    /**
     * Constant for value 'more digits'
     * @return string 'more digits'
     */
    const VALUE_MORE_DIGITS = 'more digits';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_DOUBLE
     * @uses self::VALUE_LONG
     * @uses self::VALUE_STRING
     * @uses self::VALUE_DATE_TIME
     * @uses self::VALUE_ANY_DIGIT
     * @uses self::VALUE_DIGITS
     * @uses self::VALUE_TIMEOUT
     * @uses self::VALUE_TERMINATING
     * @uses self::VALUE_MORE_DIGITS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOOLEAN,
            self::VALUE_DOUBLE,
            self::VALUE_LONG,
            self::VALUE_STRING,
            self::VALUE_DATE_TIME,
            self::VALUE_ANY_DIGIT,
            self::VALUE_DIGITS,
            self::VALUE_TIMEOUT,
            self::VALUE_TERMINATING,
            self::VALUE_MORE_DIGITS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
