<?php

namespace CUCM\EnumType;

/**
 * This class stands for XNodeUsage EnumType
 * @subpackage Enumerations
 */
class XNodeUsage
{
    /**
     * Constant for value 'Publisher'
     * @return string 'Publisher'
     */
    const VALUE_PUBLISHER = 'Publisher';
    /**
     * Constant for value 'Subscriber'
     * @return string 'Subscriber'
     */
    const VALUE_SUBSCRIBER = 'Subscriber';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PUBLISHER
     * @uses self::VALUE_SUBSCRIBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PUBLISHER,
            self::VALUE_SUBSCRIBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
