<?php

namespace CUCM\EnumType;

/**
 * This class stands for XNodeAccess EnumType
 * @subpackage Enumerations
 */
class XNodeAccess
{
    /**
     * Constant for value 'Use Name'
     * @return string 'Use Name'
     */
    const VALUE_USE_NAME = 'Use Name';
    /**
     * Constant for value 'Use Name Plus Domain'
     * @return string 'Use Name Plus Domain'
     */
    const VALUE_USE_NAME_PLUS_DOMAIN = 'Use Name Plus Domain';
    /**
     * Constant for value 'Use IPV4'
     * @return string 'Use IPV4'
     */
    const VALUE_USE_IPV_4 = 'Use IPV4';
    /**
     * Constant for value 'Use IPV6'
     * @return string 'Use IPV6'
     */
    const VALUE_USE_IPV_6 = 'Use IPV6';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USE_NAME
     * @uses self::VALUE_USE_NAME_PLUS_DOMAIN
     * @uses self::VALUE_USE_IPV_4
     * @uses self::VALUE_USE_IPV_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_NAME,
            self::VALUE_USE_NAME_PLUS_DOMAIN,
            self::VALUE_USE_IPV_4,
            self::VALUE_USE_IPV_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
