<?php

namespace CUCM\EnumType;

/**
 * This class stands for XMonitor EnumType
 * @subpackage Enumerations
 */
class XMonitor
{
    /**
     * Constant for value 'Event Log'
     * @return string 'Event Log'
     */
    const VALUE_EVENT_LOG = 'Event Log';
    /**
     * Constant for value 'Sys Log'
     * @return string 'Sys Log'
     */
    const VALUE_SYS_LOG = 'Sys Log';
    /**
     * Constant for value 'AST'
     * @return string 'AST'
     */
    const VALUE_AST = 'AST';
    /**
     * Constant for value 'SDI'
     * @return string 'SDI'
     */
    const VALUE_SDI = 'SDI';
    /**
     * Constant for value 'SDL'
     * @return string 'SDL'
     */
    const VALUE_SDL = 'SDL';
    /**
     * Constant for value 'Data Collector'
     * @return string 'Data Collector'
     */
    const VALUE_DATA_COLLECTOR = 'Data Collector';
    /**
     * Constant for value 'SNMP Traps'
     * @return string 'SNMP Traps'
     */
    const VALUE_SNMP_TRAPS = 'SNMP Traps';
    /**
     * Constant for value 'Alert Manager'
     * @return string 'Alert Manager'
     */
    const VALUE_ALERT_MANAGER = 'Alert Manager';
    /**
     * Constant for value 'Alternate Syslog'
     * @return string 'Alternate Syslog'
     */
    const VALUE_ALTERNATE_SYSLOG = 'Alternate Syslog';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EVENT_LOG
     * @uses self::VALUE_SYS_LOG
     * @uses self::VALUE_AST
     * @uses self::VALUE_SDI
     * @uses self::VALUE_SDL
     * @uses self::VALUE_DATA_COLLECTOR
     * @uses self::VALUE_SNMP_TRAPS
     * @uses self::VALUE_ALERT_MANAGER
     * @uses self::VALUE_ALTERNATE_SYSLOG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EVENT_LOG,
            self::VALUE_SYS_LOG,
            self::VALUE_AST,
            self::VALUE_SDI,
            self::VALUE_SDL,
            self::VALUE_DATA_COLLECTOR,
            self::VALUE_SNMP_TRAPS,
            self::VALUE_ALERT_MANAGER,
            self::VALUE_ALTERNATE_SYSLOG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
