<?php

namespace CUCM\EnumType;

/**
 * This class stands for XModel EnumType
 * @subpackage Enumerations
 */
class XModel
{
    /**
     * Constant for value 'Cisco 30 SP+'
     * @return string 'Cisco 30 SP+'
     */
    const VALUE_CISCO_30_SP = 'Cisco 30 SP+';
    /**
     * Constant for value 'Cisco 12 SP+'
     * @return string 'Cisco 12 SP+'
     */
    const VALUE_CISCO_12_SP = 'Cisco 12 SP+';
    /**
     * Constant for value 'Cisco 12 SP'
     * @return string 'Cisco 12 SP'
     */
    const VALUE_CISCO_12_SP_1 = 'Cisco 12 SP';
    /**
     * Constant for value 'Cisco 12 S'
     * @return string 'Cisco 12 S'
     */
    const VALUE_CISCO_12_S = 'Cisco 12 S';
    /**
     * Constant for value 'Cisco 30 VIP'
     * @return string 'Cisco 30 VIP'
     */
    const VALUE_CISCO_30_VIP = 'Cisco 30 VIP';
    /**
     * Constant for value 'Cisco 7910'
     * @return string 'Cisco 7910'
     */
    const VALUE_CISCO_7910 = 'Cisco 7910';
    /**
     * Constant for value 'Cisco 7960'
     * @return string 'Cisco 7960'
     */
    const VALUE_CISCO_7960 = 'Cisco 7960';
    /**
     * Constant for value 'Cisco 7940'
     * @return string 'Cisco 7940'
     */
    const VALUE_CISCO_7940 = 'Cisco 7940';
    /**
     * Constant for value 'Cisco 7935'
     * @return string 'Cisco 7935'
     */
    const VALUE_CISCO_7935 = 'Cisco 7935';
    /**
     * Constant for value 'Cisco VGC Phone'
     * @return string 'Cisco VGC Phone'
     */
    const VALUE_CISCO_VGC_PHONE = 'Cisco VGC Phone';
    /**
     * Constant for value 'Cisco VGC Virtual Phone'
     * @return string 'Cisco VGC Virtual Phone'
     */
    const VALUE_CISCO_VGC_VIRTUAL_PHONE = 'Cisco VGC Virtual Phone';
    /**
     * Constant for value 'Cisco ATA 186'
     * @return string 'Cisco ATA 186'
     */
    const VALUE_CISCO_ATA_186 = 'Cisco ATA 186';
    /**
     * Constant for value 'EMCC Base Phone'
     * @return string 'EMCC Base Phone'
     */
    const VALUE_EMCC_BASE_PHONE = 'EMCC Base Phone';
    /**
     * Constant for value 'SCCP Phone'
     * @return string 'SCCP Phone'
     */
    const VALUE_SCCP_PHONE = 'SCCP Phone';
    /**
     * Constant for value 'Analog Access'
     * @return string 'Analog Access'
     */
    const VALUE_ANALOG_ACCESS = 'Analog Access';
    /**
     * Constant for value 'Digital Access'
     * @return string 'Digital Access'
     */
    const VALUE_DIGITAL_ACCESS = 'Digital Access';
    /**
     * Constant for value 'Digital Access+'
     * @return string 'Digital Access+'
     */
    const VALUE_DIGITAL_ACCESS_1 = 'Digital Access+';
    /**
     * Constant for value 'Digital Access WS-X6608'
     * @return string 'Digital Access WS-X6608'
     */
    const VALUE_DIGITAL_ACCESS_WS_X_6608 = 'Digital Access WS-X6608';
    /**
     * Constant for value 'Analog Access WS-X6624'
     * @return string 'Analog Access WS-X6624'
     */
    const VALUE_ANALOG_ACCESS_WS_X_6624 = 'Analog Access WS-X6624';
    /**
     * Constant for value 'VGC Gateway'
     * @return string 'VGC Gateway'
     */
    const VALUE_VGC_GATEWAY = 'VGC Gateway';
    /**
     * Constant for value 'Conference Bridge'
     * @return string 'Conference Bridge'
     */
    const VALUE_CONFERENCE_BRIDGE = 'Conference Bridge';
    /**
     * Constant for value 'Conference Bridge WS-X6608'
     * @return string 'Conference Bridge WS-X6608'
     */
    const VALUE_CONFERENCE_BRIDGE_WS_X_6608 = 'Conference Bridge WS-X6608';
    /**
     * Constant for value 'Cisco IOS Conference Bridge (HDV2)'
     * @return string 'Cisco IOS Conference Bridge (HDV2)'
     */
    const VALUE_CISCO_IOS_CONFERENCE_BRIDGE_HDV_2 = 'Cisco IOS Conference Bridge (HDV2)';
    /**
     * Constant for value 'Cisco Conference Bridge (WS-SVC-CMM)'
     * @return string 'Cisco Conference Bridge (WS-SVC-CMM)'
     */
    const VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM = 'Cisco Conference Bridge (WS-SVC-CMM)';
    /**
     * Constant for value 'H.323 Phone'
     * @return string 'H.323 Phone'
     */
    const VALUE_H_323_PHONE = 'H.323 Phone';
    /**
     * Constant for value 'H.323 Gateway'
     * @return string 'H.323 Gateway'
     */
    const VALUE_H_323_GATEWAY = 'H.323 Gateway';
    /**
     * Constant for value 'Music On Hold'
     * @return string 'Music On Hold'
     */
    const VALUE_MUSIC_ON_HOLD = 'Music On Hold';
    /**
     * Constant for value 'Device Pilot'
     * @return string 'Device Pilot'
     */
    const VALUE_DEVICE_PILOT = 'Device Pilot';
    /**
     * Constant for value 'CTI Port'
     * @return string 'CTI Port'
     */
    const VALUE_CTI_PORT = 'CTI Port';
    /**
     * Constant for value 'CTI Route Point'
     * @return string 'CTI Route Point'
     */
    const VALUE_CTI_ROUTE_POINT = 'CTI Route Point';
    /**
     * Constant for value 'Voice Mail Port'
     * @return string 'Voice Mail Port'
     */
    const VALUE_VOICE_MAIL_PORT = 'Voice Mail Port';
    /**
     * Constant for value 'Cisco IOS Software Media Termination Point (HDV2)'
     * @return string 'Cisco IOS Software Media Termination Point (HDV2)'
     */
    const VALUE_CISCO_IOS_SOFTWARE_MEDIA_TERMINATION_POINT_HDV_2 = 'Cisco IOS Software Media Termination Point (HDV2)';
    /**
     * Constant for value 'Cisco Media Server (WS-SVC-CMM-MS)'
     * @return string 'Cisco Media Server (WS-SVC-CMM-MS)'
     */
    const VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS = 'Cisco Media Server (WS-SVC-CMM-MS)';
    /**
     * Constant for value 'Cisco Video Conference Bridge (IPVC-35xx)'
     * @return string 'Cisco Video Conference Bridge (IPVC-35xx)'
     */
    const VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX = 'Cisco Video Conference Bridge (IPVC-35xx)';
    /**
     * Constant for value 'Cisco IOS Heterogeneous Video Conference Bridge'
     * @return string 'Cisco IOS Heterogeneous Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Heterogeneous Video Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Guaranteed Audio Video Conference Bridge'
     * @return string 'Cisco IOS Guaranteed Audio Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Guaranteed Audio Video Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Homogeneous Video Conference Bridge'
     * @return string 'Cisco IOS Homogeneous Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Homogeneous Video Conference Bridge';
    /**
     * Constant for value 'Route List'
     * @return string 'Route List'
     */
    const VALUE_ROUTE_LIST = 'Route List';
    /**
     * Constant for value 'Load Simulator'
     * @return string 'Load Simulator'
     */
    const VALUE_LOAD_SIMULATOR = 'Load Simulator';
    /**
     * Constant for value 'Media Termination Point'
     * @return string 'Media Termination Point'
     */
    const VALUE_MEDIA_TERMINATION_POINT = 'Media Termination Point';
    /**
     * Constant for value 'Media Termination Point Hardware'
     * @return string 'Media Termination Point Hardware'
     */
    const VALUE_MEDIA_TERMINATION_POINT_HARDWARE = 'Media Termination Point Hardware';
    /**
     * Constant for value 'Cisco IOS Media Termination Point (HDV2)'
     * @return string 'Cisco IOS Media Termination Point (HDV2)'
     */
    const VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT_HDV_2 = 'Cisco IOS Media Termination Point (HDV2)';
    /**
     * Constant for value 'Cisco Media Termination Point (WS-SVC-CMM)'
     * @return string 'Cisco Media Termination Point (WS-SVC-CMM)'
     */
    const VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM = 'Cisco Media Termination Point (WS-SVC-CMM)';
    /**
     * Constant for value 'Cisco 7941'
     * @return string 'Cisco 7941'
     */
    const VALUE_CISCO_7941 = 'Cisco 7941';
    /**
     * Constant for value 'Cisco 7971'
     * @return string 'Cisco 7971'
     */
    const VALUE_CISCO_7971 = 'Cisco 7971';
    /**
     * Constant for value 'MGCP Station'
     * @return string 'MGCP Station'
     */
    const VALUE_MGCP_STATION = 'MGCP Station';
    /**
     * Constant for value 'MGCP Trunk'
     * @return string 'MGCP Trunk'
     */
    const VALUE_MGCP_TRUNK = 'MGCP Trunk';
    /**
     * Constant for value 'GateKeeper'
     * @return string 'GateKeeper'
     */
    const VALUE_GATE_KEEPER = 'GateKeeper';
    /**
     * Constant for value '7914 14-Button Line Expansion Module'
     * @return string '7914 14-Button Line Expansion Module'
     */
    const VALUE_7914_14_BUTTON_LINE_EXPANSION_MODULE = '7914 14-Button Line Expansion Module';
    /**
     * Constant for value 'Trunk'
     * @return string 'Trunk'
     */
    const VALUE_TRUNK = 'Trunk';
    /**
     * Constant for value 'Tone Announcement Player'
     * @return string 'Tone Announcement Player'
     */
    const VALUE_TONE_ANNOUNCEMENT_PLAYER = 'Tone Announcement Player';
    /**
     * Constant for value 'SIP Trunk'
     * @return string 'SIP Trunk'
     */
    const VALUE_SIP_TRUNK = 'SIP Trunk';
    /**
     * Constant for value 'SIP Gateway'
     * @return string 'SIP Gateway'
     */
    const VALUE_SIP_GATEWAY = 'SIP Gateway';
    /**
     * Constant for value 'WSM Trunk'
     * @return string 'WSM Trunk'
     */
    const VALUE_WSM_TRUNK = 'WSM Trunk';
    /**
     * Constant for value 'Remote Destination Profile'
     * @return string 'Remote Destination Profile'
     */
    const VALUE_REMOTE_DESTINATION_PROFILE = 'Remote Destination Profile';
    /**
     * Constant for value '7915 12-Button Line Expansion Module'
     * @return string '7915 12-Button Line Expansion Module'
     */
    const VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE = '7915 12-Button Line Expansion Module';
    /**
     * Constant for value '7915 24-Button Line Expansion Module'
     * @return string '7915 24-Button Line Expansion Module'
     */
    const VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE = '7915 24-Button Line Expansion Module';
    /**
     * Constant for value '7916 12-Button Line Expansion Module'
     * @return string '7916 12-Button Line Expansion Module'
     */
    const VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE = '7916 12-Button Line Expansion Module';
    /**
     * Constant for value '7916 24-Button Line Expansion Module'
     * @return string '7916 24-Button Line Expansion Module'
     */
    const VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE = '7916 24-Button Line Expansion Module';
    /**
     * Constant for value 'CKEM 36-Button Line Expansion Module'
     * @return string 'CKEM 36-Button Line Expansion Module'
     */
    const VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE = 'CKEM 36-Button Line Expansion Module';
    /**
     * Constant for value 'SPA8800'
     * @return string 'SPA8800'
     */
    const VALUE_SPA_8800 = 'SPA8800';
    /**
     * Constant for value 'Unknown MGCP Gateway'
     * @return string 'Unknown MGCP Gateway'
     */
    const VALUE_UNKNOWN_MGCP_GATEWAY = 'Unknown MGCP Gateway';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Cisco 7985'
     * @return string 'Cisco 7985'
     */
    const VALUE_CISCO_7985 = 'Cisco 7985';
    /**
     * Constant for value 'Cisco 7911'
     * @return string 'Cisco 7911'
     */
    const VALUE_CISCO_7911 = 'Cisco 7911';
    /**
     * Constant for value 'Cisco 7961G-GE'
     * @return string 'Cisco 7961G-GE'
     */
    const VALUE_CISCO_7961_G_GE = 'Cisco 7961G-GE';
    /**
     * Constant for value 'Cisco 7941G-GE'
     * @return string 'Cisco 7941G-GE'
     */
    const VALUE_CISCO_7941_G_GE = 'Cisco 7941G-GE';
    /**
     * Constant for value 'Motorola CN622'
     * @return string 'Motorola CN622'
     */
    const VALUE_MOTOROLA_CN_622 = 'Motorola CN622';
    /**
     * Constant for value 'Third-party SIP Device (Basic)'
     * @return string 'Third-party SIP Device (Basic)'
     */
    const VALUE_THIRD_PARTY_SIP_DEVICE_BASIC = 'Third-party SIP Device (Basic)';
    /**
     * Constant for value 'Cisco 7931'
     * @return string 'Cisco 7931'
     */
    const VALUE_CISCO_7931 = 'Cisco 7931';
    /**
     * Constant for value 'Cisco Unified Personal Communicator'
     * @return string 'Cisco Unified Personal Communicator'
     */
    const VALUE_CISCO_UNIFIED_PERSONAL_COMMUNICATOR = 'Cisco Unified Personal Communicator';
    /**
     * Constant for value 'Cisco 7921'
     * @return string 'Cisco 7921'
     */
    const VALUE_CISCO_7921 = 'Cisco 7921';
    /**
     * Constant for value 'Cisco 7906'
     * @return string 'Cisco 7906'
     */
    const VALUE_CISCO_7906 = 'Cisco 7906';
    /**
     * Constant for value 'Third-party SIP Device (Advanced)'
     * @return string 'Third-party SIP Device (Advanced)'
     */
    const VALUE_THIRD_PARTY_SIP_DEVICE_ADVANCED = 'Third-party SIP Device (Advanced)';
    /**
     * Constant for value 'Cisco TelePresence'
     * @return string 'Cisco TelePresence'
     */
    const VALUE_CISCO_TELE_PRESENCE = 'Cisco TelePresence';
    /**
     * Constant for value 'Nokia S60'
     * @return string 'Nokia S60'
     */
    const VALUE_NOKIA_S_60 = 'Nokia S60';
    /**
     * Constant for value 'Cisco 7962'
     * @return string 'Cisco 7962'
     */
    const VALUE_CISCO_7962 = 'Cisco 7962';
    /**
     * Constant for value 'Cisco 3951'
     * @return string 'Cisco 3951'
     */
    const VALUE_CISCO_3951 = 'Cisco 3951';
    /**
     * Constant for value 'Cisco 7937'
     * @return string 'Cisco 7937'
     */
    const VALUE_CISCO_7937 = 'Cisco 7937';
    /**
     * Constant for value 'Cisco 7942'
     * @return string 'Cisco 7942'
     */
    const VALUE_CISCO_7942 = 'Cisco 7942';
    /**
     * Constant for value 'Cisco 7945'
     * @return string 'Cisco 7945'
     */
    const VALUE_CISCO_7945 = 'Cisco 7945';
    /**
     * Constant for value 'Cisco 7965'
     * @return string 'Cisco 7965'
     */
    const VALUE_CISCO_7965 = 'Cisco 7965';
    /**
     * Constant for value 'Cisco 7975'
     * @return string 'Cisco 7975'
     */
    const VALUE_CISCO_7975 = 'Cisco 7975';
    /**
     * Constant for value 'Cisco 3911'
     * @return string 'Cisco 3911'
     */
    const VALUE_CISCO_3911 = 'Cisco 3911';
    /**
     * Constant for value 'Cisco Unified Mobile Communicator'
     * @return string 'Cisco Unified Mobile Communicator'
     */
    const VALUE_CISCO_UNIFIED_MOBILE_COMMUNICATOR = 'Cisco Unified Mobile Communicator';
    /**
     * Constant for value 'Cisco TelePresence 1000'
     * @return string 'Cisco TelePresence 1000'
     */
    const VALUE_CISCO_TELE_PRESENCE_1000 = 'Cisco TelePresence 1000';
    /**
     * Constant for value 'Cisco TelePresence 3000'
     * @return string 'Cisco TelePresence 3000'
     */
    const VALUE_CISCO_TELE_PRESENCE_3000 = 'Cisco TelePresence 3000';
    /**
     * Constant for value 'Cisco TelePresence 3200'
     * @return string 'Cisco TelePresence 3200'
     */
    const VALUE_CISCO_TELE_PRESENCE_3200 = 'Cisco TelePresence 3200';
    /**
     * Constant for value 'Cisco TelePresence 500-37'
     * @return string 'Cisco TelePresence 500-37'
     */
    const VALUE_CISCO_TELE_PRESENCE_500_37 = 'Cisco TelePresence 500-37';
    /**
     * Constant for value 'Cisco 7925'
     * @return string 'Cisco 7925'
     */
    const VALUE_CISCO_7925 = 'Cisco 7925';
    /**
     * Constant for value 'Cisco 9971'
     * @return string 'Cisco 9971'
     */
    const VALUE_CISCO_9971 = 'Cisco 9971';
    /**
     * Constant for value 'Cisco 6921'
     * @return string 'Cisco 6921'
     */
    const VALUE_CISCO_6921 = 'Cisco 6921';
    /**
     * Constant for value 'Cisco 6941'
     * @return string 'Cisco 6941'
     */
    const VALUE_CISCO_6941 = 'Cisco 6941';
    /**
     * Constant for value 'Cisco 6961'
     * @return string 'Cisco 6961'
     */
    const VALUE_CISCO_6961 = 'Cisco 6961';
    /**
     * Constant for value 'Cisco Unified Client Services Framework'
     * @return string 'Cisco Unified Client Services Framework'
     */
    const VALUE_CISCO_UNIFIED_CLIENT_SERVICES_FRAMEWORK = 'Cisco Unified Client Services Framework';
    /**
     * Constant for value 'Cisco TelePresence 1300-65'
     * @return string 'Cisco TelePresence 1300-65'
     */
    const VALUE_CISCO_TELE_PRESENCE_1300_65 = 'Cisco TelePresence 1300-65';
    /**
     * Constant for value 'Cisco TelePresence 1100'
     * @return string 'Cisco TelePresence 1100'
     */
    const VALUE_CISCO_TELE_PRESENCE_1100 = 'Cisco TelePresence 1100';
    /**
     * Constant for value 'Transnova S3'
     * @return string 'Transnova S3'
     */
    const VALUE_TRANSNOVA_S_3 = 'Transnova S3';
    /**
     * Constant for value 'Usage Profile'
     * @return string 'Usage Profile'
     */
    const VALUE_USAGE_PROFILE = 'Usage Profile';
    /**
     * Constant for value 'Cisco 9951'
     * @return string 'Cisco 9951'
     */
    const VALUE_CISCO_9951 = 'Cisco 9951';
    /**
     * Constant for value 'Cisco 8961'
     * @return string 'Cisco 8961'
     */
    const VALUE_CISCO_8961 = 'Cisco 8961';
    /**
     * Constant for value 'Cisco 6901'
     * @return string 'Cisco 6901'
     */
    const VALUE_CISCO_6901 = 'Cisco 6901';
    /**
     * Constant for value 'Cisco 6911'
     * @return string 'Cisco 6911'
     */
    const VALUE_CISCO_6911 = 'Cisco 6911';
    /**
     * Constant for value 'Cisco ATA 187'
     * @return string 'Cisco ATA 187'
     */
    const VALUE_CISCO_ATA_187 = 'Cisco ATA 187';
    /**
     * Constant for value 'Cisco TelePresence 200'
     * @return string 'Cisco TelePresence 200'
     */
    const VALUE_CISCO_TELE_PRESENCE_200 = 'Cisco TelePresence 200';
    /**
     * Constant for value 'Cisco TelePresence 400'
     * @return string 'Cisco TelePresence 400'
     */
    const VALUE_CISCO_TELE_PRESENCE_400 = 'Cisco TelePresence 400';
    /**
     * Constant for value 'Cisco Dual Mode for iPhone'
     * @return string 'Cisco Dual Mode for iPhone'
     */
    const VALUE_CISCO_DUAL_MODE_FOR_I_PHONE = 'Cisco Dual Mode for iPhone';
    /**
     * Constant for value 'Cisco 6945'
     * @return string 'Cisco 6945'
     */
    const VALUE_CISCO_6945 = 'Cisco 6945';
    /**
     * Constant for value 'Cisco Dual Mode for Android'
     * @return string 'Cisco Dual Mode for Android'
     */
    const VALUE_CISCO_DUAL_MODE_FOR_ANDROID = 'Cisco Dual Mode for Android';
    /**
     * Constant for value 'Cisco 7926'
     * @return string 'Cisco 7926'
     */
    const VALUE_CISCO_7926 = 'Cisco 7926';
    /**
     * Constant for value 'Cisco E20'
     * @return string 'Cisco E20'
     */
    const VALUE_CISCO_E_20 = 'Cisco E20';
    /**
     * Constant for value 'Generic Single Screen Room System'
     * @return string 'Generic Single Screen Room System'
     */
    const VALUE_GENERIC_SINGLE_SCREEN_ROOM_SYSTEM = 'Generic Single Screen Room System';
    /**
     * Constant for value 'Generic Multiple Screen Room System'
     * @return string 'Generic Multiple Screen Room System'
     */
    const VALUE_GENERIC_MULTIPLE_SCREEN_ROOM_SYSTEM = 'Generic Multiple Screen Room System';
    /**
     * Constant for value 'Cisco TelePresence EX90'
     * @return string 'Cisco TelePresence EX90'
     */
    const VALUE_CISCO_TELE_PRESENCE_EX_90 = 'Cisco TelePresence EX90';
    /**
     * Constant for value 'Cisco 8945'
     * @return string 'Cisco 8945'
     */
    const VALUE_CISCO_8945 = 'Cisco 8945';
    /**
     * Constant for value 'Cisco 8941'
     * @return string 'Cisco 8941'
     */
    const VALUE_CISCO_8941 = 'Cisco 8941';
    /**
     * Constant for value 'Generic Desktop Video Endpoint'
     * @return string 'Generic Desktop Video Endpoint'
     */
    const VALUE_GENERIC_DESKTOP_VIDEO_ENDPOINT = 'Generic Desktop Video Endpoint';
    /**
     * Constant for value 'Cisco TelePresence 500-32'
     * @return string 'Cisco TelePresence 500-32'
     */
    const VALUE_CISCO_TELE_PRESENCE_500_32 = 'Cisco TelePresence 500-32';
    /**
     * Constant for value 'Cisco TelePresence 1300-47'
     * @return string 'Cisco TelePresence 1300-47'
     */
    const VALUE_CISCO_TELE_PRESENCE_1300_47 = 'Cisco TelePresence 1300-47';
    /**
     * Constant for value 'Cisco 3905'
     * @return string 'Cisco 3905'
     */
    const VALUE_CISCO_3905 = 'Cisco 3905';
    /**
     * Constant for value 'Cisco Cius'
     * @return string 'Cisco Cius'
     */
    const VALUE_CISCO_CIUS = 'Cisco Cius';
    /**
     * Constant for value 'VKEM 36-Button Line Expansion Module'
     * @return string 'VKEM 36-Button Line Expansion Module'
     */
    const VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE = 'VKEM 36-Button Line Expansion Module';
    /**
     * Constant for value 'Cisco TelePresence 1310-65'
     * @return string 'Cisco TelePresence 1310-65'
     */
    const VALUE_CISCO_TELE_PRESENCE_1310_65 = 'Cisco TelePresence 1310-65';
    /**
     * Constant for value 'Cisco TelePresence MCU'
     * @return string 'Cisco TelePresence MCU'
     */
    const VALUE_CISCO_TELE_PRESENCE_MCU = 'Cisco TelePresence MCU';
    /**
     * Constant for value 'Cisco TelePresence EX60'
     * @return string 'Cisco TelePresence EX60'
     */
    const VALUE_CISCO_TELE_PRESENCE_EX_60 = 'Cisco TelePresence EX60';
    /**
     * Constant for value 'Cisco TelePresence Codec C90'
     * @return string 'Cisco TelePresence Codec C90'
     */
    const VALUE_CISCO_TELE_PRESENCE_CODEC_C_90 = 'Cisco TelePresence Codec C90';
    /**
     * Constant for value 'Cisco TelePresence Codec C60'
     * @return string 'Cisco TelePresence Codec C60'
     */
    const VALUE_CISCO_TELE_PRESENCE_CODEC_C_60 = 'Cisco TelePresence Codec C60';
    /**
     * Constant for value 'Cisco TelePresence Codec C40'
     * @return string 'Cisco TelePresence Codec C40'
     */
    const VALUE_CISCO_TELE_PRESENCE_CODEC_C_40 = 'Cisco TelePresence Codec C40';
    /**
     * Constant for value 'Cisco TelePresence Quick Set C20'
     * @return string 'Cisco TelePresence Quick Set C20'
     */
    const VALUE_CISCO_TELE_PRESENCE_QUICK_SET_C_20 = 'Cisco TelePresence Quick Set C20';
    /**
     * Constant for value 'Cisco Telepresence Profile 42 (C20)'
     * @return string 'Cisco Telepresence Profile 42 (C20)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_20 = 'Cisco Telepresence Profile 42 (C20)';
    /**
     * Constant for value 'Cisco Telepresence Profile 42 (C60)'
     * @return string 'Cisco Telepresence Profile 42 (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_60 = 'Cisco Telepresence Profile 42 (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 52 (C40)'
     * @return string 'Cisco Telepresence Profile 52 (C40)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_40 = 'Cisco Telepresence Profile 52 (C40)';
    /**
     * Constant for value 'Cisco Telepresence Profile 52 (C60)'
     * @return string 'Cisco Telepresence Profile 52 (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_60 = 'Cisco Telepresence Profile 52 (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 52 Dual (C60)'
     * @return string 'Cisco Telepresence Profile 52 Dual (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_52_DUAL_C_60 = 'Cisco Telepresence Profile 52 Dual (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 65 (C60)'
     * @return string 'Cisco Telepresence Profile 65 (C60)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_65_C_60 = 'Cisco Telepresence Profile 65 (C60)';
    /**
     * Constant for value 'Cisco Telepresence Profile 65 Dual (C90)'
     * @return string 'Cisco Telepresence Profile 65 Dual (C90)'
     */
    const VALUE_CISCO_TELEPRESENCE_PROFILE_65_DUAL_C_90 = 'Cisco Telepresence Profile 65 Dual (C90)';
    /**
     * Constant for value 'Cisco TelePresence MX200'
     * @return string 'Cisco TelePresence MX200'
     */
    const VALUE_CISCO_TELE_PRESENCE_MX_200 = 'Cisco TelePresence MX200';
    /**
     * Constant for value 'IMS-integrated Mobile (Basic)'
     * @return string 'IMS-integrated Mobile (Basic)'
     */
    const VALUE_IMS_INTEGRATED_MOBILE_BASIC = 'IMS-integrated Mobile (Basic)';
    /**
     * Constant for value 'Cisco Cius SP'
     * @return string 'Cisco Cius SP'
     */
    const VALUE_CISCO_CIUS_SP = 'Cisco Cius SP';
    /**
     * Constant for value 'Cisco TelePresence Profile 42 (C40)'
     * @return string 'Cisco TelePresence Profile 42 (C40)'
     */
    const VALUE_CISCO_TELE_PRESENCE_PROFILE_42_C_40 = 'Cisco TelePresence Profile 42 (C40)';
    /**
     * Constant for value 'Cisco 7905'
     * @return string 'Cisco 7905'
     */
    const VALUE_CISCO_7905 = 'Cisco 7905';
    /**
     * Constant for value 'Cisco 7920'
     * @return string 'Cisco 7920'
     */
    const VALUE_CISCO_7920 = 'Cisco 7920';
    /**
     * Constant for value 'Cisco 7970'
     * @return string 'Cisco 7970'
     */
    const VALUE_CISCO_7970 = 'Cisco 7970';
    /**
     * Constant for value 'Cisco 7912'
     * @return string 'Cisco 7912'
     */
    const VALUE_CISCO_7912 = 'Cisco 7912';
    /**
     * Constant for value 'Cisco 7902'
     * @return string 'Cisco 7902'
     */
    const VALUE_CISCO_7902 = 'Cisco 7902';
    /**
     * Constant for value 'Cisco IP Communicator'
     * @return string 'Cisco IP Communicator'
     */
    const VALUE_CISCO_IP_COMMUNICATOR = 'Cisco IP Communicator';
    /**
     * Constant for value 'Cisco 7961'
     * @return string 'Cisco 7961'
     */
    const VALUE_CISCO_7961 = 'Cisco 7961';
    /**
     * Constant for value 'Cisco 7936'
     * @return string 'Cisco 7936'
     */
    const VALUE_CISCO_7936 = 'Cisco 7936';
    /**
     * Constant for value 'Analog Phone'
     * @return string 'Analog Phone'
     */
    const VALUE_ANALOG_PHONE = 'Analog Phone';
    /**
     * Constant for value 'ISDN BRI Phone'
     * @return string 'ISDN BRI Phone'
     */
    const VALUE_ISDN_BRI_PHONE = 'ISDN BRI Phone';
    /**
     * Constant for value 'SCCP gateway virtual phone'
     * @return string 'SCCP gateway virtual phone'
     */
    const VALUE_SCCP_GATEWAY_VIRTUAL_PHONE = 'SCCP gateway virtual phone';
    /**
     * Constant for value 'IP-STE'
     * @return string 'IP-STE'
     */
    const VALUE_IP_STE = 'IP-STE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CISCO_30_SP
     * @uses self::VALUE_CISCO_12_SP
     * @uses self::VALUE_CISCO_12_SP_1
     * @uses self::VALUE_CISCO_12_S
     * @uses self::VALUE_CISCO_30_VIP
     * @uses self::VALUE_CISCO_7910
     * @uses self::VALUE_CISCO_7960
     * @uses self::VALUE_CISCO_7940
     * @uses self::VALUE_CISCO_7935
     * @uses self::VALUE_CISCO_VGC_PHONE
     * @uses self::VALUE_CISCO_VGC_VIRTUAL_PHONE
     * @uses self::VALUE_CISCO_ATA_186
     * @uses self::VALUE_EMCC_BASE_PHONE
     * @uses self::VALUE_SCCP_PHONE
     * @uses self::VALUE_ANALOG_ACCESS
     * @uses self::VALUE_DIGITAL_ACCESS
     * @uses self::VALUE_DIGITAL_ACCESS_1
     * @uses self::VALUE_DIGITAL_ACCESS_WS_X_6608
     * @uses self::VALUE_ANALOG_ACCESS_WS_X_6624
     * @uses self::VALUE_VGC_GATEWAY
     * @uses self::VALUE_CONFERENCE_BRIDGE
     * @uses self::VALUE_CONFERENCE_BRIDGE_WS_X_6608
     * @uses self::VALUE_CISCO_IOS_CONFERENCE_BRIDGE_HDV_2
     * @uses self::VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM
     * @uses self::VALUE_H_323_PHONE
     * @uses self::VALUE_H_323_GATEWAY
     * @uses self::VALUE_MUSIC_ON_HOLD
     * @uses self::VALUE_DEVICE_PILOT
     * @uses self::VALUE_CTI_PORT
     * @uses self::VALUE_CTI_ROUTE_POINT
     * @uses self::VALUE_VOICE_MAIL_PORT
     * @uses self::VALUE_CISCO_IOS_SOFTWARE_MEDIA_TERMINATION_POINT_HDV_2
     * @uses self::VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS
     * @uses self::VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX
     * @uses self::VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_ROUTE_LIST
     * @uses self::VALUE_LOAD_SIMULATOR
     * @uses self::VALUE_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_MEDIA_TERMINATION_POINT_HARDWARE
     * @uses self::VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT_HDV_2
     * @uses self::VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM
     * @uses self::VALUE_CISCO_7941
     * @uses self::VALUE_CISCO_7971
     * @uses self::VALUE_MGCP_STATION
     * @uses self::VALUE_MGCP_TRUNK
     * @uses self::VALUE_GATE_KEEPER
     * @uses self::VALUE_7914_14_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_TRUNK
     * @uses self::VALUE_TONE_ANNOUNCEMENT_PLAYER
     * @uses self::VALUE_SIP_TRUNK
     * @uses self::VALUE_SIP_GATEWAY
     * @uses self::VALUE_WSM_TRUNK
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILE
     * @uses self::VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_SPA_8800
     * @uses self::VALUE_UNKNOWN_MGCP_GATEWAY
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CISCO_7985
     * @uses self::VALUE_CISCO_7911
     * @uses self::VALUE_CISCO_7961_G_GE
     * @uses self::VALUE_CISCO_7941_G_GE
     * @uses self::VALUE_MOTOROLA_CN_622
     * @uses self::VALUE_THIRD_PARTY_SIP_DEVICE_BASIC
     * @uses self::VALUE_CISCO_7931
     * @uses self::VALUE_CISCO_UNIFIED_PERSONAL_COMMUNICATOR
     * @uses self::VALUE_CISCO_7921
     * @uses self::VALUE_CISCO_7906
     * @uses self::VALUE_THIRD_PARTY_SIP_DEVICE_ADVANCED
     * @uses self::VALUE_CISCO_TELE_PRESENCE
     * @uses self::VALUE_NOKIA_S_60
     * @uses self::VALUE_CISCO_7962
     * @uses self::VALUE_CISCO_3951
     * @uses self::VALUE_CISCO_7937
     * @uses self::VALUE_CISCO_7942
     * @uses self::VALUE_CISCO_7945
     * @uses self::VALUE_CISCO_7965
     * @uses self::VALUE_CISCO_7975
     * @uses self::VALUE_CISCO_3911
     * @uses self::VALUE_CISCO_UNIFIED_MOBILE_COMMUNICATOR
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1000
     * @uses self::VALUE_CISCO_TELE_PRESENCE_3000
     * @uses self::VALUE_CISCO_TELE_PRESENCE_3200
     * @uses self::VALUE_CISCO_TELE_PRESENCE_500_37
     * @uses self::VALUE_CISCO_7925
     * @uses self::VALUE_CISCO_9971
     * @uses self::VALUE_CISCO_6921
     * @uses self::VALUE_CISCO_6941
     * @uses self::VALUE_CISCO_6961
     * @uses self::VALUE_CISCO_UNIFIED_CLIENT_SERVICES_FRAMEWORK
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1300_65
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1100
     * @uses self::VALUE_TRANSNOVA_S_3
     * @uses self::VALUE_USAGE_PROFILE
     * @uses self::VALUE_CISCO_9951
     * @uses self::VALUE_CISCO_8961
     * @uses self::VALUE_CISCO_6901
     * @uses self::VALUE_CISCO_6911
     * @uses self::VALUE_CISCO_ATA_187
     * @uses self::VALUE_CISCO_TELE_PRESENCE_200
     * @uses self::VALUE_CISCO_TELE_PRESENCE_400
     * @uses self::VALUE_CISCO_DUAL_MODE_FOR_I_PHONE
     * @uses self::VALUE_CISCO_6945
     * @uses self::VALUE_CISCO_DUAL_MODE_FOR_ANDROID
     * @uses self::VALUE_CISCO_7926
     * @uses self::VALUE_CISCO_E_20
     * @uses self::VALUE_GENERIC_SINGLE_SCREEN_ROOM_SYSTEM
     * @uses self::VALUE_GENERIC_MULTIPLE_SCREEN_ROOM_SYSTEM
     * @uses self::VALUE_CISCO_TELE_PRESENCE_EX_90
     * @uses self::VALUE_CISCO_8945
     * @uses self::VALUE_CISCO_8941
     * @uses self::VALUE_GENERIC_DESKTOP_VIDEO_ENDPOINT
     * @uses self::VALUE_CISCO_TELE_PRESENCE_500_32
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1300_47
     * @uses self::VALUE_CISCO_3905
     * @uses self::VALUE_CISCO_CIUS
     * @uses self::VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_CISCO_TELE_PRESENCE_1310_65
     * @uses self::VALUE_CISCO_TELE_PRESENCE_MCU
     * @uses self::VALUE_CISCO_TELE_PRESENCE_EX_60
     * @uses self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_90
     * @uses self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_60
     * @uses self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_40
     * @uses self::VALUE_CISCO_TELE_PRESENCE_QUICK_SET_C_20
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_20
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_40
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_DUAL_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_C_60
     * @uses self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_DUAL_C_90
     * @uses self::VALUE_CISCO_TELE_PRESENCE_MX_200
     * @uses self::VALUE_IMS_INTEGRATED_MOBILE_BASIC
     * @uses self::VALUE_CISCO_CIUS_SP
     * @uses self::VALUE_CISCO_TELE_PRESENCE_PROFILE_42_C_40
     * @uses self::VALUE_CISCO_7905
     * @uses self::VALUE_CISCO_7920
     * @uses self::VALUE_CISCO_7970
     * @uses self::VALUE_CISCO_7912
     * @uses self::VALUE_CISCO_7902
     * @uses self::VALUE_CISCO_IP_COMMUNICATOR
     * @uses self::VALUE_CISCO_7961
     * @uses self::VALUE_CISCO_7936
     * @uses self::VALUE_ANALOG_PHONE
     * @uses self::VALUE_ISDN_BRI_PHONE
     * @uses self::VALUE_SCCP_GATEWAY_VIRTUAL_PHONE
     * @uses self::VALUE_IP_STE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CISCO_30_SP,
            self::VALUE_CISCO_12_SP,
            self::VALUE_CISCO_12_SP_1,
            self::VALUE_CISCO_12_S,
            self::VALUE_CISCO_30_VIP,
            self::VALUE_CISCO_7910,
            self::VALUE_CISCO_7960,
            self::VALUE_CISCO_7940,
            self::VALUE_CISCO_7935,
            self::VALUE_CISCO_VGC_PHONE,
            self::VALUE_CISCO_VGC_VIRTUAL_PHONE,
            self::VALUE_CISCO_ATA_186,
            self::VALUE_EMCC_BASE_PHONE,
            self::VALUE_SCCP_PHONE,
            self::VALUE_ANALOG_ACCESS,
            self::VALUE_DIGITAL_ACCESS,
            self::VALUE_DIGITAL_ACCESS_1,
            self::VALUE_DIGITAL_ACCESS_WS_X_6608,
            self::VALUE_ANALOG_ACCESS_WS_X_6624,
            self::VALUE_VGC_GATEWAY,
            self::VALUE_CONFERENCE_BRIDGE,
            self::VALUE_CONFERENCE_BRIDGE_WS_X_6608,
            self::VALUE_CISCO_IOS_CONFERENCE_BRIDGE_HDV_2,
            self::VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM,
            self::VALUE_H_323_PHONE,
            self::VALUE_H_323_GATEWAY,
            self::VALUE_MUSIC_ON_HOLD,
            self::VALUE_DEVICE_PILOT,
            self::VALUE_CTI_PORT,
            self::VALUE_CTI_ROUTE_POINT,
            self::VALUE_VOICE_MAIL_PORT,
            self::VALUE_CISCO_IOS_SOFTWARE_MEDIA_TERMINATION_POINT_HDV_2,
            self::VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS,
            self::VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX,
            self::VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_ROUTE_LIST,
            self::VALUE_LOAD_SIMULATOR,
            self::VALUE_MEDIA_TERMINATION_POINT,
            self::VALUE_MEDIA_TERMINATION_POINT_HARDWARE,
            self::VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT_HDV_2,
            self::VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM,
            self::VALUE_CISCO_7941,
            self::VALUE_CISCO_7971,
            self::VALUE_MGCP_STATION,
            self::VALUE_MGCP_TRUNK,
            self::VALUE_GATE_KEEPER,
            self::VALUE_7914_14_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_TRUNK,
            self::VALUE_TONE_ANNOUNCEMENT_PLAYER,
            self::VALUE_SIP_TRUNK,
            self::VALUE_SIP_GATEWAY,
            self::VALUE_WSM_TRUNK,
            self::VALUE_REMOTE_DESTINATION_PROFILE,
            self::VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_SPA_8800,
            self::VALUE_UNKNOWN_MGCP_GATEWAY,
            self::VALUE_UNKNOWN,
            self::VALUE_CISCO_7985,
            self::VALUE_CISCO_7911,
            self::VALUE_CISCO_7961_G_GE,
            self::VALUE_CISCO_7941_G_GE,
            self::VALUE_MOTOROLA_CN_622,
            self::VALUE_THIRD_PARTY_SIP_DEVICE_BASIC,
            self::VALUE_CISCO_7931,
            self::VALUE_CISCO_UNIFIED_PERSONAL_COMMUNICATOR,
            self::VALUE_CISCO_7921,
            self::VALUE_CISCO_7906,
            self::VALUE_THIRD_PARTY_SIP_DEVICE_ADVANCED,
            self::VALUE_CISCO_TELE_PRESENCE,
            self::VALUE_NOKIA_S_60,
            self::VALUE_CISCO_7962,
            self::VALUE_CISCO_3951,
            self::VALUE_CISCO_7937,
            self::VALUE_CISCO_7942,
            self::VALUE_CISCO_7945,
            self::VALUE_CISCO_7965,
            self::VALUE_CISCO_7975,
            self::VALUE_CISCO_3911,
            self::VALUE_CISCO_UNIFIED_MOBILE_COMMUNICATOR,
            self::VALUE_CISCO_TELE_PRESENCE_1000,
            self::VALUE_CISCO_TELE_PRESENCE_3000,
            self::VALUE_CISCO_TELE_PRESENCE_3200,
            self::VALUE_CISCO_TELE_PRESENCE_500_37,
            self::VALUE_CISCO_7925,
            self::VALUE_CISCO_9971,
            self::VALUE_CISCO_6921,
            self::VALUE_CISCO_6941,
            self::VALUE_CISCO_6961,
            self::VALUE_CISCO_UNIFIED_CLIENT_SERVICES_FRAMEWORK,
            self::VALUE_CISCO_TELE_PRESENCE_1300_65,
            self::VALUE_CISCO_TELE_PRESENCE_1100,
            self::VALUE_TRANSNOVA_S_3,
            self::VALUE_USAGE_PROFILE,
            self::VALUE_CISCO_9951,
            self::VALUE_CISCO_8961,
            self::VALUE_CISCO_6901,
            self::VALUE_CISCO_6911,
            self::VALUE_CISCO_ATA_187,
            self::VALUE_CISCO_TELE_PRESENCE_200,
            self::VALUE_CISCO_TELE_PRESENCE_400,
            self::VALUE_CISCO_DUAL_MODE_FOR_I_PHONE,
            self::VALUE_CISCO_6945,
            self::VALUE_CISCO_DUAL_MODE_FOR_ANDROID,
            self::VALUE_CISCO_7926,
            self::VALUE_CISCO_E_20,
            self::VALUE_GENERIC_SINGLE_SCREEN_ROOM_SYSTEM,
            self::VALUE_GENERIC_MULTIPLE_SCREEN_ROOM_SYSTEM,
            self::VALUE_CISCO_TELE_PRESENCE_EX_90,
            self::VALUE_CISCO_8945,
            self::VALUE_CISCO_8941,
            self::VALUE_GENERIC_DESKTOP_VIDEO_ENDPOINT,
            self::VALUE_CISCO_TELE_PRESENCE_500_32,
            self::VALUE_CISCO_TELE_PRESENCE_1300_47,
            self::VALUE_CISCO_3905,
            self::VALUE_CISCO_CIUS,
            self::VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_CISCO_TELE_PRESENCE_1310_65,
            self::VALUE_CISCO_TELE_PRESENCE_MCU,
            self::VALUE_CISCO_TELE_PRESENCE_EX_60,
            self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_90,
            self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_60,
            self::VALUE_CISCO_TELE_PRESENCE_CODEC_C_40,
            self::VALUE_CISCO_TELE_PRESENCE_QUICK_SET_C_20,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_20,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_42_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_40,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_52_DUAL_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_C_60,
            self::VALUE_CISCO_TELEPRESENCE_PROFILE_65_DUAL_C_90,
            self::VALUE_CISCO_TELE_PRESENCE_MX_200,
            self::VALUE_IMS_INTEGRATED_MOBILE_BASIC,
            self::VALUE_CISCO_CIUS_SP,
            self::VALUE_CISCO_TELE_PRESENCE_PROFILE_42_C_40,
            self::VALUE_CISCO_7905,
            self::VALUE_CISCO_7920,
            self::VALUE_CISCO_7970,
            self::VALUE_CISCO_7912,
            self::VALUE_CISCO_7902,
            self::VALUE_CISCO_IP_COMMUNICATOR,
            self::VALUE_CISCO_7961,
            self::VALUE_CISCO_7936,
            self::VALUE_ANALOG_PHONE,
            self::VALUE_ISDN_BRI_PHONE,
            self::VALUE_SCCP_GATEWAY_VIRTUAL_PHONE,
            self::VALUE_IP_STE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
