<?php

namespace CUCM\EnumType;

/**
 * This class stands for XMatrix EnumType
 * @subpackage Enumerations
 */
class XMatrix
{
    /**
     * Constant for value 'Presence Group'
     * @return string 'Presence Group'
     */
    const VALUE_PRESENCE_GROUP = 'Presence Group';
    /**
     * Constant for value 'RSVP Policy'
     * @return string 'RSVP Policy'
     */
    const VALUE_RSVP_POLICY = 'RSVP Policy';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRESENCE_GROUP
     * @uses self::VALUE_RSVP_POLICY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRESENCE_GROUP,
            self::VALUE_RSVP_POLICY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
