<?php

namespace CUCM\EnumType;

/**
 * This class stands for XLanguageGroup EnumType
 * @subpackage Enumerations
 */
class XLanguageGroup
{
    /**
     * Constant for value 'Western European'
     * @return string 'Western European'
     */
    const VALUE_WESTERN_EUROPEAN = 'Western European';
    /**
     * Constant for value 'Eastern European'
     * @return string 'Eastern European'
     */
    const VALUE_EASTERN_EUROPEAN = 'Eastern European';
    /**
     * Constant for value 'Baltic'
     * @return string 'Baltic'
     */
    const VALUE_BALTIC = 'Baltic';
    /**
     * Constant for value 'Cyrillic'
     * @return string 'Cyrillic'
     */
    const VALUE_CYRILLIC = 'Cyrillic';
    /**
     * Constant for value 'Arabic'
     * @return string 'Arabic'
     */
    const VALUE_ARABIC = 'Arabic';
    /**
     * Constant for value 'Greek'
     * @return string 'Greek'
     */
    const VALUE_GREEK = 'Greek';
    /**
     * Constant for value 'Hebrew'
     * @return string 'Hebrew'
     */
    const VALUE_HEBREW = 'Hebrew';
    /**
     * Constant for value 'Turkish'
     * @return string 'Turkish'
     */
    const VALUE_TURKISH = 'Turkish';
    /**
     * Constant for value 'Japanese'
     * @return string 'Japanese'
     */
    const VALUE_JAPANESE = 'Japanese';
    /**
     * Constant for value 'Simplified Chinese'
     * @return string 'Simplified Chinese'
     */
    const VALUE_SIMPLIFIED_CHINESE = 'Simplified Chinese';
    /**
     * Constant for value 'Traditional Chinese'
     * @return string 'Traditional Chinese'
     */
    const VALUE_TRADITIONAL_CHINESE = 'Traditional Chinese';
    /**
     * Constant for value 'Korean'
     * @return string 'Korean'
     */
    const VALUE_KOREAN = 'Korean';
    /**
     * Constant for value 'Thai'
     * @return string 'Thai'
     */
    const VALUE_THAI = 'Thai';
    /**
     * Constant for value 'Vietnamese'
     * @return string 'Vietnamese'
     */
    const VALUE_VIETNAMESE = 'Vietnamese';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WESTERN_EUROPEAN
     * @uses self::VALUE_EASTERN_EUROPEAN
     * @uses self::VALUE_BALTIC
     * @uses self::VALUE_CYRILLIC
     * @uses self::VALUE_ARABIC
     * @uses self::VALUE_GREEK
     * @uses self::VALUE_HEBREW
     * @uses self::VALUE_TURKISH
     * @uses self::VALUE_JAPANESE
     * @uses self::VALUE_SIMPLIFIED_CHINESE
     * @uses self::VALUE_TRADITIONAL_CHINESE
     * @uses self::VALUE_KOREAN
     * @uses self::VALUE_THAI
     * @uses self::VALUE_VIETNAMESE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WESTERN_EUROPEAN,
            self::VALUE_EASTERN_EUROPEAN,
            self::VALUE_BALTIC,
            self::VALUE_CYRILLIC,
            self::VALUE_ARABIC,
            self::VALUE_GREEK,
            self::VALUE_HEBREW,
            self::VALUE_TURKISH,
            self::VALUE_JAPANESE,
            self::VALUE_SIMPLIFIED_CHINESE,
            self::VALUE_TRADITIONAL_CHINESE,
            self::VALUE_KOREAN,
            self::VALUE_THAI,
            self::VALUE_VIETNAMESE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
