<?php

namespace CUCM\EnumType;

/**
 * This class stands for XLDAPProtocol EnumType
 * @subpackage Enumerations
 */
class XLDAPProtocol
{
    /**
     * Constant for value 'ldap_AD'
     * @return string 'ldap_AD'
     */
    const VALUE_LDAP_AD = 'ldap_AD';
    /**
     * Constant for value 'gc'
     * @return string 'gc'
     */
    const VALUE_GC = 'gc';
    /**
     * Constant for value 'ldap_ND'
     * @return string 'ldap_ND'
     */
    const VALUE_LDAP_ND = 'ldap_ND';
    /**
     * Constant for value 'ldap_OP'
     * @return string 'ldap_OP'
     */
    const VALUE_LDAP_OP = 'ldap_OP';
    /**
     * Constant for value 'ldap_ADAM'
     * @return string 'ldap_ADAM'
     */
    const VALUE_LDAP_ADAM = 'ldap_ADAM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LDAP_AD
     * @uses self::VALUE_GC
     * @uses self::VALUE_LDAP_ND
     * @uses self::VALUE_LDAP_OP
     * @uses self::VALUE_LDAP_ADAM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LDAP_AD,
            self::VALUE_GC,
            self::VALUE_LDAP_ND,
            self::VALUE_LDAP_OP,
            self::VALUE_LDAP_ADAM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
