<?php

namespace CUCM\EnumType;

/**
 * This class stands for XKey EnumType
 * @subpackage Enumerations
 */
class XKey
{
    /**
     * Constant for value 'Pre-Alloc. Key type/blocksize -- Users'
     * @return string 'Pre-Alloc. Key type/blocksize -- Users'
     */
    const VALUE_PRE_ALLOC_KEY_TYPE_BLOCKSIZE_USERS = 'Pre-Alloc. Key type/blocksize -- Users';
    /**
     * Constant for value 'Pre-Alloc. Key type/blocksize -- Contacts'
     * @return string 'Pre-Alloc. Key type/blocksize -- Contacts'
     */
    const VALUE_PRE_ALLOC_KEY_TYPE_BLOCKSIZE_CONTACTS = 'Pre-Alloc. Key type/blocksize -- Contacts';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRE_ALLOC_KEY_TYPE_BLOCKSIZE_USERS
     * @uses self::VALUE_PRE_ALLOC_KEY_TYPE_BLOCKSIZE_CONTACTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRE_ALLOC_KEY_TYPE_BLOCKSIZE_USERS,
            self::VALUE_PRE_ALLOC_KEY_TYPE_BLOCKSIZE_CONTACTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
