<?php

namespace CUCM\EnumType;

/**
 * This class stands for XIdentifier EnumType
 * @subpackage Enumerations
 */
class XIdentifier
{
    /**
     * Constant for value ''Username and Domain pair''
     * @return string ''Username and Domain pair''
     */
    const VALUE_USERNAME_AND_DOMAIN_PAIR = '\'Username and Domain pair\'';
    /**
     * Constant for value ''Username sans Domain''
     * @return string ''Username sans Domain''
     */
    const VALUE_USERNAME_SANS_DOMAIN = '\'Username sans Domain\'';
    /**
     * Constant for value ''Eight digit phone number''
     * @return string ''Eight digit phone number''
     */
    const VALUE_EIGHT_DIGIT_PHONE_NUMBER = '\'Eight digit phone number\'';
    /**
     * Constant for value ''Biometric Fingerprint Scan''
     * @return string ''Biometric Fingerprint Scan''
     */
    const VALUE_BIOMETRIC_FINGERPRINT_SCAN = '\'Biometric Fingerprint Scan\'';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USERNAME_AND_DOMAIN_PAIR
     * @uses self::VALUE_USERNAME_SANS_DOMAIN
     * @uses self::VALUE_EIGHT_DIGIT_PHONE_NUMBER
     * @uses self::VALUE_BIOMETRIC_FINGERPRINT_SCAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USERNAME_AND_DOMAIN_PAIR,
            self::VALUE_USERNAME_SANS_DOMAIN,
            self::VALUE_EIGHT_DIGIT_PHONE_NUMBER,
            self::VALUE_BIOMETRIC_FINGERPRINT_SCAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
