<?php

namespace CUCM\EnumType;

/**
 * This class stands for XIPAddressingMode EnumType
 * @subpackage Enumerations
 */
class XIPAddressingMode
{
    /**
     * Constant for value 'IPv4 Only'
     * @return string 'IPv4 Only'
     */
    const VALUE_IPV_4_ONLY = 'IPv4 Only';
    /**
     * Constant for value 'IPv6 Only'
     * @return string 'IPv6 Only'
     */
    const VALUE_IPV_6_ONLY = 'IPv6 Only';
    /**
     * Constant for value 'IPv4 and IPv6'
     * @return string 'IPv4 and IPv6'
     */
    const VALUE_IPV_4_AND_IPV_6 = 'IPv4 and IPv6';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IPV_4_ONLY
     * @uses self::VALUE_IPV_6_ONLY
     * @uses self::VALUE_IPV_4_AND_IPV_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IPV_4_ONLY,
            self::VALUE_IPV_6_ONLY,
            self::VALUE_IPV_4_AND_IPV_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
