<?php

namespace CUCM\EnumType;

/**
 * This class stands for XHash EnumType
 * @subpackage Enumerations
 */
class XHash
{
    /**
     * Constant for value 'SHA-1'
     * @return string 'SHA-1'
     */
    const VALUE_SHA_1 = 'SHA-1';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHA_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHA_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
