<?php

namespace CUCM\EnumType;

/**
 * This class stands for XFraming EnumType
 * @subpackage Enumerations
 */
class XFraming
{
    /**
     * Constant for value 'D4'
     * @return string 'D4'
     */
    const VALUE_D_4 = 'D4';
    /**
     * Constant for value 'ESF'
     * @return string 'ESF'
     */
    const VALUE_ESF = 'ESF';
    /**
     * Constant for value 'CRC4'
     * @return string 'CRC4'
     */
    const VALUE_CRC_4 = 'CRC4';
    /**
     * Constant for value 'Non CRC4'
     * @return string 'Non CRC4'
     */
    const VALUE_NON_CRC_4 = 'Non CRC4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_D_4
     * @uses self::VALUE_ESF
     * @uses self::VALUE_CRC_4
     * @uses self::VALUE_NON_CRC_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_D_4,
            self::VALUE_ESF,
            self::VALUE_CRC_4,
            self::VALUE_NON_CRC_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
