<?php

namespace CUCM\EnumType;

/**
 * This class stands for XFeatureConfig EnumType
 * @subpackage Enumerations
 */
class XFeatureConfig
{
    /**
     * Constant for value 'EMCC'
     * @return string 'EMCC'
     */
    const VALUE_EMCC = 'EMCC';
    /**
     * Constant for value 'VPN'
     * @return string 'VPN'
     */
    const VALUE_VPN = 'VPN';
    /**
     * Constant for value 'Intercompany Media Services'
     * @return string 'Intercompany Media Services'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES = 'Intercompany Media Services';
    /**
     * Constant for value 'Fallback'
     * @return string 'Fallback'
     */
    const VALUE_FALLBACK = 'Fallback';
    /**
     * Constant for value 'CCD'
     * @return string 'CCD'
     */
    const VALUE_CCD = 'CCD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMCC
     * @uses self::VALUE_VPN
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES
     * @uses self::VALUE_FALLBACK
     * @uses self::VALUE_CCD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMCC,
            self::VALUE_VPN,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES,
            self::VALUE_FALLBACK,
            self::VALUE_CCD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
