<?php

namespace CUCM\EnumType;

/**
 * This class stands for XFeature EnumType
 * @subpackage Enumerations
 */
class XFeature
{
    /**
     * Constant for value 'Redial'
     * @return string 'Redial'
     */
    const VALUE_REDIAL = 'Redial';
    /**
     * Constant for value 'Speed Dial'
     * @return string 'Speed Dial'
     */
    const VALUE_SPEED_DIAL = 'Speed Dial';
    /**
     * Constant for value 'Hold'
     * @return string 'Hold'
     */
    const VALUE_HOLD = 'Hold';
    /**
     * Constant for value 'Transfer'
     * @return string 'Transfer'
     */
    const VALUE_TRANSFER = 'Transfer';
    /**
     * Constant for value 'Forward All'
     * @return string 'Forward All'
     */
    const VALUE_FORWARD_ALL = 'Forward All';
    /**
     * Constant for value 'Display'
     * @return string 'Display'
     */
    const VALUE_DISPLAY = 'Display';
    /**
     * Constant for value 'Line'
     * @return string 'Line'
     */
    const VALUE_LINE = 'Line';
    /**
     * Constant for value 'Chat'
     * @return string 'Chat'
     */
    const VALUE_CHAT = 'Chat';
    /**
     * Constant for value 'Whiteboard'
     * @return string 'Whiteboard'
     */
    const VALUE_WHITEBOARD = 'Whiteboard';
    /**
     * Constant for value 'Application Sharing'
     * @return string 'Application Sharing'
     */
    const VALUE_APPLICATION_SHARING = 'Application Sharing';
    /**
     * Constant for value 'File Transfer'
     * @return string 'File Transfer'
     */
    const VALUE_FILE_TRANSFER = 'File Transfer';
    /**
     * Constant for value 'Video'
     * @return string 'Video'
     */
    const VALUE_VIDEO = 'Video';
    /**
     * Constant for value 'Message Waiting'
     * @return string 'Message Waiting'
     */
    const VALUE_MESSAGE_WAITING = 'Message Waiting';
    /**
     * Constant for value 'Answer/Release'
     * @return string 'Answer/Release'
     */
    const VALUE_ANSWER_RELEASE = 'Answer/Release';
    /**
     * Constant for value 'Auto Answer'
     * @return string 'Auto Answer'
     */
    const VALUE_AUTO_ANSWER = 'Auto Answer';
    /**
     * Constant for value 'Settings'
     * @return string 'Settings'
     */
    const VALUE_SETTINGS = 'Settings';
    /**
     * Constant for value 'Privacy'
     * @return string 'Privacy'
     */
    const VALUE_PRIVACY = 'Privacy';
    /**
     * Constant for value 'Service URL'
     * @return string 'Service URL'
     */
    const VALUE_SERVICE_URL = 'Service URL';
    /**
     * Constant for value 'Speed Dial BLF'
     * @return string 'Speed Dial BLF'
     */
    const VALUE_SPEED_DIAL_BLF = 'Speed Dial BLF';
    /**
     * Constant for value 'Call Park BLF'
     * @return string 'Call Park BLF'
     */
    const VALUE_CALL_PARK_BLF = 'Call Park BLF';
    /**
     * Constant for value 'Intercom'
     * @return string 'Intercom'
     */
    const VALUE_INTERCOM = 'Intercom';
    /**
     * Constant for value 'Malicious Call Identification'
     * @return string 'Malicious Call Identification'
     */
    const VALUE_MALICIOUS_CALL_IDENTIFICATION = 'Malicious Call Identification';
    /**
     * Constant for value 'Meet Me Conference'
     * @return string 'Meet Me Conference'
     */
    const VALUE_MEET_ME_CONFERENCE = 'Meet Me Conference';
    /**
     * Constant for value 'Conference'
     * @return string 'Conference'
     */
    const VALUE_CONFERENCE = 'Conference';
    /**
     * Constant for value 'Call Park'
     * @return string 'Call Park'
     */
    const VALUE_CALL_PARK = 'Call Park';
    /**
     * Constant for value 'Call Pickup'
     * @return string 'Call Pickup'
     */
    const VALUE_CALL_PICKUP = 'Call Pickup';
    /**
     * Constant for value 'Group Call Pickup'
     * @return string 'Group Call Pickup'
     */
    const VALUE_GROUP_CALL_PICKUP = 'Group Call Pickup';
    /**
     * Constant for value 'Mobility'
     * @return string 'Mobility'
     */
    const VALUE_MOBILITY = 'Mobility';
    /**
     * Constant for value 'Do Not Disturb'
     * @return string 'Do Not Disturb'
     */
    const VALUE_DO_NOT_DISTURB = 'Do Not Disturb';
    /**
     * Constant for value 'Conference List'
     * @return string 'Conference List'
     */
    const VALUE_CONFERENCE_LIST = 'Conference List';
    /**
     * Constant for value 'Remove Last Participant'
     * @return string 'Remove Last Participant'
     */
    const VALUE_REMOVE_LAST_PARTICIPANT = 'Remove Last Participant';
    /**
     * Constant for value 'Quality Reporting Tool'
     * @return string 'Quality Reporting Tool'
     */
    const VALUE_QUALITY_REPORTING_TOOL = 'Quality Reporting Tool';
    /**
     * Constant for value 'CallBack'
     * @return string 'CallBack'
     */
    const VALUE_CALL_BACK = 'CallBack';
    /**
     * Constant for value 'Other Pickup'
     * @return string 'Other Pickup'
     */
    const VALUE_OTHER_PICKUP = 'Other Pickup';
    /**
     * Constant for value 'Video Mode'
     * @return string 'Video Mode'
     */
    const VALUE_VIDEO_MODE = 'Video Mode';
    /**
     * Constant for value 'New Call'
     * @return string 'New Call'
     */
    const VALUE_NEW_CALL = 'New Call';
    /**
     * Constant for value 'End Call'
     * @return string 'End Call'
     */
    const VALUE_END_CALL = 'End Call';
    /**
     * Constant for value 'Hunt Group Logout'
     * @return string 'Hunt Group Logout'
     */
    const VALUE_HUNT_GROUP_LOGOUT = 'Hunt Group Logout';
    /**
     * Constant for value 'All Calls'
     * @return string 'All Calls'
     */
    const VALUE_ALL_CALLS = 'All Calls';
    /**
     * Constant for value 'Answer Oldest'
     * @return string 'Answer Oldest'
     */
    const VALUE_ANSWER_OLDEST = 'Answer Oldest';
    /**
     * Constant for value 'Alerting Calls'
     * @return string 'Alerting Calls'
     */
    const VALUE_ALERTING_CALLS = 'Alerting Calls';
    /**
     * Constant for value 'Record'
     * @return string 'Record'
     */
    const VALUE_RECORD = 'Record';
    /**
     * Constant for value 'Services'
     * @return string 'Services'
     */
    const VALUE_SERVICES = 'Services';
    /**
     * Constant for value 'Messages'
     * @return string 'Messages'
     */
    const VALUE_MESSAGES = 'Messages';
    /**
     * Constant for value 'Directories'
     * @return string 'Directories'
     */
    const VALUE_DIRECTORIES = 'Directories';
    /**
     * Constant for value 'Information'
     * @return string 'Information'
     */
    const VALUE_INFORMATION = 'Information';
    /**
     * Constant for value 'Application Menu'
     * @return string 'Application Menu'
     */
    const VALUE_APPLICATION_MENU = 'Application Menu';
    /**
     * Constant for value 'Headset'
     * @return string 'Headset'
     */
    const VALUE_HEADSET = 'Headset';
    /**
     * Constant for value 'AEC'
     * @return string 'AEC'
     */
    const VALUE_AEC = 'AEC';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REDIAL
     * @uses self::VALUE_SPEED_DIAL
     * @uses self::VALUE_HOLD
     * @uses self::VALUE_TRANSFER
     * @uses self::VALUE_FORWARD_ALL
     * @uses self::VALUE_DISPLAY
     * @uses self::VALUE_LINE
     * @uses self::VALUE_CHAT
     * @uses self::VALUE_WHITEBOARD
     * @uses self::VALUE_APPLICATION_SHARING
     * @uses self::VALUE_FILE_TRANSFER
     * @uses self::VALUE_VIDEO
     * @uses self::VALUE_MESSAGE_WAITING
     * @uses self::VALUE_ANSWER_RELEASE
     * @uses self::VALUE_AUTO_ANSWER
     * @uses self::VALUE_SETTINGS
     * @uses self::VALUE_PRIVACY
     * @uses self::VALUE_SERVICE_URL
     * @uses self::VALUE_SPEED_DIAL_BLF
     * @uses self::VALUE_CALL_PARK_BLF
     * @uses self::VALUE_INTERCOM
     * @uses self::VALUE_MALICIOUS_CALL_IDENTIFICATION
     * @uses self::VALUE_MEET_ME_CONFERENCE
     * @uses self::VALUE_CONFERENCE
     * @uses self::VALUE_CALL_PARK
     * @uses self::VALUE_CALL_PICKUP
     * @uses self::VALUE_GROUP_CALL_PICKUP
     * @uses self::VALUE_MOBILITY
     * @uses self::VALUE_DO_NOT_DISTURB
     * @uses self::VALUE_CONFERENCE_LIST
     * @uses self::VALUE_REMOVE_LAST_PARTICIPANT
     * @uses self::VALUE_QUALITY_REPORTING_TOOL
     * @uses self::VALUE_CALL_BACK
     * @uses self::VALUE_OTHER_PICKUP
     * @uses self::VALUE_VIDEO_MODE
     * @uses self::VALUE_NEW_CALL
     * @uses self::VALUE_END_CALL
     * @uses self::VALUE_HUNT_GROUP_LOGOUT
     * @uses self::VALUE_ALL_CALLS
     * @uses self::VALUE_ANSWER_OLDEST
     * @uses self::VALUE_ALERTING_CALLS
     * @uses self::VALUE_RECORD
     * @uses self::VALUE_SERVICES
     * @uses self::VALUE_MESSAGES
     * @uses self::VALUE_DIRECTORIES
     * @uses self::VALUE_INFORMATION
     * @uses self::VALUE_APPLICATION_MENU
     * @uses self::VALUE_HEADSET
     * @uses self::VALUE_AEC
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REDIAL,
            self::VALUE_SPEED_DIAL,
            self::VALUE_HOLD,
            self::VALUE_TRANSFER,
            self::VALUE_FORWARD_ALL,
            self::VALUE_DISPLAY,
            self::VALUE_LINE,
            self::VALUE_CHAT,
            self::VALUE_WHITEBOARD,
            self::VALUE_APPLICATION_SHARING,
            self::VALUE_FILE_TRANSFER,
            self::VALUE_VIDEO,
            self::VALUE_MESSAGE_WAITING,
            self::VALUE_ANSWER_RELEASE,
            self::VALUE_AUTO_ANSWER,
            self::VALUE_SETTINGS,
            self::VALUE_PRIVACY,
            self::VALUE_SERVICE_URL,
            self::VALUE_SPEED_DIAL_BLF,
            self::VALUE_CALL_PARK_BLF,
            self::VALUE_INTERCOM,
            self::VALUE_MALICIOUS_CALL_IDENTIFICATION,
            self::VALUE_MEET_ME_CONFERENCE,
            self::VALUE_CONFERENCE,
            self::VALUE_CALL_PARK,
            self::VALUE_CALL_PICKUP,
            self::VALUE_GROUP_CALL_PICKUP,
            self::VALUE_MOBILITY,
            self::VALUE_DO_NOT_DISTURB,
            self::VALUE_CONFERENCE_LIST,
            self::VALUE_REMOVE_LAST_PARTICIPANT,
            self::VALUE_QUALITY_REPORTING_TOOL,
            self::VALUE_CALL_BACK,
            self::VALUE_OTHER_PICKUP,
            self::VALUE_VIDEO_MODE,
            self::VALUE_NEW_CALL,
            self::VALUE_END_CALL,
            self::VALUE_HUNT_GROUP_LOGOUT,
            self::VALUE_ALL_CALLS,
            self::VALUE_ANSWER_OLDEST,
            self::VALUE_ALERTING_CALLS,
            self::VALUE_RECORD,
            self::VALUE_SERVICES,
            self::VALUE_MESSAGES,
            self::VALUE_DIRECTORIES,
            self::VALUE_INFORMATION,
            self::VALUE_APPLICATION_MENU,
            self::VALUE_HEADSET,
            self::VALUE_AEC,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
