<?php

namespace CUCM\EnumType;

/**
 * This class stands for XFallbackSensitivityLevel EnumType
 * @subpackage Enumerations
 */
class XFallbackSensitivityLevel
{
    /**
     * Constant for value 'Disable Fallback (No PSTN fallback option)'
     * @return string 'Disable Fallback (No PSTN fallback option)'
     */
    const VALUE_DISABLE_FALLBACK_NO_PSTN_FALLBACK_OPTION = 'Disable Fallback (No PSTN fallback option)';
    /**
     * Constant for value 'Utility (Lowest tolerable quality, not for extended duration
     * calls)'
     * @return string 'Utility (Lowest tolerable quality, not for extended duration calls)'
     */
    const VALUE_UTILITY_LOWEST_TOLERABLE_QUALITY_NOT_FOR_EXTENDED_DURATION_CALLS = 'Utility (Lowest tolerable quality, not for extended duration calls)';
    /**
     * Constant for value 'Accommodative (Minimum acceptable quality)'
     * @return string 'Accommodative (Minimum acceptable quality)'
     */
    const VALUE_ACCOMMODATIVE_MINIMUM_ACCEPTABLE_QUALITY = 'Accommodative (Minimum acceptable quality)';
    /**
     * Constant for value 'Nominal (Default sensitivity, almost all enterprise
     * deployments qualify)'
     * @return string 'Nominal (Default sensitivity, almost all enterprise deployments qualify)'
     */
    const VALUE_NOMINAL_DEFAULT_SENSITIVITY_ALMOST_ALL_ENTERPRISE_DEPLOYMENTS_QUALIFY = 'Nominal (Default sensitivity, almost all enterprise deployments qualify)';
    /**
     * Constant for value 'Moderate (More sensitive, not all deployments qualify)'
     * @return string 'Moderate (More sensitive, not all deployments qualify)'
     */
    const VALUE_MODERATE_MORE_SENSITIVE_NOT_ALL_DEPLOYMENTS_QUALIFY = 'Moderate (More sensitive, not all deployments qualify)';
    /**
     * Constant for value 'Aggressive (Most sensitive, not all deployments qualify)'
     * @return string 'Aggressive (Most sensitive, not all deployments qualify)'
     */
    const VALUE_AGGRESSIVE_MOST_SENSITIVE_NOT_ALL_DEPLOYMENTS_QUALIFY = 'Aggressive (Most sensitive, not all deployments qualify)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLE_FALLBACK_NO_PSTN_FALLBACK_OPTION
     * @uses self::VALUE_UTILITY_LOWEST_TOLERABLE_QUALITY_NOT_FOR_EXTENDED_DURATION_CALLS
     * @uses self::VALUE_ACCOMMODATIVE_MINIMUM_ACCEPTABLE_QUALITY
     * @uses self::VALUE_NOMINAL_DEFAULT_SENSITIVITY_ALMOST_ALL_ENTERPRISE_DEPLOYMENTS_QUALIFY
     * @uses self::VALUE_MODERATE_MORE_SENSITIVE_NOT_ALL_DEPLOYMENTS_QUALIFY
     * @uses self::VALUE_AGGRESSIVE_MOST_SENSITIVE_NOT_ALL_DEPLOYMENTS_QUALIFY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLE_FALLBACK_NO_PSTN_FALLBACK_OPTION,
            self::VALUE_UTILITY_LOWEST_TOLERABLE_QUALITY_NOT_FOR_EXTENDED_DURATION_CALLS,
            self::VALUE_ACCOMMODATIVE_MINIMUM_ACCEPTABLE_QUALITY,
            self::VALUE_NOMINAL_DEFAULT_SENSITIVITY_ALMOST_ALL_ENTERPRISE_DEPLOYMENTS_QUALIFY,
            self::VALUE_MODERATE_MORE_SENSITIVE_NOT_ALL_DEPLOYMENTS_QUALIFY,
            self::VALUE_AGGRESSIVE_MOST_SENSITIVE_NOT_ALL_DEPLOYMENTS_QUALIFY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
