<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDrfScript EnumType
 * @subpackage Enumerations
 */
class XDrfScript
{
    /**
     * Constant for value 'Backup'
     * @return string 'Backup'
     */
    const VALUE_BACKUP = 'Backup';
    /**
     * Constant for value 'Restore'
     * @return string 'Restore'
     */
    const VALUE_RESTORE = 'Restore';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BACKUP
     * @uses self::VALUE_RESTORE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BACKUP,
            self::VALUE_RESTORE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
