<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDrfRegistered EnumType
 * @subpackage Enumerations
 */
class XDrfRegistered
{
    /**
     * Constant for value 'NotRegistered'
     * @return string 'NotRegistered'
     */
    const VALUE_NOT_REGISTERED = 'NotRegistered';
    /**
     * Constant for value 'Registered'
     * @return string 'Registered'
     */
    const VALUE_REGISTERED = 'Registered';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_REGISTERED
     * @uses self::VALUE_REGISTERED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_REGISTERED,
            self::VALUE_REGISTERED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
