<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDialViaOffice EnumType
 * @subpackage Enumerations
 */
class XDialViaOffice
{
    /**
     * Constant for value 'Dial via Office Reverse'
     * @return string 'Dial via Office Reverse'
     */
    const VALUE_DIAL_VIA_OFFICE_REVERSE = 'Dial via Office Reverse';
    /**
     * Constant for value 'Dial via Office Forward'
     * @return string 'Dial via Office Forward'
     */
    const VALUE_DIAL_VIA_OFFICE_FORWARD = 'Dial via Office Forward';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIAL_VIA_OFFICE_REVERSE
     * @uses self::VALUE_DIAL_VIA_OFFICE_FORWARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIAL_VIA_OFFICE_REVERSE,
            self::VALUE_DIAL_VIA_OFFICE_FORWARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
