<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDialPattern EnumType
 * @subpackage Enumerations
 */
class XDialPattern
{
    /**
     * Constant for value '7905_7912'
     * @return string '7905_7912'
     */
    const VALUE_7905_7912 = '7905_7912';
    /**
     * Constant for value '7940_7960_OTHER'
     * @return string '7940_7960_OTHER'
     */
    const VALUE_7940_7960_OTHER = '7940_7960_OTHER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_7905_7912
     * @uses self::VALUE_7940_7960_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_7905_7912,
            self::VALUE_7940_7960_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
