<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDPVerificationStatus EnumType
 * @subpackage Enumerations
 */
class XDPVerificationStatus
{
    /**
     * Constant for value 'Not Done'
     * @return string 'Not Done'
     */
    const VALUE_NOT_DONE = 'Not Done';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_DONE
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_SUCCESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_DONE,
            self::VALUE_FAILED,
            self::VALUE_SUCCESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
