<?php

namespace CUCM\EnumType;

/**
 * This class stands for XContactFolder EnumType
 * @subpackage Enumerations
 */
class XContactFolder
{
    /**
     * Constant for value ''General Purpose Contact Folder''
     * @return string ''General Purpose Contact Folder''
     */
    const VALUE_GENERAL_PURPOSE_CONTACT_FOLDER = '\'General Purpose Contact Folder\'';
    /**
     * Constant for value ''Contact Folder to contain BuddyList members''
     * @return string ''Contact Folder to contain BuddyList members''
     */
    const VALUE_CONTACT_FOLDER_TO_CONTAIN_BUDDY_LIST_MEMBERS = '\'Contact Folder to contain BuddyList members\'';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENERAL_PURPOSE_CONTACT_FOLDER
     * @uses self::VALUE_CONTACT_FOLDER_TO_CONTAIN_BUDDY_LIST_MEMBERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENERAL_PURPOSE_CONTACT_FOLDER,
            self::VALUE_CONTACT_FOLDER_TO_CONTAIN_BUDDY_LIST_MEMBERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
