<?php

namespace CUCM\EnumType;

/**
 * This class stands for XConnectionUsage EnumType
 * @subpackage Enumerations
 */
class XConnectionUsage
{
    /**
     * Constant for value 'All Call Types'
     * @return string 'All Call Types'
     */
    const VALUE_ALL_CALL_TYPES = 'All Call Types';
    /**
     * Constant for value 'Emergency Calls Only'
     * @return string 'Emergency Calls Only'
     */
    const VALUE_EMERGENCY_CALLS_ONLY = 'Emergency Calls Only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_CALL_TYPES
     * @uses self::VALUE_EMERGENCY_CALLS_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_CALL_TYPES,
            self::VALUE_EMERGENCY_CALLS_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
