<?php

namespace CUCM\EnumType;

/**
 * This class stands for XConnection EnumType
 * @subpackage Enumerations
 */
class XConnection
{
    /**
     * Constant for value 'E1 PRI'
     * @return string 'E1 PRI'
     */
    const VALUE_E_1_PRI = 'E1 PRI';
    /**
     * Constant for value 'T1 PRI'
     * @return string 'T1 PRI'
     */
    const VALUE_T_1_PRI = 'T1 PRI';
    /**
     * Constant for value 'T1 CAS'
     * @return string 'T1 CAS'
     */
    const VALUE_T_1_CAS = 'T1 CAS';
    /**
     * Constant for value 'FXO'
     * @return string 'FXO'
     */
    const VALUE_FXO = 'FXO';
    /**
     * Constant for value 'SIP Trunk'
     * @return string 'SIP Trunk'
     */
    const VALUE_SIP_TRUNK = 'SIP Trunk';
    /**
     * Constant for value 'E1 R2'
     * @return string 'E1 R2'
     */
    const VALUE_E_1_R_2 = 'E1 R2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_1_PRI
     * @uses self::VALUE_T_1_PRI
     * @uses self::VALUE_T_1_CAS
     * @uses self::VALUE_FXO
     * @uses self::VALUE_SIP_TRUNK
     * @uses self::VALUE_E_1_R_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_1_PRI,
            self::VALUE_T_1_PRI,
            self::VALUE_T_1_CAS,
            self::VALUE_FXO,
            self::VALUE_SIP_TRUNK,
            self::VALUE_E_1_R_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
