<?php

namespace CUCM\EnumType;

/**
 * This class stands for XConfigInputDataGrouping EnumType
 * @subpackage Enumerations
 */
class XConfigInputDataGrouping
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'System Data'
     * @return string 'System Data'
     */
    const VALUE_SYSTEM_DATA = 'System Data';
    /**
     * Constant for value 'Call Routing Data'
     * @return string 'Call Routing Data'
     */
    const VALUE_CALL_ROUTING_DATA = 'Call Routing Data';
    /**
     * Constant for value 'Media Resources'
     * @return string 'Media Resources'
     */
    const VALUE_MEDIA_RESOURCES = 'Media Resources';
    /**
     * Constant for value 'User Data'
     * @return string 'User Data'
     */
    const VALUE_USER_DATA = 'User Data';
    /**
     * Constant for value 'Device Data'
     * @return string 'Device Data'
     */
    const VALUE_DEVICE_DATA = 'Device Data';
    /**
     * Constant for value 'Advanced Features'
     * @return string 'Advanced Features'
     */
    const VALUE_ADVANCED_FEATURES = 'Advanced Features';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SYSTEM_DATA
     * @uses self::VALUE_CALL_ROUTING_DATA
     * @uses self::VALUE_MEDIA_RESOURCES
     * @uses self::VALUE_USER_DATA
     * @uses self::VALUE_DEVICE_DATA
     * @uses self::VALUE_ADVANCED_FEATURES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SYSTEM_DATA,
            self::VALUE_CALL_ROUTING_DATA,
            self::VALUE_MEDIA_RESOURCES,
            self::VALUE_USER_DATA,
            self::VALUE_DEVICE_DATA,
            self::VALUE_ADVANCED_FEATURES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
