<?php

namespace CUCM\EnumType;

/**
 * This class stands for XCallerFilterMask EnumType
 * @subpackage Enumerations
 */
class XCallerFilterMask
{
    /**
     * Constant for value 'Directory Number'
     * @return string 'Directory Number'
     */
    const VALUE_DIRECTORY_NUMBER = 'Directory Number';
    /**
     * Constant for value 'Not Available'
     * @return string 'Not Available'
     */
    const VALUE_NOT_AVAILABLE = 'Not Available';
    /**
     * Constant for value 'Private'
     * @return string 'Private'
     */
    const VALUE_PRIVATE = 'Private';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIRECTORY_NUMBER
     * @uses self::VALUE_NOT_AVAILABLE
     * @uses self::VALUE_PRIVATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIRECTORY_NUMBER,
            self::VALUE_NOT_AVAILABLE,
            self::VALUE_PRIVATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
