<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBriProtocol EnumType
 * @subpackage Enumerations
 */
class XBriProtocol
{
    /**
     * Constant for value 'BRI NET3'
     * @return string 'BRI NET3'
     */
    const VALUE_BRI_NET_3 = 'BRI NET3';
    /**
     * Constant for value 'NI'
     * @return string 'NI'
     */
    const VALUE_NI = 'NI';
    /**
     * Constant for value 'QSIG'
     * @return string 'QSIG'
     */
    const VALUE_QSIG = 'QSIG';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BRI_NET_3
     * @uses self::VALUE_NI
     * @uses self::VALUE_QSIG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BRI_NET_3,
            self::VALUE_NI,
            self::VALUE_QSIG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
