<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBillingserverprotocol EnumType
 * @subpackage Enumerations
 */
class XBillingserverprotocol
{
    /**
     * Constant for value 'SFTP'
     * @return string 'SFTP'
     */
    const VALUE_SFTP = 'SFTP';
    /**
     * Constant for value 'FTP'
     * @return string 'FTP'
     */
    const VALUE_FTP = 'FTP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SFTP
     * @uses self::VALUE_FTP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SFTP,
            self::VALUE_FTP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
