<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBandwidth EnumType
 * @subpackage Enumerations
 */
class XBandwidth
{
    /**
     * Constant for value 'Keep Current Setting'
     * @return string 'Keep Current Setting'
     */
    const VALUE_KEEP_CURRENT_SETTING = 'Keep Current Setting';
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'G.723'
     * @return string 'G.723'
     */
    const VALUE_G_723 = 'G.723';
    /**
     * Constant for value 'G.729'
     * @return string 'G.729'
     */
    const VALUE_G_729 = 'G.729';
    /**
     * Constant for value 'GSM'
     * @return string 'GSM'
     */
    const VALUE_GSM = 'GSM';
    /**
     * Constant for value 'G.728'
     * @return string 'G.728'
     */
    const VALUE_G_728 = 'G.728';
    /**
     * Constant for value 'AMR-WB'
     * @return string 'AMR-WB'
     */
    const VALUE_AMR_WB = 'AMR-WB';
    /**
     * Constant for value 'iSAC'
     * @return string 'iSAC'
     */
    const VALUE_I_SAC = 'iSAC';
    /**
     * Constant for value 'G.711'
     * @return string 'G.711'
     */
    const VALUE_G_711 = 'G.711';
    /**
     * Constant for value 'AAC-LD-LATM'
     * @return string 'AAC-LD-LATM'
     */
    const VALUE_AAC_LD_LATM = 'AAC-LD-LATM';
    /**
     * Constant for value 'Wideband'
     * @return string 'Wideband'
     */
    const VALUE_WIDEBAND = 'Wideband';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEEP_CURRENT_SETTING
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_G_723
     * @uses self::VALUE_G_729
     * @uses self::VALUE_GSM
     * @uses self::VALUE_G_728
     * @uses self::VALUE_AMR_WB
     * @uses self::VALUE_I_SAC
     * @uses self::VALUE_G_711
     * @uses self::VALUE_AAC_LD_LATM
     * @uses self::VALUE_WIDEBAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEEP_CURRENT_SETTING,
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_G_723,
            self::VALUE_G_729,
            self::VALUE_GSM,
            self::VALUE_G_728,
            self::VALUE_AMR_WB,
            self::VALUE_I_SAC,
            self::VALUE_G_711,
            self::VALUE_AAC_LD_LATM,
            self::VALUE_WIDEBAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
