<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBATUsage EnumType
 * @subpackage Enumerations
 */
class XBATUsage
{
    /**
     * Constant for value 'Select'
     * @return string 'Select'
     */
    const VALUE_SELECT = 'Select';
    /**
     * Constant for value 'Set Values'
     * @return string 'Set Values'
     */
    const VALUE_SET_VALUES = 'Set Values';
    /**
     * Constant for value 'File Format'
     * @return string 'File Format'
     */
    const VALUE_FILE_FORMAT = 'File Format';
    /**
     * Constant for value 'UI Values'
     * @return string 'UI Values'
     */
    const VALUE_UI_VALUES = 'UI Values';
    /**
     * Constant for value 'System File Format'
     * @return string 'System File Format'
     */
    const VALUE_SYSTEM_FILE_FORMAT = 'System File Format';
    /**
     * Constant for value 'Display Query'
     * @return string 'Display Query'
     */
    const VALUE_DISPLAY_QUERY = 'Display Query';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELECT
     * @uses self::VALUE_SET_VALUES
     * @uses self::VALUE_FILE_FORMAT
     * @uses self::VALUE_UI_VALUES
     * @uses self::VALUE_SYSTEM_FILE_FORMAT
     * @uses self::VALUE_DISPLAY_QUERY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELECT,
            self::VALUE_SET_VALUES,
            self::VALUE_FILE_FORMAT,
            self::VALUE_UI_VALUES,
            self::VALUE_SYSTEM_FILE_FORMAT,
            self::VALUE_DISPLAY_QUERY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
