<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBATFile EnumType
 * @subpackage Enumerations
 */
class XBATFile
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Insert Files'
     * @return string 'Insert Files'
     */
    const VALUE_INSERT_FILES = 'Insert Files';
    /**
     * Constant for value 'Export Files'
     * @return string 'Export Files'
     */
    const VALUE_EXPORT_FILES = 'Export Files';
    /**
     * Constant for value 'Report Files'
     * @return string 'Report Files'
     */
    const VALUE_REPORT_FILES = 'Report Files';
    /**
     * Constant for value 'Custom Files'
     * @return string 'Custom Files'
     */
    const VALUE_CUSTOM_FILES = 'Custom Files';
    /**
     * Constant for value 'Log Files'
     * @return string 'Log Files'
     */
    const VALUE_LOG_FILES = 'Log Files';
    /**
     * Constant for value 'BAT Excel Template'
     * @return string 'BAT Excel Template'
     */
    const VALUE_BAT_EXCEL_TEMPLATE = 'BAT Excel Template';
    /**
     * Constant for value 'Tar Files'
     * @return string 'Tar Files'
     */
    const VALUE_TAR_FILES = 'Tar Files';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_INSERT_FILES
     * @uses self::VALUE_EXPORT_FILES
     * @uses self::VALUE_REPORT_FILES
     * @uses self::VALUE_CUSTOM_FILES
     * @uses self::VALUE_LOG_FILES
     * @uses self::VALUE_BAT_EXCEL_TEMPLATE
     * @uses self::VALUE_TAR_FILES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_INSERT_FILES,
            self::VALUE_EXPORT_FILES,
            self::VALUE_REPORT_FILES,
            self::VALUE_CUSTOM_FILES,
            self::VALUE_LOG_FILES,
            self::VALUE_BAT_EXCEL_TEMPLATE,
            self::VALUE_TAR_FILES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
