<?php

namespace CUCM\EnumType;

/**
 * This class stands for XAdminError EnumType
 * @subpackage Enumerations
 */
class XAdminError
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Failure'
     * @return string 'Failure'
     */
    const VALUE_FAILURE = 'Failure';
    /**
     * Constant for value 'Invalid range for directory numbers'
     * @return string 'Invalid range for directory numbers'
     */
    const VALUE_INVALID_RANGE_FOR_DIRECTORY_NUMBERS = 'Invalid range for directory numbers';
    /**
     * Constant for value 'Not yet implemented. See log for more detail'
     * @return string 'Not yet implemented. See log for more detail'
     */
    const VALUE_NOT_YET_IMPLEMENTED_SEE_LOG_FOR_MORE_DETAIL = 'Not yet implemented. See log for more detail';
    /**
     * Constant for value 'Model and class are not compatible.  See log for more
     * detail'
     * @return string 'Model and class are not compatible.  See log for more detail'
     */
    const VALUE_MODEL_AND_CLASS_ARE_NOT_COMPATIBLE_SEE_LOG_FOR_MORE_DETAIL = 'Model and class are not compatible.  See log for more detail';
    /**
     * Constant for value 'Missing/invalid parameters. See log for more detail'
     * @return string 'Missing/invalid parameters. See log for more detail'
     */
    const VALUE_MISSING_INVALID_PARAMETERS_SEE_LOG_FOR_MORE_DETAIL = 'Missing/invalid parameters. See log for more detail';
    /**
     * Constant for value 'Device does not suppport MLPP'
     * @return string 'Device does not suppport MLPP'
     */
    const VALUE_DEVICE_DOES_NOT_SUPPPORT_MLPP = 'Device does not suppport MLPP';
    /**
     * Constant for value 'Device does not support preemption'
     * @return string 'Device does not support preemption'
     */
    const VALUE_DEVICE_DOES_NOT_SUPPORT_PREEMPTION = 'Device does not support preemption';
    /**
     * Constant for value 'User is not a valid end user or application user'
     * @return string 'User is not a valid end user or application user'
     */
    const VALUE_USER_IS_NOT_A_VALID_END_USER_OR_APPLICATION_USER = 'User is not a valid end user or application user';
    /**
     * Constant for value 'Missing default phone template'
     * @return string 'Missing default phone template'
     */
    const VALUE_MISSING_DEFAULT_PHONE_TEMPLATE = 'Missing default phone template';
    /**
     * Constant for value 'Encountered unexpected database datatype.  See log for more
     * detail'
     * @return string 'Encountered unexpected database datatype.  See log for more detail'
     */
    const VALUE_ENCOUNTERED_UNEXPECTED_DATABASE_DATATYPE_SEE_LOG_FOR_MORE_DETAIL = 'Encountered unexpected database datatype.  See log for more detail';
    /**
     * Constant for value 'Updated failed. A required item was not found in the
     * database'
     * @return string 'Updated failed. A required item was not found in the database'
     */
    const VALUE_UPDATED_FAILED_A_REQUIRED_ITEM_WAS_NOT_FOUND_IN_THE_DATABASE = 'Updated failed. A required item was not found in the database';
    /**
     * Constant for value 'The Cisco CallManager Group cannot be deleted because it is
     * used by related records. Click Dependency Records to view related records and
     * remove this Cisco CallManager Group from any item that is using it then try
     * again.'
     * @return string 'The Cisco CallManager Group cannot be deleted because it is used by related records. Click Dependency Records to view related records and remove this Cisco CallManager Group from any item that is using it then try again.'
     */
    const VALUE_THE_CISCO_CALL_MANAGER_GROUP_CANNOT_BE_DELETED_BECAUSE_IT_IS_USED_BY_RELATED_RECORDS_CLICK_DEPENDENCY_RECORDS_TO_VIEW_RELATED_RECORDS_AND_REMOVE_THIS_CISCO_CALL_MANAGER_GROUP_FROM_ANY_ITEM_THAT_IS_USING_IT_THEN_TRY_AGAIN = 'The Cisco CallManager Group cannot be deleted because it is used by related records. Click Dependency Records to view related records and remove this Cisco CallManager Group from any item that is using it then try again.';
    /**
     * Constant for value 'One or more Cisco CallManager Groups could not be deleted
     * because it is used by related records. Select a Cisco CallManager Group and
     * click the Dependancy Records link on the Cisco CallManager Configuration page to
     * see what is using it.'
     * @return string 'One or more Cisco CallManager Groups could not be deleted because it is used by related records. Select a Cisco CallManager Group and click the Dependancy Records link on the Cisco CallManager Configuration page to see what is using it.'
     */
    const VALUE_ONE_OR_MORE_CISCO_CALL_MANAGER_GROUPS_COULD_NOT_BE_DELETED_BECAUSE_IT_IS_USED_BY_RELATED_RECORDS_SELECT_A_CISCO_CALL_MANAGER_GROUP_AND_CLICK_THE_DEPENDANCY_RECORDS_LINK_ON_THE_CISCO_CALL_MANAGER_CONFIGURATION_PAGE_TO_SEE_WHAT_IS_USING_IT = 'One or more Cisco CallManager Groups could not be deleted because it is used by related records. Select a Cisco CallManager Group and click the Dependancy Records link on the Cisco CallManager Configuration page to see what is using it.';
    /**
     * Constant for value 'Cannot create DNs or duplicate DNs for the ports. Please
     * check if a DN range is available.'
     * @return string 'Cannot create DNs or duplicate DNs for the ports. Please check if a DN range is available.'
     */
    const VALUE_CANNOT_CREATE_DNS_OR_DUPLICATE_DNS_FOR_THE_PORTS_PLEASE_CHECK_IF_A_DN_RANGE_IS_AVAILABLE = 'Cannot create DNs or duplicate DNs for the ports. Please check if a DN range is available.';
    /**
     * Constant for value 'Partition name cannot be empty string.'
     * @return string 'Partition name cannot be empty string.'
     */
    const VALUE_PARTITION_NAME_CANNOT_BE_EMPTY_STRING = 'Partition name cannot be empty string.';
    /**
     * Constant for value 'Change failed - Current Password is incorrect.'
     * @return string 'Change failed - Current Password is incorrect.'
     */
    const VALUE_CHANGE_FAILED_CURRENT_PASSWORD_IS_INCORRECT = 'Change failed - Current Password is incorrect.';
    /**
     * Constant for value 'Change failed - New Password does not match Confirm
     * Password.'
     * @return string 'Change failed - New Password does not match Confirm Password.'
     */
    const VALUE_CHANGE_FAILED_NEW_PASSWORD_DOES_NOT_MATCH_CONFIRM_PASSWORD = 'Change failed - New Password does not match Confirm Password.';
    /**
     * Constant for value 'Change failed - Current PIN is incorrect.'
     * @return string 'Change failed - Current PIN is incorrect.'
     */
    const VALUE_CHANGE_FAILED_CURRENT_PIN_IS_INCORRECT = 'Change failed - Current PIN is incorrect.';
    /**
     * Constant for value 'Change failed - New PIN does not match Confirm PIN.'
     * @return string 'Change failed - New PIN does not match Confirm PIN.'
     */
    const VALUE_CHANGE_FAILED_NEW_PIN_DOES_NOT_MATCH_CONFIRM_PIN = 'Change failed - New PIN does not match Confirm PIN.';
    /**
     * Constant for value 'Fastdials index already in use. Please choose another
     * index.'
     * @return string 'Fastdials index already in use. Please choose another index.'
     */
    const VALUE_FASTDIALS_INDEX_ALREADY_IN_USE_PLEASE_CHOOSE_ANOTHER_INDEX = 'Fastdials index already in use. Please choose another index.';
    /**
     * Constant for value 'Fastdials phone number already in use. Please choose another
     * phone number.'
     * @return string 'Fastdials phone number already in use. Please choose another phone number.'
     */
    const VALUE_FASTDIALS_PHONE_NUMBER_ALREADY_IN_USE_PLEASE_CHOOSE_ANOTHER_PHONE_NUMBER = 'Fastdials phone number already in use. Please choose another phone number.';
    /**
     * Constant for value 'Cisco Unity Connection Server returned a SQL Exception. 
     * Please check the log file.'
     * @return string 'Cisco Unity Connection Server returned a SQL Exception.  Please check the log file.'
     */
    const VALUE_CISCO_UNITY_CONNECTION_SERVER_RETURNED_A_SQL_EXCEPTION_PLEASE_CHECK_THE_LOG_FILE = 'Cisco Unity Connection Server returned a SQL Exception.  Please check the log file.';
    /**
     * Constant for value 'Unable to delete user account from Cisco Unity Connection
     * Server.  Please check the log file.'
     * @return string 'Unable to delete user account from Cisco Unity Connection Server.  Please check the log file.'
     */
    const VALUE_UNABLE_TO_DELETE_USER_ACCOUNT_FROM_CISCO_UNITY_CONNECTION_SERVER_PLEASE_CHECK_THE_LOG_FILE = 'Unable to delete user account from Cisco Unity Connection Server.  Please check the log file.';
    /**
     * Constant for value 'File uploaded does not have extension .lic.  Please upload a
     * license file with extension .lic.'
     * @return string 'File uploaded does not have extension .lic.  Please upload a license file with extension .lic.'
     */
    const VALUE_FILE_UPLOADED_DOES_NOT_HAVE_EXTENSION_LIC_PLEASE_UPLOAD_A_LICENSE_FILE_WITH_EXTENSION_LIC = 'File uploaded does not have extension .lic.  Please upload a license file with extension .lic.';
    /**
     * Constant for value 'A file with this name already exists in the license file
     * directory.  Please upload a file with a different name.'
     * @return string 'A file with this name already exists in the license file directory.  Please upload a file with a different name.'
     */
    const VALUE_A_FILE_WITH_THIS_NAME_ALREADY_EXISTS_IN_THE_LICENSE_FILE_DIRECTORY_PLEASE_UPLOAD_A_FILE_WITH_A_DIFFERENT_NAME = 'A file with this name already exists in the license file directory.  Please upload a file with a different name.';
    /**
     * Constant for value 'Unable to obtain certificate for this IP address/Port.  SRST
     * reference has been changed to non-secured and saved. Please disable the security
     * services on the gateway if you do not use the security feature.'
     * @return string 'Unable to obtain certificate for this IP address/Port.  SRST reference has been changed to non-secured and saved. Please disable the security services on the gateway if you do not use the security feature.'
     */
    const VALUE_UNABLE_TO_OBTAIN_CERTIFICATE_FOR_THIS_IP_ADDRESS_PORT_SRST_REFERENCE_HAS_BEEN_CHANGED_TO_NON_SECURED_AND_SAVED_PLEASE_DISABLE_THE_SECURITY_SERVICES_ON_THE_GATEWAY_IF_YOU_DO_NOT_USE_THE_SECURITY_FEATURE = 'Unable to obtain certificate for this IP address/Port.  SRST reference has been changed to non-secured and saved. Please disable the security services on the gateway if you do not use the security feature.';
    /**
     * Constant for value 'DN/Route Pattern must be the last search parameter when
     * using the Search Within Results option.'
     * @return string 'DN/Route Pattern must be the last search parameter when using the Search Within Results option.'
     */
    const VALUE_DN_ROUTE_PATTERN_MUST_BE_THE_LAST_SEARCH_PARAMETER_WHEN_USING_THE_SEARCH_WITHIN_RESULTS_OPTION = 'DN/Route Pattern must be the last search parameter when using the Search Within Results option.';
    /**
     * Constant for value 'Route Group Name and Directory Number are not allowed in the
     * same search.'
     * @return string 'Route Group Name and Directory Number are not allowed in the same search.'
     */
    const VALUE_ROUTE_GROUP_NAME_AND_DIRECTORY_NUMBER_ARE_NOT_ALLOWED_IN_THE_SAME_SEARCH = 'Route Group Name and Directory Number are not allowed in the same search.';
    /**
     * Constant for value 'user is not member of super user group. Cannot add to groups
     * the roles which are only accessible to super users'
     * @return string 'user is not member of super user group. Cannot add to groups the roles which are only accessible to super users'
     */
    const VALUE_USER_IS_NOT_MEMBER_OF_SUPER_USER_GROUP_CANNOT_ADD_TO_GROUPS_THE_ROLES_WHICH_ARE_ONLY_ACCESSIBLE_TO_SUPER_USERS = 'user is not member of super user group. Cannot add to groups the roles which are only accessible to super users';
    /**
     * Constant for value 'Only super users can update members of super user groups'
     * @return string 'Only super users can update members of super user groups'
     */
    const VALUE_ONLY_SUPER_USERS_CAN_UPDATE_MEMBERS_OF_SUPER_USER_GROUPS = 'Only super users can update members of super user groups';
    /**
     * Constant for value 'Users who are not super users cannot add him/herself to
     * groups'
     * @return string 'Users who are not super users cannot add him/herself to groups'
     */
    const VALUE_USERS_WHO_ARE_NOT_SUPER_USERS_CANNOT_ADD_HIM_HERSELF_TO_GROUPS = 'Users who are not super users cannot add him/herself to groups';
    /**
     * Constant for value 'Propagation failed for some devices. See log for a list of
     * failed devices.'
     * @return string 'Propagation failed for some devices. See log for a list of failed devices.'
     */
    const VALUE_PROPAGATION_FAILED_FOR_SOME_DEVICES_SEE_LOG_FOR_A_LIST_OF_FAILED_DEVICES = 'Propagation failed for some devices. See log for a list of failed devices.';
    /**
     * Constant for value 'Change failed - Credential locked. Please contact your
     * administrator.'
     * @return string 'Change failed - Credential locked. Please contact your administrator.'
     */
    const VALUE_CHANGE_FAILED_CREDENTIAL_LOCKED_PLEASE_CONTACT_YOUR_ADMINISTRATOR = 'Change failed - Credential locked. Please contact your administrator.';
    /**
     * Constant for value 'Change failed - Credential locked due to inactivity. Please
     * contact your administrator.'
     * @return string 'Change failed - Credential locked due to inactivity. Please contact your administrator.'
     */
    const VALUE_CHANGE_FAILED_CREDENTIAL_LOCKED_DUE_TO_INACTIVITY_PLEASE_CONTACT_YOUR_ADMINISTRATOR = 'Change failed - Credential locked due to inactivity. Please contact your administrator.';
    /**
     * Constant for value 'Unknown credential validation error.  Please contact your
     * administrator.'
     * @return string 'Unknown credential validation error.  Please contact your administrator.'
     */
    const VALUE_UNKNOWN_CREDENTIAL_VALIDATION_ERROR_PLEASE_CONTACT_YOUR_ADMINISTRATOR = 'Unknown credential validation error.  Please contact your administrator.';
    /**
     * Constant for value 'Upload Failed. Please upload a valid Audio File.'
     * @return string 'Upload Failed. Please upload a valid Audio File.'
     */
    const VALUE_UPLOAD_FAILED_PLEASE_UPLOAD_A_VALID_AUDIO_FILE = 'Upload Failed. Please upload a valid Audio File.';
    /**
     * Constant for value 'Import Failed. Please import a valid file.'
     * @return string 'Import Failed. Please import a valid file.'
     */
    const VALUE_IMPORT_FAILED_PLEASE_IMPORT_A_VALID_FILE = 'Import Failed. Please import a valid file.';
    /**
     * Constant for value 'Normalization Script Parameters are formatted incorrectly.'
     * @return string 'Normalization Script Parameters are formatted incorrectly.'
     */
    const VALUE_NORMALIZATION_SCRIPT_PARAMETERS_ARE_FORMATTED_INCORRECTLY = 'Normalization Script Parameters are formatted incorrectly.';
    /**
     * Constant for value 'Wrong Credential.'
     * @return string 'Wrong Credential.'
     */
    const VALUE_WRONG_CREDENTIAL = 'Wrong Credential.';
    /**
     * Constant for value 'Administrative Lock.'
     * @return string 'Administrative Lock.'
     */
    const VALUE_ADMINISTRATIVE_LOCK = 'Administrative Lock.';
    /**
     * Constant for value 'Hack Lock.'
     * @return string 'Hack Lock.'
     */
    const VALUE_HACK_LOCK = 'Hack Lock.';
    /**
     * Constant for value 'Inactive Lock.'
     * @return string 'Inactive Lock.'
     */
    const VALUE_INACTIVE_LOCK = 'Inactive Lock.';
    /**
     * Constant for value 'Expired Lock.'
     * @return string 'Expired Lock.'
     */
    const VALUE_EXPIRED_LOCK = 'Expired Lock.';
    /**
     * Constant for value 'Expired Lock (with ability to change).'
     * @return string 'Expired Lock (with ability to change).'
     */
    const VALUE_EXPIRED_LOCK_WITH_ABILITY_TO_CHANGE = 'Expired Lock (with ability to change).';
    /**
     * Constant for value 'End user status is INACTIVE in LDAP.'
     * @return string 'End user status is INACTIVE in LDAP.'
     */
    const VALUE_END_USER_STATUS_IS_INACTIVE_IN_LDAP = 'End user status is INACTIVE in LDAP.';
    /**
     * Constant for value 'LDAP authentication enabled. UpdateCredential failure.'
     * @return string 'LDAP authentication enabled. UpdateCredential failure.'
     */
    const VALUE_LDAP_AUTHENTICATION_ENABLED_UPDATE_CREDENTIAL_FAILURE = 'LDAP authentication enabled. UpdateCredential failure.';
    /**
     * Constant for value 'Invalid credential length.'
     * @return string 'Invalid credential length.'
     */
    const VALUE_INVALID_CREDENTIAL_LENGTH = 'Invalid credential length.';
    /**
     * Constant for value 'Trivial credential.'
     * @return string 'Trivial credential.'
     */
    const VALUE_TRIVIAL_CREDENTIAL = 'Trivial credential.';
    /**
     * Constant for value 'Duplicate credential.'
     * @return string 'Duplicate credential.'
     */
    const VALUE_DUPLICATE_CREDENTIAL = 'Duplicate credential.';
    /**
     * Constant for value 'Too recently used Credential.'
     * @return string 'Too recently used Credential.'
     */
    const VALUE_TOO_RECENTLY_USED_CREDENTIAL = 'Too recently used Credential.';
    /**
     * Constant for value 'User does not have permission to change this credential.'
     * @return string 'User does not have permission to change this credential.'
     */
    const VALUE_USER_DOES_NOT_HAVE_PERMISSION_TO_CHANGE_THIS_CREDENTIAL = 'User does not have permission to change this credential.';
    /**
     * Constant for value 'There is no credential value for the given credential name.'
     * @return string 'There is no credential value for the given credential name.'
     */
    const VALUE_THERE_IS_NO_CREDENTIAL_VALUE_FOR_THE_GIVEN_CREDENTIAL_NAME = 'There is no credential value for the given credential name.';
    /**
     * Constant for value 'There is no credential type for the given credential name.'
     * @return string 'There is no credential type for the given credential name.'
     */
    const VALUE_THERE_IS_NO_CREDENTIAL_TYPE_FOR_THE_GIVEN_CREDENTIAL_NAME = 'There is no credential type for the given credential name.';
    /**
     * Constant for value 'LDAP communication error. Please check log file.'
     * @return string 'LDAP communication error. Please check log file.'
     */
    const VALUE_LDAP_COMMUNICATION_ERROR_PLEASE_CHECK_LOG_FILE = 'LDAP communication error. Please check log file.';
    /**
     * Constant for value 'User type not defined. Please check log file.'
     * @return string 'User type not defined. Please check log file.'
     */
    const VALUE_USER_TYPE_NOT_DEFINED_PLEASE_CHECK_LOG_FILE = 'User type not defined. Please check log file.';
    /**
     * Constant for value 'Failed to update Credential. Please check log file.'
     * @return string 'Failed to update Credential. Please check log file.'
     */
    const VALUE_FAILED_TO_UPDATE_CREDENTIAL_PLEASE_CHECK_LOG_FILE = 'Failed to update Credential. Please check log file.';
    /**
     * Constant for value 'Not a valid application user. Please check log file.'
     * @return string 'Not a valid application user. Please check log file.'
     */
    const VALUE_NOT_A_VALID_APPLICATION_USER_PLEASE_CHECK_LOG_FILE = 'Not a valid application user. Please check log file.';
    /**
     * Constant for value 'Database communication error. Please check log file.'
     * @return string 'Database communication error. Please check log file.'
     */
    const VALUE_DATABASE_COMMUNICATION_ERROR_PLEASE_CHECK_LOG_FILE = 'Database communication error. Please check log file.';
    /**
     * Constant for value 'Invalid credential information. Please check log file.'
     * @return string 'Invalid credential information. Please check log file.'
     */
    const VALUE_INVALID_CREDENTIAL_INFORMATION_PLEASE_CHECK_LOG_FILE = 'Invalid credential information. Please check log file.';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_FAILURE
     * @uses self::VALUE_INVALID_RANGE_FOR_DIRECTORY_NUMBERS
     * @uses self::VALUE_NOT_YET_IMPLEMENTED_SEE_LOG_FOR_MORE_DETAIL
     * @uses self::VALUE_MODEL_AND_CLASS_ARE_NOT_COMPATIBLE_SEE_LOG_FOR_MORE_DETAIL
     * @uses self::VALUE_MISSING_INVALID_PARAMETERS_SEE_LOG_FOR_MORE_DETAIL
     * @uses self::VALUE_DEVICE_DOES_NOT_SUPPPORT_MLPP
     * @uses self::VALUE_DEVICE_DOES_NOT_SUPPORT_PREEMPTION
     * @uses self::VALUE_USER_IS_NOT_A_VALID_END_USER_OR_APPLICATION_USER
     * @uses self::VALUE_MISSING_DEFAULT_PHONE_TEMPLATE
     * @uses self::VALUE_ENCOUNTERED_UNEXPECTED_DATABASE_DATATYPE_SEE_LOG_FOR_MORE_DETAIL
     * @uses self::VALUE_UPDATED_FAILED_A_REQUIRED_ITEM_WAS_NOT_FOUND_IN_THE_DATABASE
     * @uses self::VALUE_THE_CISCO_CALL_MANAGER_GROUP_CANNOT_BE_DELETED_BECAUSE_IT_IS_USED_BY_RELATED_RECORDS_CLICK_DEPENDENCY_RECORDS_TO_VIEW_RELATED_RECORDS_AND_REMOVE_THIS_CISCO_CALL_MANAGER_GROUP_FROM_ANY_ITEM_THAT_IS_USING_IT_THEN_TRY_AGAIN
     * @uses self::VALUE_ONE_OR_MORE_CISCO_CALL_MANAGER_GROUPS_COULD_NOT_BE_DELETED_BECAUSE_IT_IS_USED_BY_RELATED_RECORDS_SELECT_A_CISCO_CALL_MANAGER_GROUP_AND_CLICK_THE_DEPENDANCY_RECORDS_LINK_ON_THE_CISCO_CALL_MANAGER_CONFIGURATION_PAGE_TO_SEE_WHAT_IS_USING_IT
     * @uses self::VALUE_CANNOT_CREATE_DNS_OR_DUPLICATE_DNS_FOR_THE_PORTS_PLEASE_CHECK_IF_A_DN_RANGE_IS_AVAILABLE
     * @uses self::VALUE_PARTITION_NAME_CANNOT_BE_EMPTY_STRING
     * @uses self::VALUE_CHANGE_FAILED_CURRENT_PASSWORD_IS_INCORRECT
     * @uses self::VALUE_CHANGE_FAILED_NEW_PASSWORD_DOES_NOT_MATCH_CONFIRM_PASSWORD
     * @uses self::VALUE_CHANGE_FAILED_CURRENT_PIN_IS_INCORRECT
     * @uses self::VALUE_CHANGE_FAILED_NEW_PIN_DOES_NOT_MATCH_CONFIRM_PIN
     * @uses self::VALUE_FASTDIALS_INDEX_ALREADY_IN_USE_PLEASE_CHOOSE_ANOTHER_INDEX
     * @uses self::VALUE_FASTDIALS_PHONE_NUMBER_ALREADY_IN_USE_PLEASE_CHOOSE_ANOTHER_PHONE_NUMBER
     * @uses self::VALUE_CISCO_UNITY_CONNECTION_SERVER_RETURNED_A_SQL_EXCEPTION_PLEASE_CHECK_THE_LOG_FILE
     * @uses self::VALUE_UNABLE_TO_DELETE_USER_ACCOUNT_FROM_CISCO_UNITY_CONNECTION_SERVER_PLEASE_CHECK_THE_LOG_FILE
     * @uses self::VALUE_FILE_UPLOADED_DOES_NOT_HAVE_EXTENSION_LIC_PLEASE_UPLOAD_A_LICENSE_FILE_WITH_EXTENSION_LIC
     * @uses self::VALUE_A_FILE_WITH_THIS_NAME_ALREADY_EXISTS_IN_THE_LICENSE_FILE_DIRECTORY_PLEASE_UPLOAD_A_FILE_WITH_A_DIFFERENT_NAME
     * @uses self::VALUE_UNABLE_TO_OBTAIN_CERTIFICATE_FOR_THIS_IP_ADDRESS_PORT_SRST_REFERENCE_HAS_BEEN_CHANGED_TO_NON_SECURED_AND_SAVED_PLEASE_DISABLE_THE_SECURITY_SERVICES_ON_THE_GATEWAY_IF_YOU_DO_NOT_USE_THE_SECURITY_FEATURE
     * @uses self::VALUE_DN_ROUTE_PATTERN_MUST_BE_THE_LAST_SEARCH_PARAMETER_WHEN_USING_THE_SEARCH_WITHIN_RESULTS_OPTION
     * @uses self::VALUE_ROUTE_GROUP_NAME_AND_DIRECTORY_NUMBER_ARE_NOT_ALLOWED_IN_THE_SAME_SEARCH
     * @uses self::VALUE_USER_IS_NOT_MEMBER_OF_SUPER_USER_GROUP_CANNOT_ADD_TO_GROUPS_THE_ROLES_WHICH_ARE_ONLY_ACCESSIBLE_TO_SUPER_USERS
     * @uses self::VALUE_ONLY_SUPER_USERS_CAN_UPDATE_MEMBERS_OF_SUPER_USER_GROUPS
     * @uses self::VALUE_USERS_WHO_ARE_NOT_SUPER_USERS_CANNOT_ADD_HIM_HERSELF_TO_GROUPS
     * @uses self::VALUE_PROPAGATION_FAILED_FOR_SOME_DEVICES_SEE_LOG_FOR_A_LIST_OF_FAILED_DEVICES
     * @uses self::VALUE_CHANGE_FAILED_CREDENTIAL_LOCKED_PLEASE_CONTACT_YOUR_ADMINISTRATOR
     * @uses self::VALUE_CHANGE_FAILED_CREDENTIAL_LOCKED_DUE_TO_INACTIVITY_PLEASE_CONTACT_YOUR_ADMINISTRATOR
     * @uses self::VALUE_UNKNOWN_CREDENTIAL_VALIDATION_ERROR_PLEASE_CONTACT_YOUR_ADMINISTRATOR
     * @uses self::VALUE_UPLOAD_FAILED_PLEASE_UPLOAD_A_VALID_AUDIO_FILE
     * @uses self::VALUE_IMPORT_FAILED_PLEASE_IMPORT_A_VALID_FILE
     * @uses self::VALUE_NORMALIZATION_SCRIPT_PARAMETERS_ARE_FORMATTED_INCORRECTLY
     * @uses self::VALUE_WRONG_CREDENTIAL
     * @uses self::VALUE_ADMINISTRATIVE_LOCK
     * @uses self::VALUE_HACK_LOCK
     * @uses self::VALUE_INACTIVE_LOCK
     * @uses self::VALUE_EXPIRED_LOCK
     * @uses self::VALUE_EXPIRED_LOCK_WITH_ABILITY_TO_CHANGE
     * @uses self::VALUE_END_USER_STATUS_IS_INACTIVE_IN_LDAP
     * @uses self::VALUE_LDAP_AUTHENTICATION_ENABLED_UPDATE_CREDENTIAL_FAILURE
     * @uses self::VALUE_INVALID_CREDENTIAL_LENGTH
     * @uses self::VALUE_TRIVIAL_CREDENTIAL
     * @uses self::VALUE_DUPLICATE_CREDENTIAL
     * @uses self::VALUE_TOO_RECENTLY_USED_CREDENTIAL
     * @uses self::VALUE_USER_DOES_NOT_HAVE_PERMISSION_TO_CHANGE_THIS_CREDENTIAL
     * @uses self::VALUE_THERE_IS_NO_CREDENTIAL_VALUE_FOR_THE_GIVEN_CREDENTIAL_NAME
     * @uses self::VALUE_THERE_IS_NO_CREDENTIAL_TYPE_FOR_THE_GIVEN_CREDENTIAL_NAME
     * @uses self::VALUE_LDAP_COMMUNICATION_ERROR_PLEASE_CHECK_LOG_FILE
     * @uses self::VALUE_USER_TYPE_NOT_DEFINED_PLEASE_CHECK_LOG_FILE
     * @uses self::VALUE_FAILED_TO_UPDATE_CREDENTIAL_PLEASE_CHECK_LOG_FILE
     * @uses self::VALUE_NOT_A_VALID_APPLICATION_USER_PLEASE_CHECK_LOG_FILE
     * @uses self::VALUE_DATABASE_COMMUNICATION_ERROR_PLEASE_CHECK_LOG_FILE
     * @uses self::VALUE_INVALID_CREDENTIAL_INFORMATION_PLEASE_CHECK_LOG_FILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_FAILURE,
            self::VALUE_INVALID_RANGE_FOR_DIRECTORY_NUMBERS,
            self::VALUE_NOT_YET_IMPLEMENTED_SEE_LOG_FOR_MORE_DETAIL,
            self::VALUE_MODEL_AND_CLASS_ARE_NOT_COMPATIBLE_SEE_LOG_FOR_MORE_DETAIL,
            self::VALUE_MISSING_INVALID_PARAMETERS_SEE_LOG_FOR_MORE_DETAIL,
            self::VALUE_DEVICE_DOES_NOT_SUPPPORT_MLPP,
            self::VALUE_DEVICE_DOES_NOT_SUPPORT_PREEMPTION,
            self::VALUE_USER_IS_NOT_A_VALID_END_USER_OR_APPLICATION_USER,
            self::VALUE_MISSING_DEFAULT_PHONE_TEMPLATE,
            self::VALUE_ENCOUNTERED_UNEXPECTED_DATABASE_DATATYPE_SEE_LOG_FOR_MORE_DETAIL,
            self::VALUE_UPDATED_FAILED_A_REQUIRED_ITEM_WAS_NOT_FOUND_IN_THE_DATABASE,
            self::VALUE_THE_CISCO_CALL_MANAGER_GROUP_CANNOT_BE_DELETED_BECAUSE_IT_IS_USED_BY_RELATED_RECORDS_CLICK_DEPENDENCY_RECORDS_TO_VIEW_RELATED_RECORDS_AND_REMOVE_THIS_CISCO_CALL_MANAGER_GROUP_FROM_ANY_ITEM_THAT_IS_USING_IT_THEN_TRY_AGAIN,
            self::VALUE_ONE_OR_MORE_CISCO_CALL_MANAGER_GROUPS_COULD_NOT_BE_DELETED_BECAUSE_IT_IS_USED_BY_RELATED_RECORDS_SELECT_A_CISCO_CALL_MANAGER_GROUP_AND_CLICK_THE_DEPENDANCY_RECORDS_LINK_ON_THE_CISCO_CALL_MANAGER_CONFIGURATION_PAGE_TO_SEE_WHAT_IS_USING_IT,
            self::VALUE_CANNOT_CREATE_DNS_OR_DUPLICATE_DNS_FOR_THE_PORTS_PLEASE_CHECK_IF_A_DN_RANGE_IS_AVAILABLE,
            self::VALUE_PARTITION_NAME_CANNOT_BE_EMPTY_STRING,
            self::VALUE_CHANGE_FAILED_CURRENT_PASSWORD_IS_INCORRECT,
            self::VALUE_CHANGE_FAILED_NEW_PASSWORD_DOES_NOT_MATCH_CONFIRM_PASSWORD,
            self::VALUE_CHANGE_FAILED_CURRENT_PIN_IS_INCORRECT,
            self::VALUE_CHANGE_FAILED_NEW_PIN_DOES_NOT_MATCH_CONFIRM_PIN,
            self::VALUE_FASTDIALS_INDEX_ALREADY_IN_USE_PLEASE_CHOOSE_ANOTHER_INDEX,
            self::VALUE_FASTDIALS_PHONE_NUMBER_ALREADY_IN_USE_PLEASE_CHOOSE_ANOTHER_PHONE_NUMBER,
            self::VALUE_CISCO_UNITY_CONNECTION_SERVER_RETURNED_A_SQL_EXCEPTION_PLEASE_CHECK_THE_LOG_FILE,
            self::VALUE_UNABLE_TO_DELETE_USER_ACCOUNT_FROM_CISCO_UNITY_CONNECTION_SERVER_PLEASE_CHECK_THE_LOG_FILE,
            self::VALUE_FILE_UPLOADED_DOES_NOT_HAVE_EXTENSION_LIC_PLEASE_UPLOAD_A_LICENSE_FILE_WITH_EXTENSION_LIC,
            self::VALUE_A_FILE_WITH_THIS_NAME_ALREADY_EXISTS_IN_THE_LICENSE_FILE_DIRECTORY_PLEASE_UPLOAD_A_FILE_WITH_A_DIFFERENT_NAME,
            self::VALUE_UNABLE_TO_OBTAIN_CERTIFICATE_FOR_THIS_IP_ADDRESS_PORT_SRST_REFERENCE_HAS_BEEN_CHANGED_TO_NON_SECURED_AND_SAVED_PLEASE_DISABLE_THE_SECURITY_SERVICES_ON_THE_GATEWAY_IF_YOU_DO_NOT_USE_THE_SECURITY_FEATURE,
            self::VALUE_DN_ROUTE_PATTERN_MUST_BE_THE_LAST_SEARCH_PARAMETER_WHEN_USING_THE_SEARCH_WITHIN_RESULTS_OPTION,
            self::VALUE_ROUTE_GROUP_NAME_AND_DIRECTORY_NUMBER_ARE_NOT_ALLOWED_IN_THE_SAME_SEARCH,
            self::VALUE_USER_IS_NOT_MEMBER_OF_SUPER_USER_GROUP_CANNOT_ADD_TO_GROUPS_THE_ROLES_WHICH_ARE_ONLY_ACCESSIBLE_TO_SUPER_USERS,
            self::VALUE_ONLY_SUPER_USERS_CAN_UPDATE_MEMBERS_OF_SUPER_USER_GROUPS,
            self::VALUE_USERS_WHO_ARE_NOT_SUPER_USERS_CANNOT_ADD_HIM_HERSELF_TO_GROUPS,
            self::VALUE_PROPAGATION_FAILED_FOR_SOME_DEVICES_SEE_LOG_FOR_A_LIST_OF_FAILED_DEVICES,
            self::VALUE_CHANGE_FAILED_CREDENTIAL_LOCKED_PLEASE_CONTACT_YOUR_ADMINISTRATOR,
            self::VALUE_CHANGE_FAILED_CREDENTIAL_LOCKED_DUE_TO_INACTIVITY_PLEASE_CONTACT_YOUR_ADMINISTRATOR,
            self::VALUE_UNKNOWN_CREDENTIAL_VALIDATION_ERROR_PLEASE_CONTACT_YOUR_ADMINISTRATOR,
            self::VALUE_UPLOAD_FAILED_PLEASE_UPLOAD_A_VALID_AUDIO_FILE,
            self::VALUE_IMPORT_FAILED_PLEASE_IMPORT_A_VALID_FILE,
            self::VALUE_NORMALIZATION_SCRIPT_PARAMETERS_ARE_FORMATTED_INCORRECTLY,
            self::VALUE_WRONG_CREDENTIAL,
            self::VALUE_ADMINISTRATIVE_LOCK,
            self::VALUE_HACK_LOCK,
            self::VALUE_INACTIVE_LOCK,
            self::VALUE_EXPIRED_LOCK,
            self::VALUE_EXPIRED_LOCK_WITH_ABILITY_TO_CHANGE,
            self::VALUE_END_USER_STATUS_IS_INACTIVE_IN_LDAP,
            self::VALUE_LDAP_AUTHENTICATION_ENABLED_UPDATE_CREDENTIAL_FAILURE,
            self::VALUE_INVALID_CREDENTIAL_LENGTH,
            self::VALUE_TRIVIAL_CREDENTIAL,
            self::VALUE_DUPLICATE_CREDENTIAL,
            self::VALUE_TOO_RECENTLY_USED_CREDENTIAL,
            self::VALUE_USER_DOES_NOT_HAVE_PERMISSION_TO_CHANGE_THIS_CREDENTIAL,
            self::VALUE_THERE_IS_NO_CREDENTIAL_VALUE_FOR_THE_GIVEN_CREDENTIAL_NAME,
            self::VALUE_THERE_IS_NO_CREDENTIAL_TYPE_FOR_THE_GIVEN_CREDENTIAL_NAME,
            self::VALUE_LDAP_COMMUNICATION_ERROR_PLEASE_CHECK_LOG_FILE,
            self::VALUE_USER_TYPE_NOT_DEFINED_PLEASE_CHECK_LOG_FILE,
            self::VALUE_FAILED_TO_UPDATE_CREDENTIAL_PLEASE_CHECK_LOG_FILE,
            self::VALUE_NOT_A_VALID_APPLICATION_USER_PLEASE_CHECK_LOG_FILE,
            self::VALUE_DATABASE_COMMUNICATION_ERROR_PLEASE_CHECK_LOG_FILE,
            self::VALUE_INVALID_CREDENTIAL_INFORMATION_PLEASE_CHECK_LOG_FILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
