<?php

namespace CUCM\EnumType;

/**
 * This class stands for XAdminBoolean EnumType
 * @subpackage Enumerations
 */
class XAdminBoolean
{
    /**
     * Constant for value 'FALSE'
     * @return string 'FALSE'
     */
    const VALUE_FALSE = 'FALSE';
    /**
     * Constant for value 'TRUE'
     * @return string 'TRUE'
     */
    const VALUE_TRUE = 'TRUE';
    /**
     * Constant for value 'DEFAULT'
     * @return string 'DEFAULT'
     */
    const VALUE_DEFAULT = 'DEFAULT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FALSE
     * @uses self::VALUE_TRUE
     * @uses self::VALUE_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FALSE,
            self::VALUE_TRUE,
            self::VALUE_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
