<?php

namespace CUCM;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'XSipProfile' => '\\CUCM\\StructType\\XSipProfile',
            'AddSipProfileReq' => '\\CUCM\\StructType\\AddSipProfileReq',
            'UpdateSipProfileReq' => '\\CUCM\\StructType\\UpdateSipProfileReq',
            'GetSipProfileReq' => '\\CUCM\\StructType\\GetSipProfileReq',
            'GetSipProfileRes' => '\\CUCM\\StructType\\GetSipProfileRes',
            'return' => '\\CUCM\\StructType\\_return',
            'ListSipProfileReq' => '\\CUCM\\StructType\\ListSipProfileReq',
            'searchCriteria' => '\\CUCM\\StructType\\SearchCriteria',
            'ListSipProfileRes' => '\\CUCM\\StructType\\ListSipProfileRes',
            'XSipTrunkSecurityProfile' => '\\CUCM\\StructType\\XSipTrunkSecurityProfile',
            'AddSipTrunkSecurityProfileReq' => '\\CUCM\\StructType\\AddSipTrunkSecurityProfileReq',
            'UpdateSipTrunkSecurityProfileReq' => '\\CUCM\\StructType\\UpdateSipTrunkSecurityProfileReq',
            'GetSipTrunkSecurityProfileReq' => '\\CUCM\\StructType\\GetSipTrunkSecurityProfileReq',
            'GetSipTrunkSecurityProfileRes' => '\\CUCM\\StructType\\GetSipTrunkSecurityProfileRes',
            'ListSipTrunkSecurityProfileReq' => '\\CUCM\\StructType\\ListSipTrunkSecurityProfileReq',
            'ListSipTrunkSecurityProfileRes' => '\\CUCM\\StructType\\ListSipTrunkSecurityProfileRes',
            'XTimePeriod' => '\\CUCM\\StructType\\XTimePeriod',
            'AddTimePeriodReq' => '\\CUCM\\StructType\\AddTimePeriodReq',
            'UpdateTimePeriodReq' => '\\CUCM\\StructType\\UpdateTimePeriodReq',
            'GetTimePeriodReq' => '\\CUCM\\StructType\\GetTimePeriodReq',
            'GetTimePeriodRes' => '\\CUCM\\StructType\\GetTimePeriodRes',
            'ListTimePeriodReq' => '\\CUCM\\StructType\\ListTimePeriodReq',
            'ListTimePeriodRes' => '\\CUCM\\StructType\\ListTimePeriodRes',
            'XTimeSchedule' => '\\CUCM\\StructType\\XTimeSchedule',
            'members' => '\\CUCM\\StructType\\Members',
            'AddTimeScheduleReq' => '\\CUCM\\StructType\\AddTimeScheduleReq',
            'UpdateTimeScheduleReq' => '\\CUCM\\StructType\\UpdateTimeScheduleReq',
            'removeMembers' => '\\CUCM\\StructType\\RemoveMembers',
            'addMembers' => '\\CUCM\\StructType\\AddMembers',
            'GetTimeScheduleReq' => '\\CUCM\\StructType\\GetTimeScheduleReq',
            'GetTimeScheduleRes' => '\\CUCM\\StructType\\GetTimeScheduleRes',
            'ListTimeScheduleReq' => '\\CUCM\\StructType\\ListTimeScheduleReq',
            'ListTimeScheduleRes' => '\\CUCM\\StructType\\ListTimeScheduleRes',
            'XTodAccess' => '\\CUCM\\StructType\\XTodAccess',
            'AddTodAccessReq' => '\\CUCM\\StructType\\AddTodAccessReq',
            'UpdateTodAccessReq' => '\\CUCM\\StructType\\UpdateTodAccessReq',
            'GetTodAccessReq' => '\\CUCM\\StructType\\GetTodAccessReq',
            'GetTodAccessRes' => '\\CUCM\\StructType\\GetTodAccessRes',
            'ListTodAccessReq' => '\\CUCM\\StructType\\ListTodAccessReq',
            'ListTodAccessRes' => '\\CUCM\\StructType\\ListTodAccessRes',
            'XVoiceMailPilot' => '\\CUCM\\StructType\\XVoiceMailPilot',
            'AddVoiceMailPilotReq' => '\\CUCM\\StructType\\AddVoiceMailPilotReq',
            'UpdateVoiceMailPilotReq' => '\\CUCM\\StructType\\UpdateVoiceMailPilotReq',
            'RemoveVoiceMailPilotReq' => '\\CUCM\\StructType\\RemoveVoiceMailPilotReq',
            'GetVoiceMailPilotReq' => '\\CUCM\\StructType\\GetVoiceMailPilotReq',
            'GetVoiceMailPilotRes' => '\\CUCM\\StructType\\GetVoiceMailPilotRes',
            'ListVoiceMailPilotReq' => '\\CUCM\\StructType\\ListVoiceMailPilotReq',
            'ListVoiceMailPilotRes' => '\\CUCM\\StructType\\ListVoiceMailPilotRes',
            'XProcessNode' => '\\CUCM\\StructType\\XProcessNode',
            'AddProcessNodeReq' => '\\CUCM\\StructType\\AddProcessNodeReq',
            'UpdateProcessNodeReq' => '\\CUCM\\StructType\\UpdateProcessNodeReq',
            'GetProcessNodeReq' => '\\CUCM\\StructType\\GetProcessNodeReq',
            'GetProcessNodeRes' => '\\CUCM\\StructType\\GetProcessNodeRes',
            'ListProcessNodeReq' => '\\CUCM\\StructType\\ListProcessNodeReq',
            'ListProcessNodeRes' => '\\CUCM\\StructType\\ListProcessNodeRes',
            'XCallerFilterList' => '\\CUCM\\StructType\\XCallerFilterList',
            'AddCallerFilterListReq' => '\\CUCM\\StructType\\AddCallerFilterListReq',
            'UpdateCallerFilterListReq' => '\\CUCM\\StructType\\UpdateCallerFilterListReq',
            'GetCallerFilterListReq' => '\\CUCM\\StructType\\GetCallerFilterListReq',
            'GetCallerFilterListRes' => '\\CUCM\\StructType\\GetCallerFilterListRes',
            'ListCallerFilterListReq' => '\\CUCM\\StructType\\ListCallerFilterListReq',
            'ListCallerFilterListRes' => '\\CUCM\\StructType\\ListCallerFilterListRes',
            'XRoutePartition' => '\\CUCM\\StructType\\XRoutePartition',
            'AddRoutePartitionReq' => '\\CUCM\\StructType\\AddRoutePartitionReq',
            'UpdateRoutePartitionReq' => '\\CUCM\\StructType\\UpdateRoutePartitionReq',
            'GetRoutePartitionReq' => '\\CUCM\\StructType\\GetRoutePartitionReq',
            'GetRoutePartitionRes' => '\\CUCM\\StructType\\GetRoutePartitionRes',
            'ListRoutePartitionReq' => '\\CUCM\\StructType\\ListRoutePartitionReq',
            'ListRoutePartitionRes' => '\\CUCM\\StructType\\ListRoutePartitionRes',
            'XCss' => '\\CUCM\\StructType\\XCss',
            'AddCssReq' => '\\CUCM\\StructType\\AddCssReq',
            'UpdateCssReq' => '\\CUCM\\StructType\\UpdateCssReq',
            'GetCssReq' => '\\CUCM\\StructType\\GetCssReq',
            'GetCssRes' => '\\CUCM\\StructType\\GetCssRes',
            'ListCssReq' => '\\CUCM\\StructType\\ListCssReq',
            'ListCssRes' => '\\CUCM\\StructType\\ListCssRes',
            'XCallManager' => '\\CUCM\\StructType\\XCallManager',
            'autoRegistration' => '\\CUCM\\StructType\\AutoRegistration',
            'ports' => '\\CUCM\\StructType\\Ports',
            'mgcpPorts' => '\\CUCM\\StructType\\MgcpPorts',
            'sipPorts' => '\\CUCM\\StructType\\SipPorts',
            'AddCallManagerReq' => '\\CUCM\\StructType\\AddCallManagerReq',
            'UpdateCallManagerReq' => '\\CUCM\\StructType\\UpdateCallManagerReq',
            'GetCallManagerReq' => '\\CUCM\\StructType\\GetCallManagerReq',
            'GetCallManagerRes' => '\\CUCM\\StructType\\GetCallManagerRes',
            'ListCallManagerReq' => '\\CUCM\\StructType\\ListCallManagerReq',
            'ListCallManagerRes' => '\\CUCM\\StructType\\ListCallManagerRes',
            'XMediaResourceGroup' => '\\CUCM\\StructType\\XMediaResourceGroup',
            'AddMediaResourceGroupReq' => '\\CUCM\\StructType\\AddMediaResourceGroupReq',
            'UpdateMediaResourceGroupReq' => '\\CUCM\\StructType\\UpdateMediaResourceGroupReq',
            'GetMediaResourceGroupReq' => '\\CUCM\\StructType\\GetMediaResourceGroupReq',
            'GetMediaResourceGroupRes' => '\\CUCM\\StructType\\GetMediaResourceGroupRes',
            'ListMediaResourceGroupReq' => '\\CUCM\\StructType\\ListMediaResourceGroupReq',
            'ListMediaResourceGroupRes' => '\\CUCM\\StructType\\ListMediaResourceGroupRes',
            'XMediaResourceList' => '\\CUCM\\StructType\\XMediaResourceList',
            'AddMediaResourceListReq' => '\\CUCM\\StructType\\AddMediaResourceListReq',
            'UpdateMediaResourceListReq' => '\\CUCM\\StructType\\UpdateMediaResourceListReq',
            'GetMediaResourceListReq' => '\\CUCM\\StructType\\GetMediaResourceListReq',
            'GetMediaResourceListRes' => '\\CUCM\\StructType\\GetMediaResourceListRes',
            'ListMediaResourceListReq' => '\\CUCM\\StructType\\ListMediaResourceListReq',
            'ListMediaResourceListRes' => '\\CUCM\\StructType\\ListMediaResourceListRes',
            'XRegion' => '\\CUCM\\StructType\\XRegion',
            'relatedRegions' => '\\CUCM\\StructType\\RelatedRegions',
            'AddRegionReq' => '\\CUCM\\StructType\\AddRegionReq',
            'UpdateRegionReq' => '\\CUCM\\StructType\\UpdateRegionReq',
            'GetRegionReq' => '\\CUCM\\StructType\\GetRegionReq',
            'GetRegionRes' => '\\CUCM\\StructType\\GetRegionRes',
            'ListRegionReq' => '\\CUCM\\StructType\\ListRegionReq',
            'ListRegionRes' => '\\CUCM\\StructType\\ListRegionRes',
            'XAarGroup' => '\\CUCM\\StructType\\XAarGroup',
            'AddAarGroupReq' => '\\CUCM\\StructType\\AddAarGroupReq',
            'UpdateAarGroupReq' => '\\CUCM\\StructType\\UpdateAarGroupReq',
            'GetAarGroupReq' => '\\CUCM\\StructType\\GetAarGroupReq',
            'GetAarGroupRes' => '\\CUCM\\StructType\\GetAarGroupRes',
            'ListAarGroupReq' => '\\CUCM\\StructType\\ListAarGroupReq',
            'ListAarGroupRes' => '\\CUCM\\StructType\\ListAarGroupRes',
            'XPhysicalLocation' => '\\CUCM\\StructType\\XPhysicalLocation',
            'AddPhysicalLocationReq' => '\\CUCM\\StructType\\AddPhysicalLocationReq',
            'UpdatePhysicalLocationReq' => '\\CUCM\\StructType\\UpdatePhysicalLocationReq',
            'GetPhysicalLocationReq' => '\\CUCM\\StructType\\GetPhysicalLocationReq',
            'GetPhysicalLocationRes' => '\\CUCM\\StructType\\GetPhysicalLocationRes',
            'ListPhysicalLocationReq' => '\\CUCM\\StructType\\ListPhysicalLocationReq',
            'ListPhysicalLocationRes' => '\\CUCM\\StructType\\ListPhysicalLocationRes',
            'XRouteGroup' => '\\CUCM\\StructType\\XRouteGroup',
            'AddRouteGroupReq' => '\\CUCM\\StructType\\AddRouteGroupReq',
            'UpdateRouteGroupReq' => '\\CUCM\\StructType\\UpdateRouteGroupReq',
            'GetRouteGroupReq' => '\\CUCM\\StructType\\GetRouteGroupReq',
            'GetRouteGroupRes' => '\\CUCM\\StructType\\GetRouteGroupRes',
            'ListRouteGroupReq' => '\\CUCM\\StructType\\ListRouteGroupReq',
            'ListRouteGroupRes' => '\\CUCM\\StructType\\ListRouteGroupRes',
            'XDevicePool' => '\\CUCM\\StructType\\XDevicePool',
            'AddDevicePoolReq' => '\\CUCM\\StructType\\AddDevicePoolReq',
            'UpdateDevicePoolReq' => '\\CUCM\\StructType\\UpdateDevicePoolReq',
            'GetDevicePoolReq' => '\\CUCM\\StructType\\GetDevicePoolReq',
            'GetDevicePoolRes' => '\\CUCM\\StructType\\GetDevicePoolRes',
            'ListDevicePoolReq' => '\\CUCM\\StructType\\ListDevicePoolReq',
            'ListDevicePoolRes' => '\\CUCM\\StructType\\ListDevicePoolRes',
            'XDeviceMobilityGroup' => '\\CUCM\\StructType\\XDeviceMobilityGroup',
            'AddDeviceMobilityGroupReq' => '\\CUCM\\StructType\\AddDeviceMobilityGroupReq',
            'UpdateDeviceMobilityGroupReq' => '\\CUCM\\StructType\\UpdateDeviceMobilityGroupReq',
            'GetDeviceMobilityGroupReq' => '\\CUCM\\StructType\\GetDeviceMobilityGroupReq',
            'GetDeviceMobilityGroupRes' => '\\CUCM\\StructType\\GetDeviceMobilityGroupRes',
            'ListDeviceMobilityGroupReq' => '\\CUCM\\StructType\\ListDeviceMobilityGroupReq',
            'ListDeviceMobilityGroupRes' => '\\CUCM\\StructType\\ListDeviceMobilityGroupRes',
            'XLocation' => '\\CUCM\\StructType\\XLocation',
            'relatedLocations' => '\\CUCM\\StructType\\RelatedLocations',
            'AddLocationReq' => '\\CUCM\\StructType\\AddLocationReq',
            'UpdateLocationReq' => '\\CUCM\\StructType\\UpdateLocationReq',
            'GetLocationReq' => '\\CUCM\\StructType\\GetLocationReq',
            'GetLocationRes' => '\\CUCM\\StructType\\GetLocationRes',
            'ListLocationReq' => '\\CUCM\\StructType\\ListLocationReq',
            'ListLocationRes' => '\\CUCM\\StructType\\ListLocationRes',
            'XSoftKeyTemplate' => '\\CUCM\\StructType\\XSoftKeyTemplate',
            'AddSoftKeyTemplateReq' => '\\CUCM\\StructType\\AddSoftKeyTemplateReq',
            'UpdateSoftKeyTemplateReq' => '\\CUCM\\StructType\\UpdateSoftKeyTemplateReq',
            'GetSoftKeyTemplateReq' => '\\CUCM\\StructType\\GetSoftKeyTemplateReq',
            'GetSoftKeyTemplateRes' => '\\CUCM\\StructType\\GetSoftKeyTemplateRes',
            'ListSoftKeyTemplateReq' => '\\CUCM\\StructType\\ListSoftKeyTemplateReq',
            'ListSoftKeyTemplateRes' => '\\CUCM\\StructType\\ListSoftKeyTemplateRes',
            'XTranscoder' => '\\CUCM\\StructType\\XTranscoder',
            'AddTranscoderReq' => '\\CUCM\\StructType\\AddTranscoderReq',
            'UpdateTranscoderReq' => '\\CUCM\\StructType\\UpdateTranscoderReq',
            'GetTranscoderReq' => '\\CUCM\\StructType\\GetTranscoderReq',
            'GetTranscoderRes' => '\\CUCM\\StructType\\GetTranscoderRes',
            'ListTranscoderReq' => '\\CUCM\\StructType\\ListTranscoderReq',
            'ListTranscoderRes' => '\\CUCM\\StructType\\ListTranscoderRes',
            'XCommonDeviceConfig' => '\\CUCM\\StructType\\XCommonDeviceConfig',
            'AddCommonDeviceConfigReq' => '\\CUCM\\StructType\\AddCommonDeviceConfigReq',
            'UpdateCommonDeviceConfigReq' => '\\CUCM\\StructType\\UpdateCommonDeviceConfigReq',
            'GetCommonDeviceConfigReq' => '\\CUCM\\StructType\\GetCommonDeviceConfigReq',
            'GetCommonDeviceConfigRes' => '\\CUCM\\StructType\\GetCommonDeviceConfigRes',
            'ListCommonDeviceConfigReq' => '\\CUCM\\StructType\\ListCommonDeviceConfigReq',
            'ListCommonDeviceConfigRes' => '\\CUCM\\StructType\\ListCommonDeviceConfigRes',
            'XResourcePriorityNamespace' => '\\CUCM\\StructType\\XResourcePriorityNamespace',
            'AddResourcePriorityNamespaceReq' => '\\CUCM\\StructType\\AddResourcePriorityNamespaceReq',
            'UpdateResourcePriorityNamespaceReq' => '\\CUCM\\StructType\\UpdateResourcePriorityNamespaceReq',
            'RemoveResourcePriorityNamespaceReq' => '\\CUCM\\StructType\\RemoveResourcePriorityNamespaceReq',
            'GetResourcePriorityNamespaceReq' => '\\CUCM\\StructType\\GetResourcePriorityNamespaceReq',
            'GetResourcePriorityNamespaceRes' => '\\CUCM\\StructType\\GetResourcePriorityNamespaceRes',
            'ListResourcePriorityNamespaceReq' => '\\CUCM\\StructType\\ListResourcePriorityNamespaceReq',
            'ListResourcePriorityNamespaceRes' => '\\CUCM\\StructType\\ListResourcePriorityNamespaceRes',
            'XResourcePriorityNamespaceList' => '\\CUCM\\StructType\\XResourcePriorityNamespaceList',
            'AddResourcePriorityNamespaceListReq' => '\\CUCM\\StructType\\AddResourcePriorityNamespaceListReq',
            'UpdateResourcePriorityNamespaceListReq' => '\\CUCM\\StructType\\UpdateResourcePriorityNamespaceListReq',
            'GetResourcePriorityNamespaceListReq' => '\\CUCM\\StructType\\GetResourcePriorityNamespaceListReq',
            'GetResourcePriorityNamespaceListRes' => '\\CUCM\\StructType\\GetResourcePriorityNamespaceListRes',
            'ListResourcePriorityNamespaceListReq' => '\\CUCM\\StructType\\ListResourcePriorityNamespaceListReq',
            'ListResourcePriorityNamespaceListRes' => '\\CUCM\\StructType\\ListResourcePriorityNamespaceListRes',
            'XDeviceMobility' => '\\CUCM\\StructType\\XDeviceMobility',
            'AddDeviceMobilityReq' => '\\CUCM\\StructType\\AddDeviceMobilityReq',
            'UpdateDeviceMobilityReq' => '\\CUCM\\StructType\\UpdateDeviceMobilityReq',
            'GetDeviceMobilityReq' => '\\CUCM\\StructType\\GetDeviceMobilityReq',
            'GetDeviceMobilityRes' => '\\CUCM\\StructType\\GetDeviceMobilityRes',
            'ListDeviceMobilityReq' => '\\CUCM\\StructType\\ListDeviceMobilityReq',
            'ListDeviceMobilityRes' => '\\CUCM\\StructType\\ListDeviceMobilityRes',
            'XCmcInfo' => '\\CUCM\\StructType\\XCmcInfo',
            'AddCmcInfoReq' => '\\CUCM\\StructType\\AddCmcInfoReq',
            'UpdateCmcInfoReq' => '\\CUCM\\StructType\\UpdateCmcInfoReq',
            'RemoveCmcInfoReq' => '\\CUCM\\StructType\\RemoveCmcInfoReq',
            'GetCmcInfoReq' => '\\CUCM\\StructType\\GetCmcInfoReq',
            'GetCmcInfoRes' => '\\CUCM\\StructType\\GetCmcInfoRes',
            'ListCmcInfoReq' => '\\CUCM\\StructType\\ListCmcInfoReq',
            'ListCmcInfoRes' => '\\CUCM\\StructType\\ListCmcInfoRes',
            'XCredentialPolicy' => '\\CUCM\\StructType\\XCredentialPolicy',
            'AddCredentialPolicyReq' => '\\CUCM\\StructType\\AddCredentialPolicyReq',
            'UpdateCredentialPolicyReq' => '\\CUCM\\StructType\\UpdateCredentialPolicyReq',
            'GetCredentialPolicyReq' => '\\CUCM\\StructType\\GetCredentialPolicyReq',
            'GetCredentialPolicyRes' => '\\CUCM\\StructType\\GetCredentialPolicyRes',
            'ListCredentialPolicyReq' => '\\CUCM\\StructType\\ListCredentialPolicyReq',
            'ListCredentialPolicyRes' => '\\CUCM\\StructType\\ListCredentialPolicyRes',
            'XFacInfo' => '\\CUCM\\StructType\\XFacInfo',
            'AddFacInfoReq' => '\\CUCM\\StructType\\AddFacInfoReq',
            'UpdateFacInfoReq' => '\\CUCM\\StructType\\UpdateFacInfoReq',
            'GetFacInfoReq' => '\\CUCM\\StructType\\GetFacInfoReq',
            'GetFacInfoRes' => '\\CUCM\\StructType\\GetFacInfoRes',
            'ListFacInfoReq' => '\\CUCM\\StructType\\ListFacInfoReq',
            'ListFacInfoRes' => '\\CUCM\\StructType\\ListFacInfoRes',
            'XHuntList' => '\\CUCM\\StructType\\XHuntList',
            'AddHuntListReq' => '\\CUCM\\StructType\\AddHuntListReq',
            'UpdateHuntListReq' => '\\CUCM\\StructType\\UpdateHuntListReq',
            'GetHuntListReq' => '\\CUCM\\StructType\\GetHuntListReq',
            'GetHuntListRes' => '\\CUCM\\StructType\\GetHuntListRes',
            'ListHuntListReq' => '\\CUCM\\StructType\\ListHuntListReq',
            'ListHuntListRes' => '\\CUCM\\StructType\\ListHuntListRes',
            'XIvrUserLocale' => '\\CUCM\\StructType\\XIvrUserLocale',
            'AddIvrUserLocaleReq' => '\\CUCM\\StructType\\AddIvrUserLocaleReq',
            'UpdateIvrUserLocaleReq' => '\\CUCM\\StructType\\UpdateIvrUserLocaleReq',
            'RemoveIvrUserLocaleReq' => '\\CUCM\\StructType\\RemoveIvrUserLocaleReq',
            'GetIvrUserLocaleReq' => '\\CUCM\\StructType\\GetIvrUserLocaleReq',
            'GetIvrUserLocaleRes' => '\\CUCM\\StructType\\GetIvrUserLocaleRes',
            'ListIvrUserLocaleReq' => '\\CUCM\\StructType\\ListIvrUserLocaleReq',
            'ListIvrUserLocaleRes' => '\\CUCM\\StructType\\ListIvrUserLocaleRes',
            'XLineGroup' => '\\CUCM\\StructType\\XLineGroup',
            'AddLineGroupReq' => '\\CUCM\\StructType\\AddLineGroupReq',
            'UpdateLineGroupReq' => '\\CUCM\\StructType\\UpdateLineGroupReq',
            'GetLineGroupReq' => '\\CUCM\\StructType\\GetLineGroupReq',
            'GetLineGroupRes' => '\\CUCM\\StructType\\GetLineGroupRes',
            'ListLineGroupReq' => '\\CUCM\\StructType\\ListLineGroupReq',
            'ListLineGroupRes' => '\\CUCM\\StructType\\ListLineGroupRes',
            'XRecordingProfile' => '\\CUCM\\StructType\\XRecordingProfile',
            'AddRecordingProfileReq' => '\\CUCM\\StructType\\AddRecordingProfileReq',
            'UpdateRecordingProfileReq' => '\\CUCM\\StructType\\UpdateRecordingProfileReq',
            'GetRecordingProfileReq' => '\\CUCM\\StructType\\GetRecordingProfileReq',
            'GetRecordingProfileRes' => '\\CUCM\\StructType\\GetRecordingProfileRes',
            'ListRecordingProfileReq' => '\\CUCM\\StructType\\ListRecordingProfileReq',
            'ListRecordingProfileRes' => '\\CUCM\\StructType\\ListRecordingProfileRes',
            'XRouteFilter' => '\\CUCM\\StructType\\XRouteFilter',
            'AddRouteFilterReq' => '\\CUCM\\StructType\\AddRouteFilterReq',
            'UpdateRouteFilterReq' => '\\CUCM\\StructType\\UpdateRouteFilterReq',
            'GetRouteFilterReq' => '\\CUCM\\StructType\\GetRouteFilterReq',
            'GetRouteFilterRes' => '\\CUCM\\StructType\\GetRouteFilterRes',
            'ListRouteFilterReq' => '\\CUCM\\StructType\\ListRouteFilterReq',
            'ListRouteFilterRes' => '\\CUCM\\StructType\\ListRouteFilterRes',
            'XCallManagerGroup' => '\\CUCM\\StructType\\XCallManagerGroup',
            'AddCallManagerGroupReq' => '\\CUCM\\StructType\\AddCallManagerGroupReq',
            'UpdateCallManagerGroupReq' => '\\CUCM\\StructType\\UpdateCallManagerGroupReq',
            'GetCallManagerGroupReq' => '\\CUCM\\StructType\\GetCallManagerGroupReq',
            'GetCallManagerGroupRes' => '\\CUCM\\StructType\\GetCallManagerGroupRes',
            'ListCallManagerGroupReq' => '\\CUCM\\StructType\\ListCallManagerGroupReq',
            'ListCallManagerGroupRes' => '\\CUCM\\StructType\\ListCallManagerGroupRes',
            'XUserGroup' => '\\CUCM\\StructType\\XUserGroup',
            'userRoles' => '\\CUCM\\StructType\\UserRoles',
            'AddUserGroupReq' => '\\CUCM\\StructType\\AddUserGroupReq',
            'UpdateUserGroupReq' => '\\CUCM\\StructType\\UpdateUserGroupReq',
            'removeUserRoles' => '\\CUCM\\StructType\\RemoveUserRoles',
            'addUserRoles' => '\\CUCM\\StructType\\AddUserRoles',
            'GetUserGroupReq' => '\\CUCM\\StructType\\GetUserGroupReq',
            'GetUserGroupRes' => '\\CUCM\\StructType\\GetUserGroupRes',
            'ListUserGroupReq' => '\\CUCM\\StructType\\ListUserGroupReq',
            'ListUserGroupRes' => '\\CUCM\\StructType\\ListUserGroupRes',
            'XDialPlan' => '\\CUCM\\StructType\\XDialPlan',
            'AddDialPlanReq' => '\\CUCM\\StructType\\AddDialPlanReq',
            'GetDialPlanReq' => '\\CUCM\\StructType\\GetDialPlanReq',
            'GetDialPlanRes' => '\\CUCM\\StructType\\GetDialPlanRes',
            'ListDialPlanReq' => '\\CUCM\\StructType\\ListDialPlanReq',
            'ListDialPlanRes' => '\\CUCM\\StructType\\ListDialPlanRes',
            'XDialPlanTag' => '\\CUCM\\StructType\\XDialPlanTag',
            'AddDialPlanTagReq' => '\\CUCM\\StructType\\AddDialPlanTagReq',
            'GetDialPlanTagReq' => '\\CUCM\\StructType\\GetDialPlanTagReq',
            'GetDialPlanTagRes' => '\\CUCM\\StructType\\GetDialPlanTagRes',
            'ListDialPlanTagReq' => '\\CUCM\\StructType\\ListDialPlanTagReq',
            'ListDialPlanTagRes' => '\\CUCM\\StructType\\ListDialPlanTagRes',
            'XDdi' => '\\CUCM\\StructType\\XDdi',
            'AddDdiReq' => '\\CUCM\\StructType\\AddDdiReq',
            'GetDdiReq' => '\\CUCM\\StructType\\GetDdiReq',
            'GetDdiRes' => '\\CUCM\\StructType\\GetDdiRes',
            'ListDdiReq' => '\\CUCM\\StructType\\ListDdiReq',
            'ListDdiRes' => '\\CUCM\\StructType\\ListDdiRes',
            'XMobileSmartClientProfile' => '\\CUCM\\StructType\\XMobileSmartClientProfile',
            'AddMobileSmartClientProfileReq' => '\\CUCM\\StructType\\AddMobileSmartClientProfileReq',
            'GetMobileSmartClientProfileReq' => '\\CUCM\\StructType\\GetMobileSmartClientProfileReq',
            'GetMobileSmartClientProfileRes' => '\\CUCM\\StructType\\GetMobileSmartClientProfileRes',
            'ListMobileSmartClientProfileReq' => '\\CUCM\\StructType\\ListMobileSmartClientProfileReq',
            'ListMobileSmartClientProfileRes' => '\\CUCM\\StructType\\ListMobileSmartClientProfileRes',
            'XProcessNodeService' => '\\CUCM\\StructType\\XProcessNodeService',
            'AddProcessNodeServiceReq' => '\\CUCM\\StructType\\AddProcessNodeServiceReq',
            'UpdateProcessNodeServiceReq' => '\\CUCM\\StructType\\UpdateProcessNodeServiceReq',
            'GetProcessNodeServiceReq' => '\\CUCM\\StructType\\GetProcessNodeServiceReq',
            'GetProcessNodeServiceRes' => '\\CUCM\\StructType\\GetProcessNodeServiceRes',
            'ListProcessNodeServiceReq' => '\\CUCM\\StructType\\ListProcessNodeServiceReq',
            'ListProcessNodeServiceRes' => '\\CUCM\\StructType\\ListProcessNodeServiceRes',
            'XMohAudioSource' => '\\CUCM\\StructType\\XMohAudioSource',
            'AddMohAudioSourceReq' => '\\CUCM\\StructType\\AddMohAudioSourceReq',
            'UpdateMohAudioSourceReq' => '\\CUCM\\StructType\\UpdateMohAudioSourceReq',
            'RemoveMohAudioSourceReq' => '\\CUCM\\StructType\\RemoveMohAudioSourceReq',
            'GetMohAudioSourceReq' => '\\CUCM\\StructType\\GetMohAudioSourceReq',
            'GetMohAudioSourceRes' => '\\CUCM\\StructType\\GetMohAudioSourceRes',
            'ListMohAudioSourceReq' => '\\CUCM\\StructType\\ListMohAudioSourceReq',
            'ListMohAudioSourceRes' => '\\CUCM\\StructType\\ListMohAudioSourceRes',
            'XDhcpServer' => '\\CUCM\\StructType\\XDhcpServer',
            'AddDhcpServerReq' => '\\CUCM\\StructType\\AddDhcpServerReq',
            'UpdateDhcpServerReq' => '\\CUCM\\StructType\\UpdateDhcpServerReq',
            'RemoveDhcpServerReq' => '\\CUCM\\StructType\\RemoveDhcpServerReq',
            'GetDhcpServerReq' => '\\CUCM\\StructType\\GetDhcpServerReq',
            'GetDhcpServerRes' => '\\CUCM\\StructType\\GetDhcpServerRes',
            'ListDhcpServerReq' => '\\CUCM\\StructType\\ListDhcpServerReq',
            'ListDhcpServerRes' => '\\CUCM\\StructType\\ListDhcpServerRes',
            'XDhcpSubnet' => '\\CUCM\\StructType\\XDhcpSubnet',
            'AddDhcpSubnetReq' => '\\CUCM\\StructType\\AddDhcpSubnetReq',
            'UpdateDhcpSubnetReq' => '\\CUCM\\StructType\\UpdateDhcpSubnetReq',
            'RemoveDhcpSubnetReq' => '\\CUCM\\StructType\\RemoveDhcpSubnetReq',
            'GetDhcpSubnetReq' => '\\CUCM\\StructType\\GetDhcpSubnetReq',
            'GetDhcpSubnetRes' => '\\CUCM\\StructType\\GetDhcpSubnetRes',
            'ListDhcpSubnetReq' => '\\CUCM\\StructType\\ListDhcpSubnetReq',
            'ListDhcpSubnetRes' => '\\CUCM\\StructType\\ListDhcpSubnetRes',
            'XCallPark' => '\\CUCM\\StructType\\XCallPark',
            'AddCallParkReq' => '\\CUCM\\StructType\\AddCallParkReq',
            'UpdateCallParkReq' => '\\CUCM\\StructType\\UpdateCallParkReq',
            'RemoveCallParkReq' => '\\CUCM\\StructType\\RemoveCallParkReq',
            'GetCallParkReq' => '\\CUCM\\StructType\\GetCallParkReq',
            'GetCallParkRes' => '\\CUCM\\StructType\\GetCallParkRes',
            'ListCallParkReq' => '\\CUCM\\StructType\\ListCallParkReq',
            'ListCallParkRes' => '\\CUCM\\StructType\\ListCallParkRes',
            'XDirectedCallPark' => '\\CUCM\\StructType\\XDirectedCallPark',
            'AddDirectedCallParkReq' => '\\CUCM\\StructType\\AddDirectedCallParkReq',
            'UpdateDirectedCallParkReq' => '\\CUCM\\StructType\\UpdateDirectedCallParkReq',
            'RemoveDirectedCallParkReq' => '\\CUCM\\StructType\\RemoveDirectedCallParkReq',
            'GetDirectedCallParkReq' => '\\CUCM\\StructType\\GetDirectedCallParkReq',
            'GetDirectedCallParkRes' => '\\CUCM\\StructType\\GetDirectedCallParkRes',
            'ListDirectedCallParkReq' => '\\CUCM\\StructType\\ListDirectedCallParkReq',
            'ListDirectedCallParkRes' => '\\CUCM\\StructType\\ListDirectedCallParkRes',
            'XMeetMe' => '\\CUCM\\StructType\\XMeetMe',
            'AddMeetMeReq' => '\\CUCM\\StructType\\AddMeetMeReq',
            'UpdateMeetMeReq' => '\\CUCM\\StructType\\UpdateMeetMeReq',
            'RemoveMeetMeReq' => '\\CUCM\\StructType\\RemoveMeetMeReq',
            'GetMeetMeReq' => '\\CUCM\\StructType\\GetMeetMeReq',
            'GetMeetMeRes' => '\\CUCM\\StructType\\GetMeetMeRes',
            'ListMeetMeReq' => '\\CUCM\\StructType\\ListMeetMeReq',
            'ListMeetMeRes' => '\\CUCM\\StructType\\ListMeetMeRes',
            'XMobileVoiceAccess' => '\\CUCM\\StructType\\XMobileVoiceAccess',
            'locales' => '\\CUCM\\StructType\\Locales',
            'AddMobileVoiceAccessReq' => '\\CUCM\\StructType\\AddMobileVoiceAccessReq',
            'UpdateMobileVoiceAccessReq' => '\\CUCM\\StructType\\UpdateMobileVoiceAccessReq',
            'removeLocales' => '\\CUCM\\StructType\\RemoveLocales',
            'addLocales' => '\\CUCM\\StructType\\AddLocales',
            'RemoveMobileVoiceAccessReq' => '\\CUCM\\StructType\\RemoveMobileVoiceAccessReq',
            'GetMobileVoiceAccessReq' => '\\CUCM\\StructType\\GetMobileVoiceAccessReq',
            'GetMobileVoiceAccessRes' => '\\CUCM\\StructType\\GetMobileVoiceAccessRes',
            'XRouteList' => '\\CUCM\\StructType\\XRouteList',
            'AddRouteListReq' => '\\CUCM\\StructType\\AddRouteListReq',
            'UpdateRouteListReq' => '\\CUCM\\StructType\\UpdateRouteListReq',
            'GetRouteListReq' => '\\CUCM\\StructType\\GetRouteListReq',
            'GetRouteListRes' => '\\CUCM\\StructType\\GetRouteListRes',
            'ListRouteListReq' => '\\CUCM\\StructType\\ListRouteListReq',
            'ListRouteListRes' => '\\CUCM\\StructType\\ListRouteListRes',
            'XUser' => '\\CUCM\\StructType\\XUser',
            'associatedDevices' => '\\CUCM\\StructType\\AssociatedDevices',
            'primaryExtension' => '\\CUCM\\StructType\\PrimaryExtension',
            'associatedGroups' => '\\CUCM\\StructType\\AssociatedGroups',
            'userGroup' => '\\CUCM\\StructType\\UserGroup',
            'phoneProfiles' => '\\CUCM\\StructType\\PhoneProfiles',
            'passwordCredentials' => '\\CUCM\\StructType\\PasswordCredentials',
            'pinCredentials' => '\\CUCM\\StructType\\PinCredentials',
            'ctiControlledDeviceProfiles' => '\\CUCM\\StructType\\CtiControlledDeviceProfiles',
            'AddUserReq' => '\\CUCM\\StructType\\AddUserReq',
            'UpdateUserReq' => '\\CUCM\\StructType\\UpdateUserReq',
            'RemoveUserReq' => '\\CUCM\\StructType\\RemoveUserReq',
            'GetUserReq' => '\\CUCM\\StructType\\GetUserReq',
            'GetUserRes' => '\\CUCM\\StructType\\GetUserRes',
            'ListUserReq' => '\\CUCM\\StructType\\ListUserReq',
            'ListUserRes' => '\\CUCM\\StructType\\ListUserRes',
            'XLicenseCapabilities' => '\\CUCM\\StructType\\XLicenseCapabilities',
            'AddLicenseCapabilitiesReq' => '\\CUCM\\StructType\\AddLicenseCapabilitiesReq',
            'UpdateLicenseCapabilitiesReq' => '\\CUCM\\StructType\\UpdateLicenseCapabilitiesReq',
            'GetLicenseCapabilitiesReq' => '\\CUCM\\StructType\\GetLicenseCapabilitiesReq',
            'GetLicenseCapabilitiesRes' => '\\CUCM\\StructType\\GetLicenseCapabilitiesRes',
            'ListLicenseCapabilitiesReq' => '\\CUCM\\StructType\\ListLicenseCapabilitiesReq',
            'ListLicenseCapabilitiesRes' => '\\CUCM\\StructType\\ListLicenseCapabilitiesRes',
            'XAppUser' => '\\CUCM\\StructType\\XAppUser',
            'AddAppUserReq' => '\\CUCM\\StructType\\AddAppUserReq',
            'UpdateAppUserReq' => '\\CUCM\\StructType\\UpdateAppUserReq',
            'RemoveAppUserReq' => '\\CUCM\\StructType\\RemoveAppUserReq',
            'GetAppUserReq' => '\\CUCM\\StructType\\GetAppUserReq',
            'GetAppUserRes' => '\\CUCM\\StructType\\GetAppUserRes',
            'ListAppUserReq' => '\\CUCM\\StructType\\ListAppUserReq',
            'ListAppUserRes' => '\\CUCM\\StructType\\ListAppUserRes',
            'XSipRealm' => '\\CUCM\\StructType\\XSipRealm',
            'AddSipRealmReq' => '\\CUCM\\StructType\\AddSipRealmReq',
            'UpdateSipRealmReq' => '\\CUCM\\StructType\\UpdateSipRealmReq',
            'RemoveSipRealmReq' => '\\CUCM\\StructType\\RemoveSipRealmReq',
            'GetSipRealmReq' => '\\CUCM\\StructType\\GetSipRealmReq',
            'GetSipRealmRes' => '\\CUCM\\StructType\\GetSipRealmRes',
            'ListSipRealmReq' => '\\CUCM\\StructType\\ListSipRealmReq',
            'ListSipRealmRes' => '\\CUCM\\StructType\\ListSipRealmRes',
            'XPhoneNtp' => '\\CUCM\\StructType\\XPhoneNtp',
            'AddPhoneNtpReq' => '\\CUCM\\StructType\\AddPhoneNtpReq',
            'UpdatePhoneNtpReq' => '\\CUCM\\StructType\\UpdatePhoneNtpReq',
            'RemovePhoneNtpReq' => '\\CUCM\\StructType\\RemovePhoneNtpReq',
            'GetPhoneNtpReq' => '\\CUCM\\StructType\\GetPhoneNtpReq',
            'GetPhoneNtpRes' => '\\CUCM\\StructType\\GetPhoneNtpRes',
            'ListPhoneNtpReq' => '\\CUCM\\StructType\\ListPhoneNtpReq',
            'ListPhoneNtpRes' => '\\CUCM\\StructType\\ListPhoneNtpRes',
            'XDateTimeGroup' => '\\CUCM\\StructType\\XDateTimeGroup',
            'phoneNtpReferences' => '\\CUCM\\StructType\\PhoneNtpReferences',
            'AddDateTimeGroupReq' => '\\CUCM\\StructType\\AddDateTimeGroupReq',
            'UpdateDateTimeGroupReq' => '\\CUCM\\StructType\\UpdateDateTimeGroupReq',
            'removePhoneNtpReferences' => '\\CUCM\\StructType\\RemovePhoneNtpReferences',
            'addPhoneNtpReferences' => '\\CUCM\\StructType\\AddPhoneNtpReferences',
            'GetDateTimeGroupReq' => '\\CUCM\\StructType\\GetDateTimeGroupReq',
            'GetDateTimeGroupRes' => '\\CUCM\\StructType\\GetDateTimeGroupRes',
            'ListDateTimeGroupReq' => '\\CUCM\\StructType\\ListDateTimeGroupReq',
            'ListDateTimeGroupRes' => '\\CUCM\\StructType\\ListDateTimeGroupRes',
            'XPresenceGroup' => '\\CUCM\\StructType\\XPresenceGroup',
            'presenceGroups' => '\\CUCM\\StructType\\PresenceGroups',
            'AddPresenceGroupReq' => '\\CUCM\\StructType\\AddPresenceGroupReq',
            'UpdatePresenceGroupReq' => '\\CUCM\\StructType\\UpdatePresenceGroupReq',
            'GetPresenceGroupReq' => '\\CUCM\\StructType\\GetPresenceGroupReq',
            'GetPresenceGroupRes' => '\\CUCM\\StructType\\GetPresenceGroupRes',
            'ListPresenceGroupReq' => '\\CUCM\\StructType\\ListPresenceGroupReq',
            'ListPresenceGroupRes' => '\\CUCM\\StructType\\ListPresenceGroupRes',
            'XGeoLocation' => '\\CUCM\\StructType\\XGeoLocation',
            'AddGeoLocationReq' => '\\CUCM\\StructType\\AddGeoLocationReq',
            'UpdateGeoLocationReq' => '\\CUCM\\StructType\\UpdateGeoLocationReq',
            'GetGeoLocationReq' => '\\CUCM\\StructType\\GetGeoLocationReq',
            'GetGeoLocationRes' => '\\CUCM\\StructType\\GetGeoLocationRes',
            'ListGeoLocationReq' => '\\CUCM\\StructType\\ListGeoLocationReq',
            'ListGeoLocationRes' => '\\CUCM\\StructType\\ListGeoLocationRes',
            'XSrst' => '\\CUCM\\StructType\\XSrst',
            'AddSrstReq' => '\\CUCM\\StructType\\AddSrstReq',
            'UpdateSrstReq' => '\\CUCM\\StructType\\UpdateSrstReq',
            'GetSrstReq' => '\\CUCM\\StructType\\GetSrstReq',
            'GetSrstRes' => '\\CUCM\\StructType\\GetSrstRes',
            'ListSrstReq' => '\\CUCM\\StructType\\ListSrstReq',
            'ListSrstRes' => '\\CUCM\\StructType\\ListSrstRes',
            'XMlppDomain' => '\\CUCM\\StructType\\XMlppDomain',
            'AddMlppDomainReq' => '\\CUCM\\StructType\\AddMlppDomainReq',
            'UpdateMlppDomainReq' => '\\CUCM\\StructType\\UpdateMlppDomainReq',
            'RemoveMlppDomainReq' => '\\CUCM\\StructType\\RemoveMlppDomainReq',
            'GetMlppDomainReq' => '\\CUCM\\StructType\\GetMlppDomainReq',
            'GetMlppDomainRes' => '\\CUCM\\StructType\\GetMlppDomainRes',
            'ListMlppDomainReq' => '\\CUCM\\StructType\\ListMlppDomainReq',
            'ListMlppDomainRes' => '\\CUCM\\StructType\\ListMlppDomainRes',
            'XCumaServerSecurityProfile' => '\\CUCM\\StructType\\XCumaServerSecurityProfile',
            'AddCumaServerSecurityProfileReq' => '\\CUCM\\StructType\\AddCumaServerSecurityProfileReq',
            'UpdateCumaServerSecurityProfileReq' => '\\CUCM\\StructType\\UpdateCumaServerSecurityProfileReq',
            'GetCumaServerSecurityProfileReq' => '\\CUCM\\StructType\\GetCumaServerSecurityProfileReq',
            'GetCumaServerSecurityProfileRes' => '\\CUCM\\StructType\\GetCumaServerSecurityProfileRes',
            'ListCumaServerSecurityProfileReq' => '\\CUCM\\StructType\\ListCumaServerSecurityProfileReq',
            'ListCumaServerSecurityProfileRes' => '\\CUCM\\StructType\\ListCumaServerSecurityProfileRes',
            'XApplicationServer' => '\\CUCM\\StructType\\XApplicationServer',
            'appUsers' => '\\CUCM\\StructType\\AppUsers',
            'selectedAppUser' => '\\CUCM\\StructType\\SelectedAppUser',
            'endUsers' => '\\CUCM\\StructType\\EndUsers',
            'selectedEndUser' => '\\CUCM\\StructType\\SelectedEndUser',
            'AddApplicationServerReq' => '\\CUCM\\StructType\\AddApplicationServerReq',
            'UpdateApplicationServerReq' => '\\CUCM\\StructType\\UpdateApplicationServerReq',
            'removeAppUsers' => '\\CUCM\\StructType\\RemoveAppUsers',
            'addAppUsers' => '\\CUCM\\StructType\\AddAppUsers',
            'removeEndUsers' => '\\CUCM\\StructType\\RemoveEndUsers',
            'addEndUsers' => '\\CUCM\\StructType\\AddEndUsers',
            'RemoveApplicationServerReq' => '\\CUCM\\StructType\\RemoveApplicationServerReq',
            'GetApplicationServerReq' => '\\CUCM\\StructType\\GetApplicationServerReq',
            'GetApplicationServerRes' => '\\CUCM\\StructType\\GetApplicationServerRes',
            'ListApplicationServerReq' => '\\CUCM\\StructType\\ListApplicationServerReq',
            'ListApplicationServerRes' => '\\CUCM\\StructType\\ListApplicationServerRes',
            'XApplicationUserCapfProfile' => '\\CUCM\\StructType\\XApplicationUserCapfProfile',
            'AddApplicationUserCapfProfileReq' => '\\CUCM\\StructType\\AddApplicationUserCapfProfileReq',
            'UpdateApplicationUserCapfProfileReq' => '\\CUCM\\StructType\\UpdateApplicationUserCapfProfileReq',
            'RemoveApplicationUserCapfProfileReq' => '\\CUCM\\StructType\\RemoveApplicationUserCapfProfileReq',
            'GetApplicationUserCapfProfileReq' => '\\CUCM\\StructType\\GetApplicationUserCapfProfileReq',
            'GetApplicationUserCapfProfileRes' => '\\CUCM\\StructType\\GetApplicationUserCapfProfileRes',
            'ListApplicationUserCapfProfileReq' => '\\CUCM\\StructType\\ListApplicationUserCapfProfileReq',
            'ListApplicationUserCapfProfileRes' => '\\CUCM\\StructType\\ListApplicationUserCapfProfileRes',
            'XEndUserCapfProfile' => '\\CUCM\\StructType\\XEndUserCapfProfile',
            'AddEndUserCapfProfileReq' => '\\CUCM\\StructType\\AddEndUserCapfProfileReq',
            'UpdateEndUserCapfProfileReq' => '\\CUCM\\StructType\\UpdateEndUserCapfProfileReq',
            'RemoveEndUserCapfProfileReq' => '\\CUCM\\StructType\\RemoveEndUserCapfProfileReq',
            'GetEndUserCapfProfileReq' => '\\CUCM\\StructType\\GetEndUserCapfProfileReq',
            'GetEndUserCapfProfileRes' => '\\CUCM\\StructType\\GetEndUserCapfProfileRes',
            'ListEndUserCapfProfileReq' => '\\CUCM\\StructType\\ListEndUserCapfProfileReq',
            'ListEndUserCapfProfileRes' => '\\CUCM\\StructType\\ListEndUserCapfProfileRes',
            'XServiceParameter' => '\\CUCM\\StructType\\XServiceParameter',
            'AddServiceParameterReq' => '\\CUCM\\StructType\\AddServiceParameterReq',
            'UpdateServiceParameterReq' => '\\CUCM\\StructType\\UpdateServiceParameterReq',
            'GetServiceParameterReq' => '\\CUCM\\StructType\\GetServiceParameterReq',
            'GetServiceParameterRes' => '\\CUCM\\StructType\\GetServiceParameterRes',
            'XUserPhoneAssociation' => '\\CUCM\\StructType\\XUserPhoneAssociation',
            'AddUserPhoneAssociationReq' => '\\CUCM\\StructType\\AddUserPhoneAssociationReq',
            'XGeoLocationFilter' => '\\CUCM\\StructType\\XGeoLocationFilter',
            'AddGeoLocationFilterReq' => '\\CUCM\\StructType\\AddGeoLocationFilterReq',
            'UpdateGeoLocationFilterReq' => '\\CUCM\\StructType\\UpdateGeoLocationFilterReq',
            'GetGeoLocationFilterReq' => '\\CUCM\\StructType\\GetGeoLocationFilterReq',
            'GetGeoLocationFilterRes' => '\\CUCM\\StructType\\GetGeoLocationFilterRes',
            'ListGeoLocationFilterReq' => '\\CUCM\\StructType\\ListGeoLocationFilterReq',
            'ListGeoLocationFilterRes' => '\\CUCM\\StructType\\ListGeoLocationFilterRes',
            'XVoiceMailProfile' => '\\CUCM\\StructType\\XVoiceMailProfile',
            'AddVoiceMailProfileReq' => '\\CUCM\\StructType\\AddVoiceMailProfileReq',
            'UpdateVoiceMailProfileReq' => '\\CUCM\\StructType\\UpdateVoiceMailProfileReq',
            'GetVoiceMailProfileReq' => '\\CUCM\\StructType\\GetVoiceMailProfileReq',
            'GetVoiceMailProfileRes' => '\\CUCM\\StructType\\GetVoiceMailProfileRes',
            'ListVoiceMailProfileReq' => '\\CUCM\\StructType\\ListVoiceMailProfileReq',
            'ListVoiceMailProfileRes' => '\\CUCM\\StructType\\ListVoiceMailProfileRes',
            'XVoiceMailPort' => '\\CUCM\\StructType\\XVoiceMailPort',
            'AddVoiceMailPortReq' => '\\CUCM\\StructType\\AddVoiceMailPortReq',
            'UpdateVoiceMailPortReq' => '\\CUCM\\StructType\\UpdateVoiceMailPortReq',
            'GetVoiceMailPortReq' => '\\CUCM\\StructType\\GetVoiceMailPortReq',
            'GetVoiceMailPortRes' => '\\CUCM\\StructType\\GetVoiceMailPortRes',
            'ListVoiceMailPortReq' => '\\CUCM\\StructType\\ListVoiceMailPortReq',
            'ListVoiceMailPortRes' => '\\CUCM\\StructType\\ListVoiceMailPortRes',
            'XGatekeeper' => '\\CUCM\\StructType\\XGatekeeper',
            'AddGatekeeperReq' => '\\CUCM\\StructType\\AddGatekeeperReq',
            'UpdateGatekeeperReq' => '\\CUCM\\StructType\\UpdateGatekeeperReq',
            'GetGatekeeperReq' => '\\CUCM\\StructType\\GetGatekeeperReq',
            'GetGatekeeperRes' => '\\CUCM\\StructType\\GetGatekeeperRes',
            'ListGatekeeperReq' => '\\CUCM\\StructType\\ListGatekeeperReq',
            'ListGatekeeperRes' => '\\CUCM\\StructType\\ListGatekeeperRes',
            'XPhoneButtonTemplate' => '\\CUCM\\StructType\\XPhoneButtonTemplate',
            'buttons' => '\\CUCM\\StructType\\Buttons',
            'AddPhoneButtonTemplateReq' => '\\CUCM\\StructType\\AddPhoneButtonTemplateReq',
            'UpdatePhoneButtonTemplateReq' => '\\CUCM\\StructType\\UpdatePhoneButtonTemplateReq',
            'GetPhoneButtonTemplateReq' => '\\CUCM\\StructType\\GetPhoneButtonTemplateReq',
            'GetPhoneButtonTemplateRes' => '\\CUCM\\StructType\\GetPhoneButtonTemplateRes',
            'ListPhoneButtonTemplateReq' => '\\CUCM\\StructType\\ListPhoneButtonTemplateReq',
            'ListPhoneButtonTemplateRes' => '\\CUCM\\StructType\\ListPhoneButtonTemplateRes',
            'XCommonPhoneConfig' => '\\CUCM\\StructType\\XCommonPhoneConfig',
            'AddCommonPhoneConfigReq' => '\\CUCM\\StructType\\AddCommonPhoneConfigReq',
            'UpdateCommonPhoneConfigReq' => '\\CUCM\\StructType\\UpdateCommonPhoneConfigReq',
            'GetCommonPhoneConfigReq' => '\\CUCM\\StructType\\GetCommonPhoneConfigReq',
            'GetCommonPhoneConfigRes' => '\\CUCM\\StructType\\GetCommonPhoneConfigRes',
            'ListCommonPhoneConfigReq' => '\\CUCM\\StructType\\ListCommonPhoneConfigReq',
            'ListCommonPhoneConfigRes' => '\\CUCM\\StructType\\ListCommonPhoneConfigRes',
            'XMessageWaiting' => '\\CUCM\\StructType\\XMessageWaiting',
            'AddMessageWaitingReq' => '\\CUCM\\StructType\\AddMessageWaitingReq',
            'UpdateMessageWaitingReq' => '\\CUCM\\StructType\\UpdateMessageWaitingReq',
            'RemoveMessageWaitingReq' => '\\CUCM\\StructType\\RemoveMessageWaitingReq',
            'GetMessageWaitingReq' => '\\CUCM\\StructType\\GetMessageWaitingReq',
            'GetMessageWaitingRes' => '\\CUCM\\StructType\\GetMessageWaitingRes',
            'ListMessageWaitingReq' => '\\CUCM\\StructType\\ListMessageWaitingReq',
            'ListMessageWaitingRes' => '\\CUCM\\StructType\\ListMessageWaitingRes',
            'XIpPhoneServices' => '\\CUCM\\StructType\\XIpPhoneServices',
            'parameters' => '\\CUCM\\StructType\\Parameters',
            'AddIpPhoneServicesReq' => '\\CUCM\\StructType\\AddIpPhoneServicesReq',
            'UpdateIpPhoneServicesReq' => '\\CUCM\\StructType\\UpdateIpPhoneServicesReq',
            'removeParameters' => '\\CUCM\\StructType\\RemoveParameters',
            'addParameters' => '\\CUCM\\StructType\\AddParameters',
            'RemoveIpPhoneServicesReq' => '\\CUCM\\StructType\\RemoveIpPhoneServicesReq',
            'GetIpPhoneServicesReq' => '\\CUCM\\StructType\\GetIpPhoneServicesReq',
            'GetIpPhoneServicesRes' => '\\CUCM\\StructType\\GetIpPhoneServicesRes',
            'ListIpPhoneServicesReq' => '\\CUCM\\StructType\\ListIpPhoneServicesReq',
            'ListIpPhoneServicesRes' => '\\CUCM\\StructType\\ListIpPhoneServicesRes',
            'XCtiRoutePoint' => '\\CUCM\\StructType\\XCtiRoutePoint',
            'lines' => '\\CUCM\\StructType\\Lines',
            'AddCtiRoutePointReq' => '\\CUCM\\StructType\\AddCtiRoutePointReq',
            'UpdateCtiRoutePointReq' => '\\CUCM\\StructType\\UpdateCtiRoutePointReq',
            'GetCtiRoutePointReq' => '\\CUCM\\StructType\\GetCtiRoutePointReq',
            'GetCtiRoutePointRes' => '\\CUCM\\StructType\\GetCtiRoutePointRes',
            'ListCtiRoutePointReq' => '\\CUCM\\StructType\\ListCtiRoutePointReq',
            'ListCtiRoutePointRes' => '\\CUCM\\StructType\\ListCtiRoutePointRes',
            'XTransPattern' => '\\CUCM\\StructType\\XTransPattern',
            'AddTransPatternReq' => '\\CUCM\\StructType\\AddTransPatternReq',
            'UpdateTransPatternReq' => '\\CUCM\\StructType\\UpdateTransPatternReq',
            'RemoveTransPatternReq' => '\\CUCM\\StructType\\RemoveTransPatternReq',
            'GetTransPatternReq' => '\\CUCM\\StructType\\GetTransPatternReq',
            'GetTransPatternRes' => '\\CUCM\\StructType\\GetTransPatternRes',
            'ListTransPatternReq' => '\\CUCM\\StructType\\ListTransPatternReq',
            'ListTransPatternRes' => '\\CUCM\\StructType\\ListTransPatternRes',
            'XCallingPartyTransformationPattern' => '\\CUCM\\StructType\\XCallingPartyTransformationPattern',
            'AddCallingPartyTransformationPatternReq' => '\\CUCM\\StructType\\AddCallingPartyTransformationPatternReq',
            'UpdateCallingPartyTransformationPatternReq' => '\\CUCM\\StructType\\UpdateCallingPartyTransformationPatternReq',
            'RemoveCallingPartyTransformationPatternReq' => '\\CUCM\\StructType\\RemoveCallingPartyTransformationPatternReq',
            'GetCallingPartyTransformationPatternReq' => '\\CUCM\\StructType\\GetCallingPartyTransformationPatternReq',
            'GetCallingPartyTransformationPatternRes' => '\\CUCM\\StructType\\GetCallingPartyTransformationPatternRes',
            'ListCallingPartyTransformationPatternReq' => '\\CUCM\\StructType\\ListCallingPartyTransformationPatternReq',
            'ListCallingPartyTransformationPatternRes' => '\\CUCM\\StructType\\ListCallingPartyTransformationPatternRes',
            'XSipRoutePattern' => '\\CUCM\\StructType\\XSipRoutePattern',
            'AddSipRoutePatternReq' => '\\CUCM\\StructType\\AddSipRoutePatternReq',
            'UpdateSipRoutePatternReq' => '\\CUCM\\StructType\\UpdateSipRoutePatternReq',
            'RemoveSipRoutePatternReq' => '\\CUCM\\StructType\\RemoveSipRoutePatternReq',
            'GetSipRoutePatternReq' => '\\CUCM\\StructType\\GetSipRoutePatternReq',
            'GetSipRoutePatternRes' => '\\CUCM\\StructType\\GetSipRoutePatternRes',
            'ListSipRoutePatternReq' => '\\CUCM\\StructType\\ListSipRoutePatternReq',
            'ListSipRoutePatternRes' => '\\CUCM\\StructType\\ListSipRoutePatternRes',
            'XHuntPilot' => '\\CUCM\\StructType\\XHuntPilot',
            'parkMonForwardNoRetrieve' => '\\CUCM\\StructType\\ParkMonForwardNoRetrieve',
            'forwardHuntNoAnswer' => '\\CUCM\\StructType\\ForwardHuntNoAnswer',
            'forwardHuntBusy' => '\\CUCM\\StructType\\ForwardHuntBusy',
            'AddHuntPilotReq' => '\\CUCM\\StructType\\AddHuntPilotReq',
            'UpdateHuntPilotReq' => '\\CUCM\\StructType\\UpdateHuntPilotReq',
            'RemoveHuntPilotReq' => '\\CUCM\\StructType\\RemoveHuntPilotReq',
            'GetHuntPilotReq' => '\\CUCM\\StructType\\GetHuntPilotReq',
            'GetHuntPilotRes' => '\\CUCM\\StructType\\GetHuntPilotRes',
            'ListHuntPilotReq' => '\\CUCM\\StructType\\ListHuntPilotReq',
            'ListHuntPilotRes' => '\\CUCM\\StructType\\ListHuntPilotRes',
            'XRoutePattern' => '\\CUCM\\StructType\\XRoutePattern',
            'destination' => '\\CUCM\\StructType\\Destination',
            'isdnNsfInfoElement' => '\\CUCM\\StructType\\IsdnNsfInfoElement',
            'AddRoutePatternReq' => '\\CUCM\\StructType\\AddRoutePatternReq',
            'UpdateRoutePatternReq' => '\\CUCM\\StructType\\UpdateRoutePatternReq',
            'RemoveRoutePatternReq' => '\\CUCM\\StructType\\RemoveRoutePatternReq',
            'GetRoutePatternReq' => '\\CUCM\\StructType\\GetRoutePatternReq',
            'GetRoutePatternRes' => '\\CUCM\\StructType\\GetRoutePatternRes',
            'ListRoutePatternReq' => '\\CUCM\\StructType\\ListRoutePatternReq',
            'ListRoutePatternRes' => '\\CUCM\\StructType\\ListRoutePatternRes',
            'XApplicationDialRules' => '\\CUCM\\StructType\\XApplicationDialRules',
            'AddApplicationDialRulesReq' => '\\CUCM\\StructType\\AddApplicationDialRulesReq',
            'UpdateApplicationDialRulesReq' => '\\CUCM\\StructType\\UpdateApplicationDialRulesReq',
            'GetApplicationDialRulesReq' => '\\CUCM\\StructType\\GetApplicationDialRulesReq',
            'GetApplicationDialRulesRes' => '\\CUCM\\StructType\\GetApplicationDialRulesRes',
            'ListApplicationDialRulesReq' => '\\CUCM\\StructType\\ListApplicationDialRulesReq',
            'ListApplicationDialRulesRes' => '\\CUCM\\StructType\\ListApplicationDialRulesRes',
            'XDirectoryLookupDialRules' => '\\CUCM\\StructType\\XDirectoryLookupDialRules',
            'AddDirectoryLookupDialRulesReq' => '\\CUCM\\StructType\\AddDirectoryLookupDialRulesReq',
            'UpdateDirectoryLookupDialRulesReq' => '\\CUCM\\StructType\\UpdateDirectoryLookupDialRulesReq',
            'GetDirectoryLookupDialRulesReq' => '\\CUCM\\StructType\\GetDirectoryLookupDialRulesReq',
            'GetDirectoryLookupDialRulesRes' => '\\CUCM\\StructType\\GetDirectoryLookupDialRulesRes',
            'ListDirectoryLookupDialRulesReq' => '\\CUCM\\StructType\\ListDirectoryLookupDialRulesReq',
            'ListDirectoryLookupDialRulesRes' => '\\CUCM\\StructType\\ListDirectoryLookupDialRulesRes',
            'XPhoneSecurityProfile' => '\\CUCM\\StructType\\XPhoneSecurityProfile',
            'AddPhoneSecurityProfileReq' => '\\CUCM\\StructType\\AddPhoneSecurityProfileReq',
            'UpdatePhoneSecurityProfileReq' => '\\CUCM\\StructType\\UpdatePhoneSecurityProfileReq',
            'GetPhoneSecurityProfileReq' => '\\CUCM\\StructType\\GetPhoneSecurityProfileReq',
            'GetPhoneSecurityProfileRes' => '\\CUCM\\StructType\\GetPhoneSecurityProfileRes',
            'ListPhoneSecurityProfileReq' => '\\CUCM\\StructType\\ListPhoneSecurityProfileReq',
            'ListPhoneSecurityProfileRes' => '\\CUCM\\StructType\\ListPhoneSecurityProfileRes',
            'XSipDialRules' => '\\CUCM\\StructType\\XSipDialRules',
            'patterns' => '\\CUCM\\StructType\\Patterns',
            'plars' => '\\CUCM\\StructType\\Plars',
            'AddSipDialRulesReq' => '\\CUCM\\StructType\\AddSipDialRulesReq',
            'UpdateSipDialRulesReq' => '\\CUCM\\StructType\\UpdateSipDialRulesReq',
            'removePatterns' => '\\CUCM\\StructType\\RemovePatterns',
            'addPatterns' => '\\CUCM\\StructType\\AddPatterns',
            'removePlars' => '\\CUCM\\StructType\\RemovePlars',
            'addPlars' => '\\CUCM\\StructType\\AddPlars',
            'GetSipDialRulesReq' => '\\CUCM\\StructType\\GetSipDialRulesReq',
            'GetSipDialRulesRes' => '\\CUCM\\StructType\\GetSipDialRulesRes',
            'ListSipDialRulesReq' => '\\CUCM\\StructType\\ListSipDialRulesReq',
            'ListSipDialRulesRes' => '\\CUCM\\StructType\\ListSipDialRulesRes',
            'XConferenceBridge' => '\\CUCM\\StructType\\XConferenceBridge',
            'AddConferenceBridgeReq' => '\\CUCM\\StructType\\AddConferenceBridgeReq',
            'UpdateConferenceBridgeReq' => '\\CUCM\\StructType\\UpdateConferenceBridgeReq',
            'GetConferenceBridgeReq' => '\\CUCM\\StructType\\GetConferenceBridgeReq',
            'GetConferenceBridgeRes' => '\\CUCM\\StructType\\GetConferenceBridgeRes',
            'ListConferenceBridgeReq' => '\\CUCM\\StructType\\ListConferenceBridgeReq',
            'ListConferenceBridgeRes' => '\\CUCM\\StructType\\ListConferenceBridgeRes',
            'XAnnunciator' => '\\CUCM\\StructType\\XAnnunciator',
            'AddAnnunciatorReq' => '\\CUCM\\StructType\\AddAnnunciatorReq',
            'UpdateAnnunciatorReq' => '\\CUCM\\StructType\\UpdateAnnunciatorReq',
            'GetAnnunciatorReq' => '\\CUCM\\StructType\\GetAnnunciatorReq',
            'GetAnnunciatorRes' => '\\CUCM\\StructType\\GetAnnunciatorRes',
            'ListAnnunciatorReq' => '\\CUCM\\StructType\\ListAnnunciatorReq',
            'ListAnnunciatorRes' => '\\CUCM\\StructType\\ListAnnunciatorRes',
            'XMtp' => '\\CUCM\\StructType\\XMtp',
            'AddMtpReq' => '\\CUCM\\StructType\\AddMtpReq',
            'UpdateMtpReq' => '\\CUCM\\StructType\\UpdateMtpReq',
            'GetMtpReq' => '\\CUCM\\StructType\\GetMtpReq',
            'GetMtpRes' => '\\CUCM\\StructType\\GetMtpRes',
            'ListMtpReq' => '\\CUCM\\StructType\\ListMtpReq',
            'ListMtpRes' => '\\CUCM\\StructType\\ListMtpRes',
            'XFixedMohAudioSource' => '\\CUCM\\StructType\\XFixedMohAudioSource',
            'AddFixedMohAudioSourceReq' => '\\CUCM\\StructType\\AddFixedMohAudioSourceReq',
            'UpdateFixedMohAudioSourceReq' => '\\CUCM\\StructType\\UpdateFixedMohAudioSourceReq',
            'GetFixedMohAudioSourceReq' => '\\CUCM\\StructType\\GetFixedMohAudioSourceReq',
            'GetFixedMohAudioSourceRes' => '\\CUCM\\StructType\\GetFixedMohAudioSourceRes',
            'XAarGroupMatrix' => '\\CUCM\\StructType\\XAarGroupMatrix',
            'AddAarGroupMatrixReq' => '\\CUCM\\StructType\\AddAarGroupMatrixReq',
            'UpdateAarGroupMatrixReq' => '\\CUCM\\StructType\\UpdateAarGroupMatrixReq',
            'XRemoteDestinationProfile' => '\\CUCM\\StructType\\XRemoteDestinationProfile',
            'AddRemoteDestinationProfileReq' => '\\CUCM\\StructType\\AddRemoteDestinationProfileReq',
            'UpdateRemoteDestinationProfileReq' => '\\CUCM\\StructType\\UpdateRemoteDestinationProfileReq',
            'GetRemoteDestinationProfileReq' => '\\CUCM\\StructType\\GetRemoteDestinationProfileReq',
            'GetRemoteDestinationProfileRes' => '\\CUCM\\StructType\\GetRemoteDestinationProfileRes',
            'ListRemoteDestinationProfileReq' => '\\CUCM\\StructType\\ListRemoteDestinationProfileReq',
            'ListRemoteDestinationProfileRes' => '\\CUCM\\StructType\\ListRemoteDestinationProfileRes',
            'XLine' => '\\CUCM\\StructType\\XLine',
            'AddLineReq' => '\\CUCM\\StructType\\AddLineReq',
            'UpdateLineReq' => '\\CUCM\\StructType\\UpdateLineReq',
            'RemoveLineReq' => '\\CUCM\\StructType\\RemoveLineReq',
            'GetLineReq' => '\\CUCM\\StructType\\GetLineReq',
            'GetLineRes' => '\\CUCM\\StructType\\GetLineRes',
            'ListLineReq' => '\\CUCM\\StructType\\ListLineReq',
            'ListLineRes' => '\\CUCM\\StructType\\ListLineRes',
            'XDefaultDeviceProfile' => '\\CUCM\\StructType\\XDefaultDeviceProfile',
            'AddDefaultDeviceProfileReq' => '\\CUCM\\StructType\\AddDefaultDeviceProfileReq',
            'UpdateDefaultDeviceProfileReq' => '\\CUCM\\StructType\\UpdateDefaultDeviceProfileReq',
            'GetDefaultDeviceProfileReq' => '\\CUCM\\StructType\\GetDefaultDeviceProfileReq',
            'GetDefaultDeviceProfileRes' => '\\CUCM\\StructType\\GetDefaultDeviceProfileRes',
            'ListDefaultDeviceProfileReq' => '\\CUCM\\StructType\\ListDefaultDeviceProfileReq',
            'ListDefaultDeviceProfileRes' => '\\CUCM\\StructType\\ListDefaultDeviceProfileRes',
            'XH323Phone' => '\\CUCM\\StructType\\XH323Phone',
            'gateKeeperInfo' => '\\CUCM\\StructType\\GateKeeperInfo',
            'AddH323PhoneReq' => '\\CUCM\\StructType\\AddH323PhoneReq',
            'UpdateH323PhoneReq' => '\\CUCM\\StructType\\UpdateH323PhoneReq',
            'GetH323PhoneReq' => '\\CUCM\\StructType\\GetH323PhoneReq',
            'GetH323PhoneRes' => '\\CUCM\\StructType\\GetH323PhoneRes',
            'ListH323PhoneReq' => '\\CUCM\\StructType\\ListH323PhoneReq',
            'ListH323PhoneRes' => '\\CUCM\\StructType\\ListH323PhoneRes',
            'XMohServer' => '\\CUCM\\StructType\\XMohServer',
            'audioSources' => '\\CUCM\\StructType\\AudioSources',
            'audioSource' => '\\CUCM\\StructType\\AudioSource',
            'AddMohServerReq' => '\\CUCM\\StructType\\AddMohServerReq',
            'UpdateMohServerReq' => '\\CUCM\\StructType\\UpdateMohServerReq',
            'GetMohServerReq' => '\\CUCM\\StructType\\GetMohServerReq',
            'GetMohServerRes' => '\\CUCM\\StructType\\GetMohServerRes',
            'ListMohServerReq' => '\\CUCM\\StructType\\ListMohServerReq',
            'ListMohServerRes' => '\\CUCM\\StructType\\ListMohServerRes',
            'XH323Trunk' => '\\CUCM\\StructType\\XH323Trunk',
            'sigDigits' => '\\CUCM\\StructType\\SigDigits',
            'remoteServerinfo' => '\\CUCM\\StructType\\RemoteServerinfo',
            'destinations' => '\\CUCM\\StructType\\Destinations',
            'AddH323TrunkReq' => '\\CUCM\\StructType\\AddH323TrunkReq',
            'UpdateH323TrunkReq' => '\\CUCM\\StructType\\UpdateH323TrunkReq',
            'removeDestinations' => '\\CUCM\\StructType\\RemoveDestinations',
            'addDestinations' => '\\CUCM\\StructType\\AddDestinations',
            'GetH323TrunkReq' => '\\CUCM\\StructType\\GetH323TrunkReq',
            'GetH323TrunkRes' => '\\CUCM\\StructType\\GetH323TrunkRes',
            'ListH323TrunkReq' => '\\CUCM\\StructType\\ListH323TrunkReq',
            'ListH323TrunkRes' => '\\CUCM\\StructType\\ListH323TrunkRes',
            'XPhone' => '\\CUCM\\StructType\\XPhone',
            'speeddials' => '\\CUCM\\StructType\\Speeddials',
            'busyLampFields' => '\\CUCM\\StructType\\BusyLampFields',
            'blfDirectedCallParks' => '\\CUCM\\StructType\\BlfDirectedCallParks',
            'addOnModules' => '\\CUCM\\StructType\\AddOnModules',
            'services' => '\\CUCM\\StructType\\Services',
            'AddPhoneReq' => '\\CUCM\\StructType\\AddPhoneReq',
            'UpdatePhoneReq' => '\\CUCM\\StructType\\UpdatePhoneReq',
            'GetPhoneReq' => '\\CUCM\\StructType\\GetPhoneReq',
            'GetPhoneRes' => '\\CUCM\\StructType\\GetPhoneRes',
            'ListPhoneReq' => '\\CUCM\\StructType\\ListPhoneReq',
            'ListPhoneRes' => '\\CUCM\\StructType\\ListPhoneRes',
            'XH323Gateway' => '\\CUCM\\StructType\\XH323Gateway',
            'AddH323GatewayReq' => '\\CUCM\\StructType\\AddH323GatewayReq',
            'UpdateH323GatewayReq' => '\\CUCM\\StructType\\UpdateH323GatewayReq',
            'GetH323GatewayReq' => '\\CUCM\\StructType\\GetH323GatewayReq',
            'GetH323GatewayRes' => '\\CUCM\\StructType\\GetH323GatewayRes',
            'ListH323GatewayReq' => '\\CUCM\\StructType\\ListH323GatewayReq',
            'ListH323GatewayRes' => '\\CUCM\\StructType\\ListH323GatewayRes',
            'XDeviceProfile' => '\\CUCM\\StructType\\XDeviceProfile',
            'AddDeviceProfileReq' => '\\CUCM\\StructType\\AddDeviceProfileReq',
            'UpdateDeviceProfileReq' => '\\CUCM\\StructType\\UpdateDeviceProfileReq',
            'GetDeviceProfileReq' => '\\CUCM\\StructType\\GetDeviceProfileReq',
            'GetDeviceProfileRes' => '\\CUCM\\StructType\\GetDeviceProfileRes',
            'ListDeviceProfileReq' => '\\CUCM\\StructType\\ListDeviceProfileReq',
            'ListDeviceProfileRes' => '\\CUCM\\StructType\\ListDeviceProfileRes',
            'XRemoteDestination' => '\\CUCM\\StructType\\XRemoteDestination',
            'lineAssociations' => '\\CUCM\\StructType\\LineAssociations',
            'AddRemoteDestinationReq' => '\\CUCM\\StructType\\AddRemoteDestinationReq',
            'UpdateRemoteDestinationReq' => '\\CUCM\\StructType\\UpdateRemoteDestinationReq',
            'RemoveRemoteDestinationReq' => '\\CUCM\\StructType\\RemoveRemoteDestinationReq',
            'GetRemoteDestinationReq' => '\\CUCM\\StructType\\GetRemoteDestinationReq',
            'GetRemoteDestinationRes' => '\\CUCM\\StructType\\GetRemoteDestinationRes',
            'ListRemoteDestinationReq' => '\\CUCM\\StructType\\ListRemoteDestinationReq',
            'ListRemoteDestinationRes' => '\\CUCM\\StructType\\ListRemoteDestinationRes',
            'XGateway' => '\\CUCM\\StructType\\XGateway',
            'units' => '\\CUCM\\StructType\\Units',
            'unit' => '\\CUCM\\StructType\\Unit',
            'subunits' => '\\CUCM\\StructType\\Subunits',
            'subunit' => '\\CUCM\\StructType\\Subunit',
            'AddGatewayReq' => '\\CUCM\\StructType\\AddGatewayReq',
            'UpdateGatewayReq' => '\\CUCM\\StructType\\UpdateGatewayReq',
            'RemoveGatewayReq' => '\\CUCM\\StructType\\RemoveGatewayReq',
            'GetGatewayReq' => '\\CUCM\\StructType\\GetGatewayReq',
            'GetGatewayRes' => '\\CUCM\\StructType\\GetGatewayRes',
            'ListGatewayReq' => '\\CUCM\\StructType\\ListGatewayReq',
            'ListGatewayRes' => '\\CUCM\\StructType\\ListGatewayRes',
            'XGatewayEndpointAnalogAccess' => '\\CUCM\\StructType\\XGatewayEndpointAnalogAccess',
            'AddGatewayEndpointAnalogAccessReq' => '\\CUCM\\StructType\\AddGatewayEndpointAnalogAccessReq',
            'UpdateGatewayEndpointAnalogAccessReq' => '\\CUCM\\StructType\\UpdateGatewayEndpointAnalogAccessReq',
            'GetGatewayEndpointAnalogAccessReq' => '\\CUCM\\StructType\\GetGatewayEndpointAnalogAccessReq',
            'GetGatewayEndpointAnalogAccessRes' => '\\CUCM\\StructType\\GetGatewayEndpointAnalogAccessRes',
            'XGatewayEndpointDigitalAccessPri' => '\\CUCM\\StructType\\XGatewayEndpointDigitalAccessPri',
            'AddGatewayEndpointDigitalAccessPriReq' => '\\CUCM\\StructType\\AddGatewayEndpointDigitalAccessPriReq',
            'UpdateGatewayEndpointDigitalAccessPriReq' => '\\CUCM\\StructType\\UpdateGatewayEndpointDigitalAccessPriReq',
            'GetGatewayEndpointDigitalAccessPriReq' => '\\CUCM\\StructType\\GetGatewayEndpointDigitalAccessPriReq',
            'GetGatewayEndpointDigitalAccessPriRes' => '\\CUCM\\StructType\\GetGatewayEndpointDigitalAccessPriRes',
            'XGatewayEndpointDigitalAccessBri' => '\\CUCM\\StructType\\XGatewayEndpointDigitalAccessBri',
            'AddGatewayEndpointDigitalAccessBriReq' => '\\CUCM\\StructType\\AddGatewayEndpointDigitalAccessBriReq',
            'UpdateGatewayEndpointDigitalAccessBriReq' => '\\CUCM\\StructType\\UpdateGatewayEndpointDigitalAccessBriReq',
            'GetGatewayEndpointDigitalAccessBriReq' => '\\CUCM\\StructType\\GetGatewayEndpointDigitalAccessBriReq',
            'GetGatewayEndpointDigitalAccessBriRes' => '\\CUCM\\StructType\\GetGatewayEndpointDigitalAccessBriRes',
            'XGatewayEndpointDigitalAccessT1' => '\\CUCM\\StructType\\XGatewayEndpointDigitalAccessT1',
            'AddGatewayEndpointDigitalAccessT1Req' => '\\CUCM\\StructType\\AddGatewayEndpointDigitalAccessT1Req',
            'UpdateGatewayEndpointDigitalAccessT1Req' => '\\CUCM\\StructType\\UpdateGatewayEndpointDigitalAccessT1Req',
            'GetGatewayEndpointDigitalAccessT1Req' => '\\CUCM\\StructType\\GetGatewayEndpointDigitalAccessT1Req',
            'GetGatewayEndpointDigitalAccessT1Res' => '\\CUCM\\StructType\\GetGatewayEndpointDigitalAccessT1Res',
            'XVg224' => '\\CUCM\\StructType\\XVg224',
            'AddVg224Req' => '\\CUCM\\StructType\\AddVg224Req',
            'UpdateVg224Req' => '\\CUCM\\StructType\\UpdateVg224Req',
            'RemoveVg224Req' => '\\CUCM\\StructType\\RemoveVg224Req',
            'GetVg224Req' => '\\CUCM\\StructType\\GetVg224Req',
            'GetVg224Res' => '\\CUCM\\StructType\\GetVg224Res',
            'XCiscoCatalyst600024PortFXSGateway' => '\\CUCM\\StructType\\XCiscoCatalyst600024PortFXSGateway',
            'AddCiscoCatalyst600024PortFXSGatewayReq' => '\\CUCM\\StructType\\AddCiscoCatalyst600024PortFXSGatewayReq',
            'UpdateCiscoCatalyst600024PortFXSGatewayReq' => '\\CUCM\\StructType\\UpdateCiscoCatalyst600024PortFXSGatewayReq',
            'GetCiscoCatalyst600024PortFXSGatewayReq' => '\\CUCM\\StructType\\GetCiscoCatalyst600024PortFXSGatewayReq',
            'GetCiscoCatalyst600024PortFXSGatewayRes' => '\\CUCM\\StructType\\GetCiscoCatalyst600024PortFXSGatewayRes',
            'ListCiscoCatalyst600024PortFXSGatewayReq' => '\\CUCM\\StructType\\ListCiscoCatalyst600024PortFXSGatewayReq',
            'ListCiscoCatalyst600024PortFXSGatewayRes' => '\\CUCM\\StructType\\ListCiscoCatalyst600024PortFXSGatewayRes',
            'XCiscoCatalyst6000E1VoIPGateway' => '\\CUCM\\StructType\\XCiscoCatalyst6000E1VoIPGateway',
            'AddCiscoCatalyst6000E1VoIPGatewayReq' => '\\CUCM\\StructType\\AddCiscoCatalyst6000E1VoIPGatewayReq',
            'UpdateCiscoCatalyst6000E1VoIPGatewayReq' => '\\CUCM\\StructType\\UpdateCiscoCatalyst6000E1VoIPGatewayReq',
            'GetCiscoCatalyst6000E1VoIPGatewayReq' => '\\CUCM\\StructType\\GetCiscoCatalyst6000E1VoIPGatewayReq',
            'GetCiscoCatalyst6000E1VoIPGatewayRes' => '\\CUCM\\StructType\\GetCiscoCatalyst6000E1VoIPGatewayRes',
            'ListCiscoCatalyst6000E1VoIPGatewayReq' => '\\CUCM\\StructType\\ListCiscoCatalyst6000E1VoIPGatewayReq',
            'ListCiscoCatalyst6000E1VoIPGatewayRes' => '\\CUCM\\StructType\\ListCiscoCatalyst6000E1VoIPGatewayRes',
            'XCiscoCatalyst6000T1VoIPGatewayPri' => '\\CUCM\\StructType\\XCiscoCatalyst6000T1VoIPGatewayPri',
            'AddCiscoCatalyst6000T1VoIPGatewayPriReq' => '\\CUCM\\StructType\\AddCiscoCatalyst6000T1VoIPGatewayPriReq',
            'UpdateCiscoCatalyst6000T1VoIPGatewayPriReq' => '\\CUCM\\StructType\\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq',
            'GetCiscoCatalyst6000T1VoIPGatewayPriReq' => '\\CUCM\\StructType\\GetCiscoCatalyst6000T1VoIPGatewayPriReq',
            'GetCiscoCatalyst6000T1VoIPGatewayPriRes' => '\\CUCM\\StructType\\GetCiscoCatalyst6000T1VoIPGatewayPriRes',
            'ListCiscoCatalyst6000T1VoIPGatewayPriReq' => '\\CUCM\\StructType\\ListCiscoCatalyst6000T1VoIPGatewayPriReq',
            'ListCiscoCatalyst6000T1VoIPGatewayPriRes' => '\\CUCM\\StructType\\ListCiscoCatalyst6000T1VoIPGatewayPriRes',
            'XCiscoCatalyst6000T1VoIPGatewayT1' => '\\CUCM\\StructType\\XCiscoCatalyst6000T1VoIPGatewayT1',
            'AddCiscoCatalyst6000T1VoIPGatewayT1Req' => '\\CUCM\\StructType\\AddCiscoCatalyst6000T1VoIPGatewayT1Req',
            'UpdateCiscoCatalyst6000T1VoIPGatewayT1Req' => '\\CUCM\\StructType\\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req',
            'GetCiscoCatalyst6000T1VoIPGatewayT1Req' => '\\CUCM\\StructType\\GetCiscoCatalyst6000T1VoIPGatewayT1Req',
            'GetCiscoCatalyst6000T1VoIPGatewayT1Res' => '\\CUCM\\StructType\\GetCiscoCatalyst6000T1VoIPGatewayT1Res',
            'ListCiscoCatalyst6000T1VoIPGatewayT1Req' => '\\CUCM\\StructType\\ListCiscoCatalyst6000T1VoIPGatewayT1Req',
            'ListCiscoCatalyst6000T1VoIPGatewayT1Res' => '\\CUCM\\StructType\\ListCiscoCatalyst6000T1VoIPGatewayT1Res',
            'XCallPickupGroup' => '\\CUCM\\StructType\\XCallPickupGroup',
            'callInfoForPickupNotification' => '\\CUCM\\StructType\\CallInfoForPickupNotification',
            'AddCallPickupGroupReq' => '\\CUCM\\StructType\\AddCallPickupGroupReq',
            'UpdateCallPickupGroupReq' => '\\CUCM\\StructType\\UpdateCallPickupGroupReq',
            'RemoveCallPickupGroupReq' => '\\CUCM\\StructType\\RemoveCallPickupGroupReq',
            'GetCallPickupGroupReq' => '\\CUCM\\StructType\\GetCallPickupGroupReq',
            'GetCallPickupGroupRes' => '\\CUCM\\StructType\\GetCallPickupGroupRes',
            'ListCallPickupGroupReq' => '\\CUCM\\StructType\\ListCallPickupGroupReq',
            'ListCallPickupGroupRes' => '\\CUCM\\StructType\\ListCallPickupGroupRes',
            'XRoutePlan' => '\\CUCM\\StructType\\XRoutePlan',
            'AddRoutePlanReq' => '\\CUCM\\StructType\\AddRoutePlanReq',
            'ListRoutePlanReq' => '\\CUCM\\StructType\\ListRoutePlanReq',
            'ListRoutePlanRes' => '\\CUCM\\StructType\\ListRoutePlanRes',
            'XGeoLocationPolicy' => '\\CUCM\\StructType\\XGeoLocationPolicy',
            'relatedPolicies' => '\\CUCM\\StructType\\RelatedPolicies',
            'AddGeoLocationPolicyReq' => '\\CUCM\\StructType\\AddGeoLocationPolicyReq',
            'UpdateGeoLocationPolicyReq' => '\\CUCM\\StructType\\UpdateGeoLocationPolicyReq',
            'removeRelatedPolicies' => '\\CUCM\\StructType\\RemoveRelatedPolicies',
            'addRelatedPolicies' => '\\CUCM\\StructType\\AddRelatedPolicies',
            'GetGeoLocationPolicyReq' => '\\CUCM\\StructType\\GetGeoLocationPolicyReq',
            'GetGeoLocationPolicyRes' => '\\CUCM\\StructType\\GetGeoLocationPolicyRes',
            'ListGeoLocationPolicyReq' => '\\CUCM\\StructType\\ListGeoLocationPolicyReq',
            'ListGeoLocationPolicyRes' => '\\CUCM\\StructType\\ListGeoLocationPolicyRes',
            'XSipTrunk' => '\\CUCM\\StructType\\XSipTrunk',
            'AddSipTrunkReq' => '\\CUCM\\StructType\\AddSipTrunkReq',
            'UpdateSipTrunkReq' => '\\CUCM\\StructType\\UpdateSipTrunkReq',
            'GetSipTrunkReq' => '\\CUCM\\StructType\\GetSipTrunkReq',
            'GetSipTrunkRes' => '\\CUCM\\StructType\\GetSipTrunkRes',
            'ListSipTrunkReq' => '\\CUCM\\StructType\\ListSipTrunkReq',
            'ListSipTrunkRes' => '\\CUCM\\StructType\\ListSipTrunkRes',
            'XRegionMatrix' => '\\CUCM\\StructType\\XRegionMatrix',
            'AddRegionMatrixReq' => '\\CUCM\\StructType\\AddRegionMatrixReq',
            'UpdateRegionMatrixReq' => '\\CUCM\\StructType\\UpdateRegionMatrixReq',
            'XCalledPartyTransformationPattern' => '\\CUCM\\StructType\\XCalledPartyTransformationPattern',
            'AddCalledPartyTransformationPatternReq' => '\\CUCM\\StructType\\AddCalledPartyTransformationPatternReq',
            'UpdateCalledPartyTransformationPatternReq' => '\\CUCM\\StructType\\UpdateCalledPartyTransformationPatternReq',
            'RemoveCalledPartyTransformationPatternReq' => '\\CUCM\\StructType\\RemoveCalledPartyTransformationPatternReq',
            'GetCalledPartyTransformationPatternReq' => '\\CUCM\\StructType\\GetCalledPartyTransformationPatternReq',
            'GetCalledPartyTransformationPatternRes' => '\\CUCM\\StructType\\GetCalledPartyTransformationPatternRes',
            'ListCalledPartyTransformationPatternReq' => '\\CUCM\\StructType\\ListCalledPartyTransformationPatternReq',
            'ListCalledPartyTransformationPatternRes' => '\\CUCM\\StructType\\ListCalledPartyTransformationPatternRes',
            'XExternalCallControlProfile' => '\\CUCM\\StructType\\XExternalCallControlProfile',
            'AddExternalCallControlProfileReq' => '\\CUCM\\StructType\\AddExternalCallControlProfileReq',
            'UpdateExternalCallControlProfileReq' => '\\CUCM\\StructType\\UpdateExternalCallControlProfileReq',
            'GetExternalCallControlProfileReq' => '\\CUCM\\StructType\\GetExternalCallControlProfileReq',
            'GetExternalCallControlProfileRes' => '\\CUCM\\StructType\\GetExternalCallControlProfileRes',
            'ListExternalCallControlProfileReq' => '\\CUCM\\StructType\\ListExternalCallControlProfileReq',
            'ListExternalCallControlProfileRes' => '\\CUCM\\StructType\\ListExternalCallControlProfileRes',
            'XSafSecurityProfile' => '\\CUCM\\StructType\\XSafSecurityProfile',
            'AddSafSecurityProfileReq' => '\\CUCM\\StructType\\AddSafSecurityProfileReq',
            'UpdateSafSecurityProfileReq' => '\\CUCM\\StructType\\UpdateSafSecurityProfileReq',
            'GetSafSecurityProfileReq' => '\\CUCM\\StructType\\GetSafSecurityProfileReq',
            'GetSafSecurityProfileRes' => '\\CUCM\\StructType\\GetSafSecurityProfileRes',
            'ListSafSecurityProfileReq' => '\\CUCM\\StructType\\ListSafSecurityProfileReq',
            'ListSafSecurityProfileRes' => '\\CUCM\\StructType\\ListSafSecurityProfileRes',
            'XSafForwarder' => '\\CUCM\\StructType\\XSafForwarder',
            'associatedCucms' => '\\CUCM\\StructType\\AssociatedCucms',
            'AddSafForwarderReq' => '\\CUCM\\StructType\\AddSafForwarderReq',
            'UpdateSafForwarderReq' => '\\CUCM\\StructType\\UpdateSafForwarderReq',
            'removeAssociatedCucms' => '\\CUCM\\StructType\\RemoveAssociatedCucms',
            'addAssociatedCucms' => '\\CUCM\\StructType\\AddAssociatedCucms',
            'GetSafForwarderReq' => '\\CUCM\\StructType\\GetSafForwarderReq',
            'GetSafForwarderRes' => '\\CUCM\\StructType\\GetSafForwarderRes',
            'ListSafForwarderReq' => '\\CUCM\\StructType\\ListSafForwarderReq',
            'ListSafForwarderRes' => '\\CUCM\\StructType\\ListSafForwarderRes',
            'XCcdHostedDN' => '\\CUCM\\StructType\\XCcdHostedDN',
            'AddCcdHostedDNReq' => '\\CUCM\\StructType\\AddCcdHostedDNReq',
            'UpdateCcdHostedDNReq' => '\\CUCM\\StructType\\UpdateCcdHostedDNReq',
            'RemoveCcdHostedDNReq' => '\\CUCM\\StructType\\RemoveCcdHostedDNReq',
            'GetCcdHostedDNReq' => '\\CUCM\\StructType\\GetCcdHostedDNReq',
            'GetCcdHostedDNRes' => '\\CUCM\\StructType\\GetCcdHostedDNRes',
            'ListCcdHostedDNReq' => '\\CUCM\\StructType\\ListCcdHostedDNReq',
            'ListCcdHostedDNRes' => '\\CUCM\\StructType\\ListCcdHostedDNRes',
            'XCcdHostedDNGroup' => '\\CUCM\\StructType\\XCcdHostedDNGroup',
            'AddCcdHostedDNGroupReq' => '\\CUCM\\StructType\\AddCcdHostedDNGroupReq',
            'UpdateCcdHostedDNGroupReq' => '\\CUCM\\StructType\\UpdateCcdHostedDNGroupReq',
            'GetCcdHostedDNGroupReq' => '\\CUCM\\StructType\\GetCcdHostedDNGroupReq',
            'GetCcdHostedDNGroupRes' => '\\CUCM\\StructType\\GetCcdHostedDNGroupRes',
            'ListCcdHostedDNGroupReq' => '\\CUCM\\StructType\\ListCcdHostedDNGroupReq',
            'ListCcdHostedDNGroupRes' => '\\CUCM\\StructType\\ListCcdHostedDNGroupRes',
            'XCcdRequestingService' => '\\CUCM\\StructType\\XCcdRequestingService',
            'associatedTrunks' => '\\CUCM\\StructType\\AssociatedTrunks',
            'AddCcdRequestingServiceReq' => '\\CUCM\\StructType\\AddCcdRequestingServiceReq',
            'UpdateCcdRequestingServiceReq' => '\\CUCM\\StructType\\UpdateCcdRequestingServiceReq',
            'removeAssociatedTrunks' => '\\CUCM\\StructType\\RemoveAssociatedTrunks',
            'addAssociatedTrunks' => '\\CUCM\\StructType\\AddAssociatedTrunks',
            'GetCcdRequestingServiceReq' => '\\CUCM\\StructType\\GetCcdRequestingServiceReq',
            'GetCcdRequestingServiceRes' => '\\CUCM\\StructType\\GetCcdRequestingServiceRes',
            'XInterClusterServiceProfile' => '\\CUCM\\StructType\\XInterClusterServiceProfile',
            'AddInterClusterServiceProfileReq' => '\\CUCM\\StructType\\AddInterClusterServiceProfileReq',
            'UpdateInterClusterServiceProfileReq' => '\\CUCM\\StructType\\UpdateInterClusterServiceProfileReq',
            'GetInterClusterServiceProfileReq' => '\\CUCM\\StructType\\GetInterClusterServiceProfileReq',
            'GetInterClusterServiceProfileRes' => '\\CUCM\\StructType\\GetInterClusterServiceProfileRes',
            'XRemoteCluster' => '\\CUCM\\StructType\\XRemoteCluster',
            'AddRemoteClusterReq' => '\\CUCM\\StructType\\AddRemoteClusterReq',
            'UpdateRemoteClusterReq' => '\\CUCM\\StructType\\UpdateRemoteClusterReq',
            'RemoveRemoteClusterReq' => '\\CUCM\\StructType\\RemoveRemoteClusterReq',
            'GetRemoteClusterReq' => '\\CUCM\\StructType\\GetRemoteClusterReq',
            'GetRemoteClusterRes' => '\\CUCM\\StructType\\GetRemoteClusterRes',
            'ListRemoteClusterReq' => '\\CUCM\\StructType\\ListRemoteClusterReq',
            'ListRemoteClusterRes' => '\\CUCM\\StructType\\ListRemoteClusterRes',
            'XCcdAdvertisingService' => '\\CUCM\\StructType\\XCcdAdvertisingService',
            'AddCcdAdvertisingServiceReq' => '\\CUCM\\StructType\\AddCcdAdvertisingServiceReq',
            'UpdateCcdAdvertisingServiceReq' => '\\CUCM\\StructType\\UpdateCcdAdvertisingServiceReq',
            'GetCcdAdvertisingServiceReq' => '\\CUCM\\StructType\\GetCcdAdvertisingServiceReq',
            'GetCcdAdvertisingServiceRes' => '\\CUCM\\StructType\\GetCcdAdvertisingServiceRes',
            'ListCcdAdvertisingServiceReq' => '\\CUCM\\StructType\\ListCcdAdvertisingServiceReq',
            'ListCcdAdvertisingServiceRes' => '\\CUCM\\StructType\\ListCcdAdvertisingServiceRes',
            'XUnitsToGateway' => '\\CUCM\\StructType\\XUnitsToGateway',
            'AddUnitsToGatewayReq' => '\\CUCM\\StructType\\AddUnitsToGatewayReq',
            'XGatewaySubunits' => '\\CUCM\\StructType\\XGatewaySubunits',
            'AddGatewaySubunitsReq' => '\\CUCM\\StructType\\AddGatewaySubunitsReq',
            'XLdapDirectory' => '\\CUCM\\StructType\\XLdapDirectory',
            'servers' => '\\CUCM\\StructType\\Servers',
            'server' => '\\CUCM\\StructType\\Server',
            'AddLdapDirectoryReq' => '\\CUCM\\StructType\\AddLdapDirectoryReq',
            'UpdateLdapDirectoryReq' => '\\CUCM\\StructType\\UpdateLdapDirectoryReq',
            'GetLdapDirectoryReq' => '\\CUCM\\StructType\\GetLdapDirectoryReq',
            'GetLdapDirectoryRes' => '\\CUCM\\StructType\\GetLdapDirectoryRes',
            'ListLdapDirectoryReq' => '\\CUCM\\StructType\\ListLdapDirectoryReq',
            'ListLdapDirectoryRes' => '\\CUCM\\StructType\\ListLdapDirectoryRes',
            'XEmccFeatureConfig' => '\\CUCM\\StructType\\XEmccFeatureConfig',
            'AddEmccFeatureConfigReq' => '\\CUCM\\StructType\\AddEmccFeatureConfigReq',
            'UpdateEmccFeatureConfigReq' => '\\CUCM\\StructType\\UpdateEmccFeatureConfigReq',
            'GetEmccFeatureConfigReq' => '\\CUCM\\StructType\\GetEmccFeatureConfigReq',
            'GetEmccFeatureConfigRes' => '\\CUCM\\StructType\\GetEmccFeatureConfigRes',
            'XSafCcdPurgeBlockLearnedRoutes' => '\\CUCM\\StructType\\XSafCcdPurgeBlockLearnedRoutes',
            'AddSafCcdPurgeBlockLearnedRoutesReq' => '\\CUCM\\StructType\\AddSafCcdPurgeBlockLearnedRoutesReq',
            'UpdateSafCcdPurgeBlockLearnedRoutesReq' => '\\CUCM\\StructType\\UpdateSafCcdPurgeBlockLearnedRoutesReq',
            'RemoveSafCcdPurgeBlockLearnedRoutesReq' => '\\CUCM\\StructType\\RemoveSafCcdPurgeBlockLearnedRoutesReq',
            'GetSafCcdPurgeBlockLearnedRoutesReq' => '\\CUCM\\StructType\\GetSafCcdPurgeBlockLearnedRoutesReq',
            'GetSafCcdPurgeBlockLearnedRoutesRes' => '\\CUCM\\StructType\\GetSafCcdPurgeBlockLearnedRoutesRes',
            'ListSafCcdPurgeBlockLearnedRoutesReq' => '\\CUCM\\StructType\\ListSafCcdPurgeBlockLearnedRoutesReq',
            'ListSafCcdPurgeBlockLearnedRoutesRes' => '\\CUCM\\StructType\\ListSafCcdPurgeBlockLearnedRoutesRes',
            'XVpnGateway' => '\\CUCM\\StructType\\XVpnGateway',
            'certificates' => '\\CUCM\\StructType\\Certificates',
            'AddVpnGatewayReq' => '\\CUCM\\StructType\\AddVpnGatewayReq',
            'UpdateVpnGatewayReq' => '\\CUCM\\StructType\\UpdateVpnGatewayReq',
            'GetVpnGatewayReq' => '\\CUCM\\StructType\\GetVpnGatewayReq',
            'GetVpnGatewayRes' => '\\CUCM\\StructType\\GetVpnGatewayRes',
            'ListVpnGatewayReq' => '\\CUCM\\StructType\\ListVpnGatewayReq',
            'ListVpnGatewayRes' => '\\CUCM\\StructType\\ListVpnGatewayRes',
            'XVpnGroup' => '\\CUCM\\StructType\\XVpnGroup',
            'vpnGateways' => '\\CUCM\\StructType\\VpnGateways',
            'AddVpnGroupReq' => '\\CUCM\\StructType\\AddVpnGroupReq',
            'UpdateVpnGroupReq' => '\\CUCM\\StructType\\UpdateVpnGroupReq',
            'GetVpnGroupReq' => '\\CUCM\\StructType\\GetVpnGroupReq',
            'GetVpnGroupRes' => '\\CUCM\\StructType\\GetVpnGroupRes',
            'ListVpnGroupReq' => '\\CUCM\\StructType\\ListVpnGroupReq',
            'ListVpnGroupRes' => '\\CUCM\\StructType\\ListVpnGroupRes',
            'XVpnProfile' => '\\CUCM\\StructType\\XVpnProfile',
            'AddVpnProfileReq' => '\\CUCM\\StructType\\AddVpnProfileReq',
            'UpdateVpnProfileReq' => '\\CUCM\\StructType\\UpdateVpnProfileReq',
            'GetVpnProfileReq' => '\\CUCM\\StructType\\GetVpnProfileReq',
            'GetVpnProfileRes' => '\\CUCM\\StructType\\GetVpnProfileRes',
            'ListVpnProfileReq' => '\\CUCM\\StructType\\ListVpnProfileReq',
            'ListVpnProfileRes' => '\\CUCM\\StructType\\ListVpnProfileRes',
            'XImeServer' => '\\CUCM\\StructType\\XImeServer',
            'AddImeServerReq' => '\\CUCM\\StructType\\AddImeServerReq',
            'UpdateImeServerReq' => '\\CUCM\\StructType\\UpdateImeServerReq',
            'GetImeServerReq' => '\\CUCM\\StructType\\GetImeServerReq',
            'GetImeServerRes' => '\\CUCM\\StructType\\GetImeServerRes',
            'ListImeServerReq' => '\\CUCM\\StructType\\ListImeServerReq',
            'ListImeServerRes' => '\\CUCM\\StructType\\ListImeServerRes',
            'XImeRouteFilterGroup' => '\\CUCM\\StructType\\XImeRouteFilterGroup',
            'AddImeRouteFilterGroupReq' => '\\CUCM\\StructType\\AddImeRouteFilterGroupReq',
            'UpdateImeRouteFilterGroupReq' => '\\CUCM\\StructType\\UpdateImeRouteFilterGroupReq',
            'GetImeRouteFilterGroupReq' => '\\CUCM\\StructType\\GetImeRouteFilterGroupReq',
            'GetImeRouteFilterGroupRes' => '\\CUCM\\StructType\\GetImeRouteFilterGroupRes',
            'ListImeRouteFilterGroupReq' => '\\CUCM\\StructType\\ListImeRouteFilterGroupReq',
            'ListImeRouteFilterGroupRes' => '\\CUCM\\StructType\\ListImeRouteFilterGroupRes',
            'XImeRouteFilterElement' => '\\CUCM\\StructType\\XImeRouteFilterElement',
            'AddImeRouteFilterElementReq' => '\\CUCM\\StructType\\AddImeRouteFilterElementReq',
            'UpdateImeRouteFilterElementReq' => '\\CUCM\\StructType\\UpdateImeRouteFilterElementReq',
            'GetImeRouteFilterElementReq' => '\\CUCM\\StructType\\GetImeRouteFilterElementReq',
            'GetImeRouteFilterElementRes' => '\\CUCM\\StructType\\GetImeRouteFilterElementRes',
            'ListImeRouteFilterElementReq' => '\\CUCM\\StructType\\ListImeRouteFilterElementReq',
            'ListImeRouteFilterElementRes' => '\\CUCM\\StructType\\ListImeRouteFilterElementRes',
            'XImeClient' => '\\CUCM\\StructType\\XImeClient',
            'ccmExternalIpMaps' => '\\CUCM\\StructType\\CcmExternalIpMaps',
            'AddImeClientReq' => '\\CUCM\\StructType\\AddImeClientReq',
            'UpdateImeClientReq' => '\\CUCM\\StructType\\UpdateImeClientReq',
            'removeCcmExternalIpMaps' => '\\CUCM\\StructType\\RemoveCcmExternalIpMaps',
            'addCcmExternalIpMaps' => '\\CUCM\\StructType\\AddCcmExternalIpMaps',
            'GetImeClientReq' => '\\CUCM\\StructType\\GetImeClientReq',
            'GetImeClientRes' => '\\CUCM\\StructType\\GetImeClientRes',
            'ListImeClientReq' => '\\CUCM\\StructType\\ListImeClientReq',
            'ListImeClientRes' => '\\CUCM\\StructType\\ListImeClientRes',
            'XImeEnrolledPattern' => '\\CUCM\\StructType\\XImeEnrolledPattern',
            'AddImeEnrolledPatternReq' => '\\CUCM\\StructType\\AddImeEnrolledPatternReq',
            'UpdateImeEnrolledPatternReq' => '\\CUCM\\StructType\\UpdateImeEnrolledPatternReq',
            'RemoveImeEnrolledPatternReq' => '\\CUCM\\StructType\\RemoveImeEnrolledPatternReq',
            'GetImeEnrolledPatternReq' => '\\CUCM\\StructType\\GetImeEnrolledPatternReq',
            'GetImeEnrolledPatternRes' => '\\CUCM\\StructType\\GetImeEnrolledPatternRes',
            'ListImeEnrolledPatternReq' => '\\CUCM\\StructType\\ListImeEnrolledPatternReq',
            'ListImeEnrolledPatternRes' => '\\CUCM\\StructType\\ListImeEnrolledPatternRes',
            'XImeEnrolledPatternGroup' => '\\CUCM\\StructType\\XImeEnrolledPatternGroup',
            'AddImeEnrolledPatternGroupReq' => '\\CUCM\\StructType\\AddImeEnrolledPatternGroupReq',
            'UpdateImeEnrolledPatternGroupReq' => '\\CUCM\\StructType\\UpdateImeEnrolledPatternGroupReq',
            'GetImeEnrolledPatternGroupReq' => '\\CUCM\\StructType\\GetImeEnrolledPatternGroupReq',
            'GetImeEnrolledPatternGroupRes' => '\\CUCM\\StructType\\GetImeEnrolledPatternGroupRes',
            'ListImeEnrolledPatternGroupReq' => '\\CUCM\\StructType\\ListImeEnrolledPatternGroupReq',
            'ListImeEnrolledPatternGroupRes' => '\\CUCM\\StructType\\ListImeEnrolledPatternGroupRes',
            'XImeExclusionNumber' => '\\CUCM\\StructType\\XImeExclusionNumber',
            'AddImeExclusionNumberReq' => '\\CUCM\\StructType\\AddImeExclusionNumberReq',
            'UpdateImeExclusionNumberReq' => '\\CUCM\\StructType\\UpdateImeExclusionNumberReq',
            'RemoveImeExclusionNumberReq' => '\\CUCM\\StructType\\RemoveImeExclusionNumberReq',
            'GetImeExclusionNumberReq' => '\\CUCM\\StructType\\GetImeExclusionNumberReq',
            'GetImeExclusionNumberRes' => '\\CUCM\\StructType\\GetImeExclusionNumberRes',
            'ListImeExclusionNumberReq' => '\\CUCM\\StructType\\ListImeExclusionNumberReq',
            'ListImeExclusionNumberRes' => '\\CUCM\\StructType\\ListImeExclusionNumberRes',
            'XImeExclusionNumberGroup' => '\\CUCM\\StructType\\XImeExclusionNumberGroup',
            'AddImeExclusionNumberGroupReq' => '\\CUCM\\StructType\\AddImeExclusionNumberGroupReq',
            'UpdateImeExclusionNumberGroupReq' => '\\CUCM\\StructType\\UpdateImeExclusionNumberGroupReq',
            'GetImeExclusionNumberGroupReq' => '\\CUCM\\StructType\\GetImeExclusionNumberGroupReq',
            'GetImeExclusionNumberGroupRes' => '\\CUCM\\StructType\\GetImeExclusionNumberGroupRes',
            'ListImeExclusionNumberGroupReq' => '\\CUCM\\StructType\\ListImeExclusionNumberGroupReq',
            'ListImeExclusionNumberGroupRes' => '\\CUCM\\StructType\\ListImeExclusionNumberGroupRes',
            'XImeFirewall' => '\\CUCM\\StructType\\XImeFirewall',
            'AddImeFirewallReq' => '\\CUCM\\StructType\\AddImeFirewallReq',
            'UpdateImeFirewallReq' => '\\CUCM\\StructType\\UpdateImeFirewallReq',
            'GetImeFirewallReq' => '\\CUCM\\StructType\\GetImeFirewallReq',
            'GetImeFirewallRes' => '\\CUCM\\StructType\\GetImeFirewallRes',
            'ListImeFirewallReq' => '\\CUCM\\StructType\\ListImeFirewallReq',
            'ListImeFirewallRes' => '\\CUCM\\StructType\\ListImeFirewallRes',
            'XImeE164Transformation' => '\\CUCM\\StructType\\XImeE164Transformation',
            'AddImeE164TransformationReq' => '\\CUCM\\StructType\\AddImeE164TransformationReq',
            'UpdateImeE164TransformationReq' => '\\CUCM\\StructType\\UpdateImeE164TransformationReq',
            'GetImeE164TransformationReq' => '\\CUCM\\StructType\\GetImeE164TransformationReq',
            'GetImeE164TransformationRes' => '\\CUCM\\StructType\\GetImeE164TransformationRes',
            'ListImeE164TransformationReq' => '\\CUCM\\StructType\\ListImeE164TransformationReq',
            'ListImeE164TransformationRes' => '\\CUCM\\StructType\\ListImeE164TransformationRes',
            'XTransformationProfile' => '\\CUCM\\StructType\\XTransformationProfile',
            'AddTransformationProfileReq' => '\\CUCM\\StructType\\AddTransformationProfileReq',
            'UpdateTransformationProfileReq' => '\\CUCM\\StructType\\UpdateTransformationProfileReq',
            'GetTransformationProfileReq' => '\\CUCM\\StructType\\GetTransformationProfileReq',
            'GetTransformationProfileRes' => '\\CUCM\\StructType\\GetTransformationProfileRes',
            'ListTransformationProfileReq' => '\\CUCM\\StructType\\ListTransformationProfileReq',
            'ListTransformationProfileRes' => '\\CUCM\\StructType\\ListTransformationProfileRes',
            'XFallbackProfile' => '\\CUCM\\StructType\\XFallbackProfile',
            'AddFallbackProfileReq' => '\\CUCM\\StructType\\AddFallbackProfileReq',
            'UpdateFallbackProfileReq' => '\\CUCM\\StructType\\UpdateFallbackProfileReq',
            'GetFallbackProfileReq' => '\\CUCM\\StructType\\GetFallbackProfileReq',
            'GetFallbackProfileRes' => '\\CUCM\\StructType\\GetFallbackProfileRes',
            'ListFallbackProfileReq' => '\\CUCM\\StructType\\ListFallbackProfileReq',
            'ListFallbackProfileRes' => '\\CUCM\\StructType\\ListFallbackProfileRes',
            'XLdapFilter' => '\\CUCM\\StructType\\XLdapFilter',
            'AddLdapFilterReq' => '\\CUCM\\StructType\\AddLdapFilterReq',
            'UpdateLdapFilterReq' => '\\CUCM\\StructType\\UpdateLdapFilterReq',
            'GetLdapFilterReq' => '\\CUCM\\StructType\\GetLdapFilterReq',
            'GetLdapFilterRes' => '\\CUCM\\StructType\\GetLdapFilterRes',
            'ListLdapFilterReq' => '\\CUCM\\StructType\\ListLdapFilterReq',
            'ListLdapFilterRes' => '\\CUCM\\StructType\\ListLdapFilterRes',
            'XAppServerInfo' => '\\CUCM\\StructType\\XAppServerInfo',
            'AddAppServerInfoReq' => '\\CUCM\\StructType\\AddAppServerInfoReq',
            'UpdateAppServerInfoReq' => '\\CUCM\\StructType\\UpdateAppServerInfoReq',
            'XTvsCertificate' => '\\CUCM\\StructType\\XTvsCertificate',
            'roles' => '\\CUCM\\StructType\\Roles',
            'AddTvsCertificateReq' => '\\CUCM\\StructType\\AddTvsCertificateReq',
            'UpdateTvsCertificateReq' => '\\CUCM\\StructType\\UpdateTvsCertificateReq',
            'GetTvsCertificateReq' => '\\CUCM\\StructType\\GetTvsCertificateReq',
            'GetTvsCertificateRes' => '\\CUCM\\StructType\\GetTvsCertificateRes',
            'ListTvsCertificateReq' => '\\CUCM\\StructType\\ListTvsCertificateReq',
            'ListTvsCertificateRes' => '\\CUCM\\StructType\\ListTvsCertificateRes',
            'XFeatureControlPolicy' => '\\CUCM\\StructType\\XFeatureControlPolicy',
            'features' => '\\CUCM\\StructType\\Features',
            'AddFeatureControlPolicyReq' => '\\CUCM\\StructType\\AddFeatureControlPolicyReq',
            'UpdateFeatureControlPolicyReq' => '\\CUCM\\StructType\\UpdateFeatureControlPolicyReq',
            'GetFeatureControlPolicyReq' => '\\CUCM\\StructType\\GetFeatureControlPolicyReq',
            'GetFeatureControlPolicyRes' => '\\CUCM\\StructType\\GetFeatureControlPolicyRes',
            'ListFeatureControlPolicyReq' => '\\CUCM\\StructType\\ListFeatureControlPolicyReq',
            'ListFeatureControlPolicyRes' => '\\CUCM\\StructType\\ListFeatureControlPolicyRes',
            'XMobilityProfile' => '\\CUCM\\StructType\\XMobilityProfile',
            'AddMobilityProfileReq' => '\\CUCM\\StructType\\AddMobilityProfileReq',
            'UpdateMobilityProfileReq' => '\\CUCM\\StructType\\UpdateMobilityProfileReq',
            'GetMobilityProfileReq' => '\\CUCM\\StructType\\GetMobilityProfileReq',
            'GetMobilityProfileRes' => '\\CUCM\\StructType\\GetMobilityProfileRes',
            'ListMobilityProfileReq' => '\\CUCM\\StructType\\ListMobilityProfileReq',
            'ListMobilityProfileRes' => '\\CUCM\\StructType\\ListMobilityProfileRes',
            'XEnterpriseFeatureAccessConfiguration' => '\\CUCM\\StructType\\XEnterpriseFeatureAccessConfiguration',
            'AddEnterpriseFeatureAccessConfigurationReq' => '\\CUCM\\StructType\\AddEnterpriseFeatureAccessConfigurationReq',
            'UpdateEnterpriseFeatureAccessConfigurationReq' => '\\CUCM\\StructType\\UpdateEnterpriseFeatureAccessConfigurationReq',
            'RemoveEnterpriseFeatureAccessConfigurationReq' => '\\CUCM\\StructType\\RemoveEnterpriseFeatureAccessConfigurationReq',
            'GetEnterpriseFeatureAccessConfigurationReq' => '\\CUCM\\StructType\\GetEnterpriseFeatureAccessConfigurationReq',
            'GetEnterpriseFeatureAccessConfigurationRes' => '\\CUCM\\StructType\\GetEnterpriseFeatureAccessConfigurationRes',
            'ListEnterpriseFeatureAccessConfigurationReq' => '\\CUCM\\StructType\\ListEnterpriseFeatureAccessConfigurationReq',
            'ListEnterpriseFeatureAccessConfigurationRes' => '\\CUCM\\StructType\\ListEnterpriseFeatureAccessConfigurationRes',
            'XHandoffConfiguration' => '\\CUCM\\StructType\\XHandoffConfiguration',
            'AddHandoffConfigurationReq' => '\\CUCM\\StructType\\AddHandoffConfigurationReq',
            'UpdateHandoffConfigurationReq' => '\\CUCM\\StructType\\UpdateHandoffConfigurationReq',
            'RemoveHandoffConfigurationReq' => '\\CUCM\\StructType\\RemoveHandoffConfigurationReq',
            'GetHandoffConfigurationReq' => '\\CUCM\\StructType\\GetHandoffConfigurationReq',
            'GetHandoffConfigurationRes' => '\\CUCM\\StructType\\GetHandoffConfigurationRes',
            'LSipProfile' => '\\CUCM\\StructType\\LSipProfile',
            'LSipTrunkSecurityProfile' => '\\CUCM\\StructType\\LSipTrunkSecurityProfile',
            'LTimePeriod' => '\\CUCM\\StructType\\LTimePeriod',
            'LTimeSchedule' => '\\CUCM\\StructType\\LTimeSchedule',
            'LTodAccess' => '\\CUCM\\StructType\\LTodAccess',
            'LVoiceMailPilot' => '\\CUCM\\StructType\\LVoiceMailPilot',
            'LProcessNode' => '\\CUCM\\StructType\\LProcessNode',
            'LCallerFilterList' => '\\CUCM\\StructType\\LCallerFilterList',
            'LRoutePartition' => '\\CUCM\\StructType\\LRoutePartition',
            'LCss' => '\\CUCM\\StructType\\LCss',
            'LCallManager' => '\\CUCM\\StructType\\LCallManager',
            'LMediaResourceGroup' => '\\CUCM\\StructType\\LMediaResourceGroup',
            'LMediaResourceList' => '\\CUCM\\StructType\\LMediaResourceList',
            'LRegion' => '\\CUCM\\StructType\\LRegion',
            'LAarGroup' => '\\CUCM\\StructType\\LAarGroup',
            'LPhysicalLocation' => '\\CUCM\\StructType\\LPhysicalLocation',
            'LRouteGroup' => '\\CUCM\\StructType\\LRouteGroup',
            'LDevicePool' => '\\CUCM\\StructType\\LDevicePool',
            'LDeviceMobilityGroup' => '\\CUCM\\StructType\\LDeviceMobilityGroup',
            'LLocation' => '\\CUCM\\StructType\\LLocation',
            'LSoftKeyTemplate' => '\\CUCM\\StructType\\LSoftKeyTemplate',
            'LTranscoder' => '\\CUCM\\StructType\\LTranscoder',
            'LCommonDeviceConfig' => '\\CUCM\\StructType\\LCommonDeviceConfig',
            'LResourcePriorityNamespace' => '\\CUCM\\StructType\\LResourcePriorityNamespace',
            'LResourcePriorityNamespaceList' => '\\CUCM\\StructType\\LResourcePriorityNamespaceList',
            'LDeviceMobility' => '\\CUCM\\StructType\\LDeviceMobility',
            'LCmcInfo' => '\\CUCM\\StructType\\LCmcInfo',
            'LCredentialPolicy' => '\\CUCM\\StructType\\LCredentialPolicy',
            'LFacInfo' => '\\CUCM\\StructType\\LFacInfo',
            'LHuntList' => '\\CUCM\\StructType\\LHuntList',
            'LIvrUserLocale' => '\\CUCM\\StructType\\LIvrUserLocale',
            'LLineGroup' => '\\CUCM\\StructType\\LLineGroup',
            'LRecordingProfile' => '\\CUCM\\StructType\\LRecordingProfile',
            'LRouteFilter' => '\\CUCM\\StructType\\LRouteFilter',
            'LCallManagerGroup' => '\\CUCM\\StructType\\LCallManagerGroup',
            'LUserGroup' => '\\CUCM\\StructType\\LUserGroup',
            'LDialPlan' => '\\CUCM\\StructType\\LDialPlan',
            'LDialPlanTag' => '\\CUCM\\StructType\\LDialPlanTag',
            'LDdi' => '\\CUCM\\StructType\\LDdi',
            'LMobileSmartClientProfile' => '\\CUCM\\StructType\\LMobileSmartClientProfile',
            'LProcessNodeService' => '\\CUCM\\StructType\\LProcessNodeService',
            'LMohAudioSource' => '\\CUCM\\StructType\\LMohAudioSource',
            'LDhcpServer' => '\\CUCM\\StructType\\LDhcpServer',
            'LDhcpSubnet' => '\\CUCM\\StructType\\LDhcpSubnet',
            'LCallPark' => '\\CUCM\\StructType\\LCallPark',
            'LDirectedCallPark' => '\\CUCM\\StructType\\LDirectedCallPark',
            'LMeetMe' => '\\CUCM\\StructType\\LMeetMe',
            'LMobileVoiceAccess' => '\\CUCM\\StructType\\LMobileVoiceAccess',
            'LRouteList' => '\\CUCM\\StructType\\LRouteList',
            'LUser' => '\\CUCM\\StructType\\LUser',
            'LLicenseCapabilities' => '\\CUCM\\StructType\\LLicenseCapabilities',
            'LAppUser' => '\\CUCM\\StructType\\LAppUser',
            'LSipRealm' => '\\CUCM\\StructType\\LSipRealm',
            'LPhoneNtp' => '\\CUCM\\StructType\\LPhoneNtp',
            'LDateTimeGroup' => '\\CUCM\\StructType\\LDateTimeGroup',
            'LPresenceGroup' => '\\CUCM\\StructType\\LPresenceGroup',
            'LGeoLocation' => '\\CUCM\\StructType\\LGeoLocation',
            'LSrst' => '\\CUCM\\StructType\\LSrst',
            'LMlppDomain' => '\\CUCM\\StructType\\LMlppDomain',
            'LCumaServerSecurityProfile' => '\\CUCM\\StructType\\LCumaServerSecurityProfile',
            'LApplicationServer' => '\\CUCM\\StructType\\LApplicationServer',
            'LApplicationUserCapfProfile' => '\\CUCM\\StructType\\LApplicationUserCapfProfile',
            'LEndUserCapfProfile' => '\\CUCM\\StructType\\LEndUserCapfProfile',
            'LServiceParameter' => '\\CUCM\\StructType\\LServiceParameter',
            'LUserPhoneAssociation' => '\\CUCM\\StructType\\LUserPhoneAssociation',
            'LGeoLocationFilter' => '\\CUCM\\StructType\\LGeoLocationFilter',
            'LVoiceMailProfile' => '\\CUCM\\StructType\\LVoiceMailProfile',
            'LVoiceMailPort' => '\\CUCM\\StructType\\LVoiceMailPort',
            'LGatekeeper' => '\\CUCM\\StructType\\LGatekeeper',
            'LPhoneButtonTemplate' => '\\CUCM\\StructType\\LPhoneButtonTemplate',
            'LCommonPhoneConfig' => '\\CUCM\\StructType\\LCommonPhoneConfig',
            'LMessageWaiting' => '\\CUCM\\StructType\\LMessageWaiting',
            'LIpPhoneServices' => '\\CUCM\\StructType\\LIpPhoneServices',
            'LCtiRoutePoint' => '\\CUCM\\StructType\\LCtiRoutePoint',
            'LTransPattern' => '\\CUCM\\StructType\\LTransPattern',
            'LCallingPartyTransformationPattern' => '\\CUCM\\StructType\\LCallingPartyTransformationPattern',
            'LSipRoutePattern' => '\\CUCM\\StructType\\LSipRoutePattern',
            'LHuntPilot' => '\\CUCM\\StructType\\LHuntPilot',
            'LRoutePattern' => '\\CUCM\\StructType\\LRoutePattern',
            'LApplicationDialRules' => '\\CUCM\\StructType\\LApplicationDialRules',
            'LDirectoryLookupDialRules' => '\\CUCM\\StructType\\LDirectoryLookupDialRules',
            'LPhoneSecurityProfile' => '\\CUCM\\StructType\\LPhoneSecurityProfile',
            'LSipDialRules' => '\\CUCM\\StructType\\LSipDialRules',
            'LConferenceBridge' => '\\CUCM\\StructType\\LConferenceBridge',
            'LAnnunciator' => '\\CUCM\\StructType\\LAnnunciator',
            'LMtp' => '\\CUCM\\StructType\\LMtp',
            'LFixedMohAudioSource' => '\\CUCM\\StructType\\LFixedMohAudioSource',
            'LAarGroupMatrix' => '\\CUCM\\StructType\\LAarGroupMatrix',
            'LRemoteDestinationProfile' => '\\CUCM\\StructType\\LRemoteDestinationProfile',
            'LLine' => '\\CUCM\\StructType\\LLine',
            'LDefaultDeviceProfile' => '\\CUCM\\StructType\\LDefaultDeviceProfile',
            'LH323Phone' => '\\CUCM\\StructType\\LH323Phone',
            'LMohServer' => '\\CUCM\\StructType\\LMohServer',
            'LH323Trunk' => '\\CUCM\\StructType\\LH323Trunk',
            'LPhone' => '\\CUCM\\StructType\\LPhone',
            'currentConfig' => '\\CUCM\\StructType\\CurrentConfig',
            'LH323Gateway' => '\\CUCM\\StructType\\LH323Gateway',
            'LDeviceProfile' => '\\CUCM\\StructType\\LDeviceProfile',
            'LRemoteDestination' => '\\CUCM\\StructType\\LRemoteDestination',
            'LGateway' => '\\CUCM\\StructType\\LGateway',
            'LGatewayEndpointAnalogAccess' => '\\CUCM\\StructType\\LGatewayEndpointAnalogAccess',
            'LGatewayEndpointDigitalAccessPri' => '\\CUCM\\StructType\\LGatewayEndpointDigitalAccessPri',
            'LGatewayEndpointDigitalAccessBri' => '\\CUCM\\StructType\\LGatewayEndpointDigitalAccessBri',
            'LGatewayEndpointDigitalAccessT1' => '\\CUCM\\StructType\\LGatewayEndpointDigitalAccessT1',
            'LVg224' => '\\CUCM\\StructType\\LVg224',
            'LCiscoCatalyst600024PortFXSGateway' => '\\CUCM\\StructType\\LCiscoCatalyst600024PortFXSGateway',
            'LCiscoCatalyst6000E1VoIPGateway' => '\\CUCM\\StructType\\LCiscoCatalyst6000E1VoIPGateway',
            'LCiscoCatalyst6000T1VoIPGatewayPri' => '\\CUCM\\StructType\\LCiscoCatalyst6000T1VoIPGatewayPri',
            'LCiscoCatalyst6000T1VoIPGatewayT1' => '\\CUCM\\StructType\\LCiscoCatalyst6000T1VoIPGatewayT1',
            'LCallPickupGroup' => '\\CUCM\\StructType\\LCallPickupGroup',
            'LRoutePlan' => '\\CUCM\\StructType\\LRoutePlan',
            'LGeoLocationPolicy' => '\\CUCM\\StructType\\LGeoLocationPolicy',
            'LSipTrunk' => '\\CUCM\\StructType\\LSipTrunk',
            'LRegionMatrix' => '\\CUCM\\StructType\\LRegionMatrix',
            'LCalledPartyTransformationPattern' => '\\CUCM\\StructType\\LCalledPartyTransformationPattern',
            'LExternalCallControlProfile' => '\\CUCM\\StructType\\LExternalCallControlProfile',
            'LSafSecurityProfile' => '\\CUCM\\StructType\\LSafSecurityProfile',
            'LSafForwarder' => '\\CUCM\\StructType\\LSafForwarder',
            'LCcdHostedDN' => '\\CUCM\\StructType\\LCcdHostedDN',
            'LCcdHostedDNGroup' => '\\CUCM\\StructType\\LCcdHostedDNGroup',
            'LCcdRequestingService' => '\\CUCM\\StructType\\LCcdRequestingService',
            'LInterClusterServiceProfile' => '\\CUCM\\StructType\\LInterClusterServiceProfile',
            'LRemoteCluster' => '\\CUCM\\StructType\\LRemoteCluster',
            'LCcdAdvertisingService' => '\\CUCM\\StructType\\LCcdAdvertisingService',
            'LUnitsToGateway' => '\\CUCM\\StructType\\LUnitsToGateway',
            'LGatewaySubunits' => '\\CUCM\\StructType\\LGatewaySubunits',
            'LLdapDirectory' => '\\CUCM\\StructType\\LLdapDirectory',
            'LEmccFeatureConfig' => '\\CUCM\\StructType\\LEmccFeatureConfig',
            'LSafCcdPurgeBlockLearnedRoutes' => '\\CUCM\\StructType\\LSafCcdPurgeBlockLearnedRoutes',
            'LVpnGateway' => '\\CUCM\\StructType\\LVpnGateway',
            'LVpnGroup' => '\\CUCM\\StructType\\LVpnGroup',
            'LVpnProfile' => '\\CUCM\\StructType\\LVpnProfile',
            'LImeServer' => '\\CUCM\\StructType\\LImeServer',
            'LImeRouteFilterGroup' => '\\CUCM\\StructType\\LImeRouteFilterGroup',
            'LImeRouteFilterElement' => '\\CUCM\\StructType\\LImeRouteFilterElement',
            'LImeClient' => '\\CUCM\\StructType\\LImeClient',
            'LImeEnrolledPattern' => '\\CUCM\\StructType\\LImeEnrolledPattern',
            'LImeEnrolledPatternGroup' => '\\CUCM\\StructType\\LImeEnrolledPatternGroup',
            'LImeExclusionNumber' => '\\CUCM\\StructType\\LImeExclusionNumber',
            'LImeExclusionNumberGroup' => '\\CUCM\\StructType\\LImeExclusionNumberGroup',
            'LImeFirewall' => '\\CUCM\\StructType\\LImeFirewall',
            'LImeE164Transformation' => '\\CUCM\\StructType\\LImeE164Transformation',
            'LTransformationProfile' => '\\CUCM\\StructType\\LTransformationProfile',
            'LFallbackProfile' => '\\CUCM\\StructType\\LFallbackProfile',
            'LLdapFilter' => '\\CUCM\\StructType\\LLdapFilter',
            'LAppServerInfo' => '\\CUCM\\StructType\\LAppServerInfo',
            'LTvsCertificate' => '\\CUCM\\StructType\\LTvsCertificate',
            'LFeatureControlPolicy' => '\\CUCM\\StructType\\LFeatureControlPolicy',
            'LMobilityProfile' => '\\CUCM\\StructType\\LMobilityProfile',
            'LEnterpriseFeatureAccessConfiguration' => '\\CUCM\\StructType\\LEnterpriseFeatureAccessConfiguration',
            'LHandoffConfiguration' => '\\CUCM\\StructType\\LHandoffConfiguration',
            'LTODAccessMember' => '\\CUCM\\StructType\\LTODAccessMember',
            'LTimeScheduleTimePeriod' => '\\CUCM\\StructType\\LTimeScheduleTimePeriod',
            'LCallerFilterListMember' => '\\CUCM\\StructType\\LCallerFilterListMember',
            'LCallingSearchSpaceMember' => '\\CUCM\\StructType\\LCallingSearchSpaceMember',
            'LMediaResourceGroupMember' => '\\CUCM\\StructType\\LMediaResourceGroupMember',
            'LMediaResourceListMember' => '\\CUCM\\StructType\\LMediaResourceListMember',
            'LRegionRelationship' => '\\CUCM\\StructType\\LRegionRelationship',
            'LAarGroupRelationship' => '\\CUCM\\StructType\\LAarGroupRelationship',
            'LRouteGroupMember' => '\\CUCM\\StructType\\LRouteGroupMember',
            'LLocationRelationship' => '\\CUCM\\StructType\\LLocationRelationship',
            'LResourcePriorityNamespaceListMember' => '\\CUCM\\StructType\\LResourcePriorityNamespaceListMember',
            'LDevicePoolDeviceMobility' => '\\CUCM\\StructType\\LDevicePoolDeviceMobility',
            'LHuntListMember' => '\\CUCM\\StructType\\LHuntListMember',
            'LRouteFilterMember' => '\\CUCM\\StructType\\LRouteFilterMember',
            'LCallManagerMember' => '\\CUCM\\StructType\\LCallManagerMember',
            'LUserGroupMember' => '\\CUCM\\StructType\\LUserGroupMember',
            'LDigitDiscardInstructionMember' => '\\CUCM\\StructType\\LDigitDiscardInstructionMember',
            'LRouteListMember' => '\\CUCM\\StructType\\LRouteListMember',
            'LButton' => '\\CUCM\\StructType\\LButton',
            'LNumplanIdentifier' => '\\CUCM\\StructType\\LNumplanIdentifier',
            'LDateTimeGroupNtpReference' => '\\CUCM\\StructType\\LDateTimeGroupNtpReference',
            'LPresenceGroupMember' => '\\CUCM\\StructType\\LPresenceGroupMember',
            'LHuntForwardInfoBusy' => '\\CUCM\\StructType\\LHuntForwardInfoBusy',
            'LHuntForwardInfoNoAnswer' => '\\CUCM\\StructType\\LHuntForwardInfoNoAnswer',
            'LLineGroupMember' => '\\CUCM\\StructType\\LLineGroupMember',
            'LCallForwardAll' => '\\CUCM\\StructType\\LCallForwardAll',
            'LCallForwardBusy' => '\\CUCM\\StructType\\LCallForwardBusy',
            'LCallForwardBusyInt' => '\\CUCM\\StructType\\LCallForwardBusyInt',
            'LCallForwardNoAnswer' => '\\CUCM\\StructType\\LCallForwardNoAnswer',
            'LCallForwardNoAnswerInt' => '\\CUCM\\StructType\\LCallForwardNoAnswerInt',
            'LCallForwardNoCoverage' => '\\CUCM\\StructType\\LCallForwardNoCoverage',
            'LCallForwardNoCoverageInt' => '\\CUCM\\StructType\\LCallForwardNoCoverageInt',
            'LCallForwardOnFailure' => '\\CUCM\\StructType\\LCallForwardOnFailure',
            'LCallForwardAlternateParty' => '\\CUCM\\StructType\\LCallForwardAlternateParty',
            'LCallForwardNotRegistered' => '\\CUCM\\StructType\\LCallForwardNotRegistered',
            'LCallForwardNotRegisteredInt' => '\\CUCM\\StructType\\LCallForwardNotRegisteredInt',
            'LPhoneLine' => '\\CUCM\\StructType\\LPhoneLine',
            'callInfoDisplay' => '\\CUCM\\StructType\\CallInfoDisplay',
            'LEnduserMember' => '\\CUCM\\StructType\\LEnduserMember',
            'LSpeeddial' => '\\CUCM\\StructType\\LSpeeddial',
            'LBusyLampField' => '\\CUCM\\StructType\\LBusyLampField',
            'LAddOnModule' => '\\CUCM\\StructType\\LAddOnModule',
            'LSubscribedService' => '\\CUCM\\StructType\\LSubscribedService',
            'LBLFDirectedCallPark' => '\\CUCM\\StructType\\LBLFDirectedCallPark',
            'directedCallParkDnAndPartition' => '\\CUCM\\StructType\\DirectedCallParkDnAndPartition',
            'LLineAssociation' => '\\CUCM\\StructType\\LLineAssociation',
            'LAnalogPort' => '\\CUCM\\StructType\\LAnalogPort',
            'LGatewayEndpointAnalog' => '\\CUCM\\StructType\\LGatewayEndpointAnalog',
            'LGatewayEndpointDigitalPri' => '\\CUCM\\StructType\\LGatewayEndpointDigitalPri',
            'LGatewayEndpointDigitalBri' => '\\CUCM\\StructType\\LGatewayEndpointDigitalBri',
            'LT1Port' => '\\CUCM\\StructType\\LT1Port',
            'LGatewayEndpointDigitalT1' => '\\CUCM\\StructType\\LGatewayEndpointDigitalT1',
            'LPickupGroupMember' => '\\CUCM\\StructType\\LPickupGroupMember',
            'pickupDnAndPartition' => '\\CUCM\\StructType\\PickupDnAndPartition',
            'LPolicyRelationship' => '\\CUCM\\StructType\\LPolicyRelationship',
            'LIpPhoneServicesParameter' => '\\CUCM\\StructType\\LIpPhoneServicesParameter',
            'LSafForwarderMember' => '\\CUCM\\StructType\\LSafForwarderMember',
            'LCcdRequestingServiceMember' => '\\CUCM\\StructType\\LCcdRequestingServiceMember',
            'LDirn' => '\\CUCM\\StructType\\LDirn',
            'LRemoteClusterMember' => '\\CUCM\\StructType\\LRemoteClusterMember',
            'LPatternMember' => '\\CUCM\\StructType\\LPatternMember',
            'LParameterMember' => '\\CUCM\\StructType\\LParameterMember',
            'LVmPilot' => '\\CUCM\\StructType\\LVmPilot',
            'LMobileVoiceMember' => '\\CUCM\\StructType\\LMobileVoiceMember',
            'LVpnGatewayMember' => '\\CUCM\\StructType\\LVpnGatewayMember',
            'LVpnGroupMember' => '\\CUCM\\StructType\\LVpnGroupMember',
            'LImeClientMember' => '\\CUCM\\StructType\\LImeClientMember',
            'LH323Line' => '\\CUCM\\StructType\\LH323Line',
            'LUserGroupRoles' => '\\CUCM\\StructType\\LUserGroupRoles',
            'LCertificateRole' => '\\CUCM\\StructType\\LCertificateRole',
            'LTvsCertificateService' => '\\CUCM\\StructType\\LTvsCertificateService',
            'LFeatureControlConfig' => '\\CUCM\\StructType\\LFeatureControlConfig',
            'LSipTrunkDestination' => '\\CUCM\\StructType\\LSipTrunkDestination',
            'LH323TrunkDestination' => '\\CUCM\\StructType\\LH323TrunkDestination',
            'LCcmExternalIpMap' => '\\CUCM\\StructType\\LCcmExternalIpMap',
            'RSipProfile' => '\\CUCM\\StructType\\RSipProfile',
            'RSipTrunkSecurityProfile' => '\\CUCM\\StructType\\RSipTrunkSecurityProfile',
            'RTimePeriod' => '\\CUCM\\StructType\\RTimePeriod',
            'RTimeSchedule' => '\\CUCM\\StructType\\RTimeSchedule',
            'RTodAccess' => '\\CUCM\\StructType\\RTodAccess',
            'associatedRemoteDestination' => '\\CUCM\\StructType\\AssociatedRemoteDestination',
            'RVoiceMailPilot' => '\\CUCM\\StructType\\RVoiceMailPilot',
            'RProcessNode' => '\\CUCM\\StructType\\RProcessNode',
            'RCallerFilterList' => '\\CUCM\\StructType\\RCallerFilterList',
            'RRoutePartition' => '\\CUCM\\StructType\\RRoutePartition',
            'RCss' => '\\CUCM\\StructType\\RCss',
            'RCallManager' => '\\CUCM\\StructType\\RCallManager',
            'RMediaResourceGroup' => '\\CUCM\\StructType\\RMediaResourceGroup',
            'RMediaResourceList' => '\\CUCM\\StructType\\RMediaResourceList',
            'RRegion' => '\\CUCM\\StructType\\RRegion',
            'RAarGroup' => '\\CUCM\\StructType\\RAarGroup',
            'relatedGroups' => '\\CUCM\\StructType\\RelatedGroups',
            'RPhysicalLocation' => '\\CUCM\\StructType\\RPhysicalLocation',
            'RRouteGroup' => '\\CUCM\\StructType\\RRouteGroup',
            'RDevicePool' => '\\CUCM\\StructType\\RDevicePool',
            'RDeviceMobilityGroup' => '\\CUCM\\StructType\\RDeviceMobilityGroup',
            'RLocation' => '\\CUCM\\StructType\\RLocation',
            'RSoftKeyTemplate' => '\\CUCM\\StructType\\RSoftKeyTemplate',
            'applications' => '\\CUCM\\StructType\\Applications',
            'RTranscoder' => '\\CUCM\\StructType\\RTranscoder',
            'RCommonDeviceConfig' => '\\CUCM\\StructType\\RCommonDeviceConfig',
            'RResourcePriorityNamespace' => '\\CUCM\\StructType\\RResourcePriorityNamespace',
            'RResourcePriorityNamespaceList' => '\\CUCM\\StructType\\RResourcePriorityNamespaceList',
            'RDeviceMobility' => '\\CUCM\\StructType\\RDeviceMobility',
            'RCmcInfo' => '\\CUCM\\StructType\\RCmcInfo',
            'RCredentialPolicy' => '\\CUCM\\StructType\\RCredentialPolicy',
            'RFacInfo' => '\\CUCM\\StructType\\RFacInfo',
            'RHuntList' => '\\CUCM\\StructType\\RHuntList',
            'RIvrUserLocale' => '\\CUCM\\StructType\\RIvrUserLocale',
            'RLineGroup' => '\\CUCM\\StructType\\RLineGroup',
            'RRecordingProfile' => '\\CUCM\\StructType\\RRecordingProfile',
            'RRouteFilter' => '\\CUCM\\StructType\\RRouteFilter',
            'RCallManagerGroup' => '\\CUCM\\StructType\\RCallManagerGroup',
            'RUserGroup' => '\\CUCM\\StructType\\RUserGroup',
            'RDialPlan' => '\\CUCM\\StructType\\RDialPlan',
            'RDialPlanTag' => '\\CUCM\\StructType\\RDialPlanTag',
            'RDdi' => '\\CUCM\\StructType\\RDdi',
            'RMobileSmartClientProfile' => '\\CUCM\\StructType\\RMobileSmartClientProfile',
            'RProcessNodeService' => '\\CUCM\\StructType\\RProcessNodeService',
            'RMohAudioSource' => '\\CUCM\\StructType\\RMohAudioSource',
            'RDhcpServer' => '\\CUCM\\StructType\\RDhcpServer',
            'RDhcpSubnet' => '\\CUCM\\StructType\\RDhcpSubnet',
            'RCallPark' => '\\CUCM\\StructType\\RCallPark',
            'RDirectedCallPark' => '\\CUCM\\StructType\\RDirectedCallPark',
            'RMeetMe' => '\\CUCM\\StructType\\RMeetMe',
            'RMobileVoiceAccess' => '\\CUCM\\StructType\\RMobileVoiceAccess',
            'RRouteList' => '\\CUCM\\StructType\\RRouteList',
            'RUser' => '\\CUCM\\StructType\\RUser',
            'associatedRemoteDestinationProfiles' => '\\CUCM\\StructType\\AssociatedRemoteDestinationProfiles',
            'associatedTodAccess' => '\\CUCM\\StructType\\AssociatedTodAccess',
            'associatedCapfProfiles' => '\\CUCM\\StructType\\AssociatedCapfProfiles',
            'RLicenseCapabilities' => '\\CUCM\\StructType\\RLicenseCapabilities',
            'RAppUser' => '\\CUCM\\StructType\\RAppUser',
            'RSipRealm' => '\\CUCM\\StructType\\RSipRealm',
            'RPhoneNtp' => '\\CUCM\\StructType\\RPhoneNtp',
            'RDateTimeGroup' => '\\CUCM\\StructType\\RDateTimeGroup',
            'RPresenceGroup' => '\\CUCM\\StructType\\RPresenceGroup',
            'RGeoLocation' => '\\CUCM\\StructType\\RGeoLocation',
            'RSrst' => '\\CUCM\\StructType\\RSrst',
            'RMlppDomain' => '\\CUCM\\StructType\\RMlppDomain',
            'RCumaServerSecurityProfile' => '\\CUCM\\StructType\\RCumaServerSecurityProfile',
            'RApplicationServer' => '\\CUCM\\StructType\\RApplicationServer',
            'RApplicationUserCapfProfile' => '\\CUCM\\StructType\\RApplicationUserCapfProfile',
            'REndUserCapfProfile' => '\\CUCM\\StructType\\REndUserCapfProfile',
            'RServiceParameter' => '\\CUCM\\StructType\\RServiceParameter',
            'RUserPhoneAssociation' => '\\CUCM\\StructType\\RUserPhoneAssociation',
            'RGeoLocationFilter' => '\\CUCM\\StructType\\RGeoLocationFilter',
            'RVoiceMailProfile' => '\\CUCM\\StructType\\RVoiceMailProfile',
            'RVoiceMailPort' => '\\CUCM\\StructType\\RVoiceMailPort',
            'RGatekeeper' => '\\CUCM\\StructType\\RGatekeeper',
            'RPhoneButtonTemplate' => '\\CUCM\\StructType\\RPhoneButtonTemplate',
            'RCommonPhoneConfig' => '\\CUCM\\StructType\\RCommonPhoneConfig',
            'RMessageWaiting' => '\\CUCM\\StructType\\RMessageWaiting',
            'RIpPhoneServices' => '\\CUCM\\StructType\\RIpPhoneServices',
            'RCtiRoutePoint' => '\\CUCM\\StructType\\RCtiRoutePoint',
            'RTransPattern' => '\\CUCM\\StructType\\RTransPattern',
            'RCallingPartyTransformationPattern' => '\\CUCM\\StructType\\RCallingPartyTransformationPattern',
            'RSipRoutePattern' => '\\CUCM\\StructType\\RSipRoutePattern',
            'RHuntPilot' => '\\CUCM\\StructType\\RHuntPilot',
            'RRoutePattern' => '\\CUCM\\StructType\\RRoutePattern',
            'RApplicationDialRules' => '\\CUCM\\StructType\\RApplicationDialRules',
            'RDirectoryLookupDialRules' => '\\CUCM\\StructType\\RDirectoryLookupDialRules',
            'RPhoneSecurityProfile' => '\\CUCM\\StructType\\RPhoneSecurityProfile',
            'RSipDialRules' => '\\CUCM\\StructType\\RSipDialRules',
            'RConferenceBridge' => '\\CUCM\\StructType\\RConferenceBridge',
            'RAnnunciator' => '\\CUCM\\StructType\\RAnnunciator',
            'RMtp' => '\\CUCM\\StructType\\RMtp',
            'RFixedMohAudioSource' => '\\CUCM\\StructType\\RFixedMohAudioSource',
            'RAarGroupMatrix' => '\\CUCM\\StructType\\RAarGroupMatrix',
            'RRemoteDestinationProfile' => '\\CUCM\\StructType\\RRemoteDestinationProfile',
            'RLine' => '\\CUCM\\StructType\\RLine',
            'RDefaultDeviceProfile' => '\\CUCM\\StructType\\RDefaultDeviceProfile',
            'RH323Phone' => '\\CUCM\\StructType\\RH323Phone',
            'RMohServer' => '\\CUCM\\StructType\\RMohServer',
            'RH323Trunk' => '\\CUCM\\StructType\\RH323Trunk',
            'RPhone' => '\\CUCM\\StructType\\RPhone',
            'RH323Gateway' => '\\CUCM\\StructType\\RH323Gateway',
            'RDeviceProfile' => '\\CUCM\\StructType\\RDeviceProfile',
            'RRemoteDestination' => '\\CUCM\\StructType\\RRemoteDestination',
            'RGateway' => '\\CUCM\\StructType\\RGateway',
            'RGatewayEndpointAnalogAccess' => '\\CUCM\\StructType\\RGatewayEndpointAnalogAccess',
            'RGatewayEndpointDigitalAccessPri' => '\\CUCM\\StructType\\RGatewayEndpointDigitalAccessPri',
            'RGatewayEndpointDigitalAccessBri' => '\\CUCM\\StructType\\RGatewayEndpointDigitalAccessBri',
            'RGatewayEndpointDigitalAccessT1' => '\\CUCM\\StructType\\RGatewayEndpointDigitalAccessT1',
            'RVg224' => '\\CUCM\\StructType\\RVg224',
            'RCiscoCatalyst600024PortFXSGateway' => '\\CUCM\\StructType\\RCiscoCatalyst600024PortFXSGateway',
            'RCiscoCatalyst6000E1VoIPGateway' => '\\CUCM\\StructType\\RCiscoCatalyst6000E1VoIPGateway',
            'RCiscoCatalyst6000T1VoIPGatewayPri' => '\\CUCM\\StructType\\RCiscoCatalyst6000T1VoIPGatewayPri',
            'RCiscoCatalyst6000T1VoIPGatewayT1' => '\\CUCM\\StructType\\RCiscoCatalyst6000T1VoIPGatewayT1',
            'RCallPickupGroup' => '\\CUCM\\StructType\\RCallPickupGroup',
            'RRoutePlan' => '\\CUCM\\StructType\\RRoutePlan',
            'RGeoLocationPolicy' => '\\CUCM\\StructType\\RGeoLocationPolicy',
            'RSipTrunk' => '\\CUCM\\StructType\\RSipTrunk',
            'RRegionMatrix' => '\\CUCM\\StructType\\RRegionMatrix',
            'RCalledPartyTransformationPattern' => '\\CUCM\\StructType\\RCalledPartyTransformationPattern',
            'RExternalCallControlProfile' => '\\CUCM\\StructType\\RExternalCallControlProfile',
            'RSafSecurityProfile' => '\\CUCM\\StructType\\RSafSecurityProfile',
            'RSafForwarder' => '\\CUCM\\StructType\\RSafForwarder',
            'RCcdHostedDN' => '\\CUCM\\StructType\\RCcdHostedDN',
            'RCcdHostedDNGroup' => '\\CUCM\\StructType\\RCcdHostedDNGroup',
            'RCcdRequestingService' => '\\CUCM\\StructType\\RCcdRequestingService',
            'RInterClusterServiceProfile' => '\\CUCM\\StructType\\RInterClusterServiceProfile',
            'RRemoteCluster' => '\\CUCM\\StructType\\RRemoteCluster',
            'RCcdAdvertisingService' => '\\CUCM\\StructType\\RCcdAdvertisingService',
            'RUnitsToGateway' => '\\CUCM\\StructType\\RUnitsToGateway',
            'RGatewaySubunits' => '\\CUCM\\StructType\\RGatewaySubunits',
            'RLdapDirectory' => '\\CUCM\\StructType\\RLdapDirectory',
            'REmccFeatureConfig' => '\\CUCM\\StructType\\REmccFeatureConfig',
            'RSafCcdPurgeBlockLearnedRoutes' => '\\CUCM\\StructType\\RSafCcdPurgeBlockLearnedRoutes',
            'RVpnGateway' => '\\CUCM\\StructType\\RVpnGateway',
            'RVpnGroup' => '\\CUCM\\StructType\\RVpnGroup',
            'RVpnProfile' => '\\CUCM\\StructType\\RVpnProfile',
            'RImeServer' => '\\CUCM\\StructType\\RImeServer',
            'RImeRouteFilterGroup' => '\\CUCM\\StructType\\RImeRouteFilterGroup',
            'RImeRouteFilterElement' => '\\CUCM\\StructType\\RImeRouteFilterElement',
            'RImeClient' => '\\CUCM\\StructType\\RImeClient',
            'RImeEnrolledPattern' => '\\CUCM\\StructType\\RImeEnrolledPattern',
            'RImeEnrolledPatternGroup' => '\\CUCM\\StructType\\RImeEnrolledPatternGroup',
            'RImeExclusionNumber' => '\\CUCM\\StructType\\RImeExclusionNumber',
            'RImeExclusionNumberGroup' => '\\CUCM\\StructType\\RImeExclusionNumberGroup',
            'RImeFirewall' => '\\CUCM\\StructType\\RImeFirewall',
            'RImeE164Transformation' => '\\CUCM\\StructType\\RImeE164Transformation',
            'RTransformationProfile' => '\\CUCM\\StructType\\RTransformationProfile',
            'RFallbackProfile' => '\\CUCM\\StructType\\RFallbackProfile',
            'RLdapFilter' => '\\CUCM\\StructType\\RLdapFilter',
            'RAppServerInfo' => '\\CUCM\\StructType\\RAppServerInfo',
            'RTvsCertificate' => '\\CUCM\\StructType\\RTvsCertificate',
            'RFeatureControlPolicy' => '\\CUCM\\StructType\\RFeatureControlPolicy',
            'RMobilityProfile' => '\\CUCM\\StructType\\RMobilityProfile',
            'REnterpriseFeatureAccessConfiguration' => '\\CUCM\\StructType\\REnterpriseFeatureAccessConfiguration',
            'RHandoffConfiguration' => '\\CUCM\\StructType\\RHandoffConfiguration',
            'RTODAccessMember' => '\\CUCM\\StructType\\RTODAccessMember',
            'RTimeScheduleTimePeriod' => '\\CUCM\\StructType\\RTimeScheduleTimePeriod',
            'RCallerFilterListMember' => '\\CUCM\\StructType\\RCallerFilterListMember',
            'RCallingSearchSpaceMember' => '\\CUCM\\StructType\\RCallingSearchSpaceMember',
            'RMediaResourceGroupMember' => '\\CUCM\\StructType\\RMediaResourceGroupMember',
            'RMediaResourceListMember' => '\\CUCM\\StructType\\RMediaResourceListMember',
            'RRegionRelationship' => '\\CUCM\\StructType\\RRegionRelationship',
            'RAarGroupRelationship' => '\\CUCM\\StructType\\RAarGroupRelationship',
            'RRouteGroupMember' => '\\CUCM\\StructType\\RRouteGroupMember',
            'RLocationRelationship' => '\\CUCM\\StructType\\RLocationRelationship',
            'RResourcePriorityNamespaceListMember' => '\\CUCM\\StructType\\RResourcePriorityNamespaceListMember',
            'RDevicePoolDeviceMobility' => '\\CUCM\\StructType\\RDevicePoolDeviceMobility',
            'RHuntListMember' => '\\CUCM\\StructType\\RHuntListMember',
            'RRouteFilterMember' => '\\CUCM\\StructType\\RRouteFilterMember',
            'RCallManagerMember' => '\\CUCM\\StructType\\RCallManagerMember',
            'RUserGroupMember' => '\\CUCM\\StructType\\RUserGroupMember',
            'RDigitDiscardInstructionMember' => '\\CUCM\\StructType\\RDigitDiscardInstructionMember',
            'RRouteListMember' => '\\CUCM\\StructType\\RRouteListMember',
            'RButton' => '\\CUCM\\StructType\\RButton',
            'RNumplanIdentifier' => '\\CUCM\\StructType\\RNumplanIdentifier',
            'RDateTimeGroupNtpReference' => '\\CUCM\\StructType\\RDateTimeGroupNtpReference',
            'RPresenceGroupMember' => '\\CUCM\\StructType\\RPresenceGroupMember',
            'RHuntForwardInfoBusy' => '\\CUCM\\StructType\\RHuntForwardInfoBusy',
            'RHuntForwardInfoNoAnswer' => '\\CUCM\\StructType\\RHuntForwardInfoNoAnswer',
            'RLineGroupMember' => '\\CUCM\\StructType\\RLineGroupMember',
            'RCallForwardAll' => '\\CUCM\\StructType\\RCallForwardAll',
            'RCallForwardBusy' => '\\CUCM\\StructType\\RCallForwardBusy',
            'RCallForwardBusyInt' => '\\CUCM\\StructType\\RCallForwardBusyInt',
            'RCallForwardNoAnswer' => '\\CUCM\\StructType\\RCallForwardNoAnswer',
            'RCallForwardNoAnswerInt' => '\\CUCM\\StructType\\RCallForwardNoAnswerInt',
            'RCallForwardNoCoverage' => '\\CUCM\\StructType\\RCallForwardNoCoverage',
            'RCallForwardNoCoverageInt' => '\\CUCM\\StructType\\RCallForwardNoCoverageInt',
            'RCallForwardOnFailure' => '\\CUCM\\StructType\\RCallForwardOnFailure',
            'RCallForwardAlternateParty' => '\\CUCM\\StructType\\RCallForwardAlternateParty',
            'RCallForwardNotRegistered' => '\\CUCM\\StructType\\RCallForwardNotRegistered',
            'RCallForwardNotRegisteredInt' => '\\CUCM\\StructType\\RCallForwardNotRegisteredInt',
            'RPhoneLine' => '\\CUCM\\StructType\\RPhoneLine',
            'associatedEndusers' => '\\CUCM\\StructType\\AssociatedEndusers',
            'REnduserMember' => '\\CUCM\\StructType\\REnduserMember',
            'RSpeeddial' => '\\CUCM\\StructType\\RSpeeddial',
            'RBusyLampField' => '\\CUCM\\StructType\\RBusyLampField',
            'associatedBlfSdFeatures' => '\\CUCM\\StructType\\AssociatedBlfSdFeatures',
            'RAddOnModule' => '\\CUCM\\StructType\\RAddOnModule',
            'RSubscribedService' => '\\CUCM\\StructType\\RSubscribedService',
            'RBLFDirectedCallPark' => '\\CUCM\\StructType\\RBLFDirectedCallPark',
            'RLineAssociation' => '\\CUCM\\StructType\\RLineAssociation',
            'RAnalogPort' => '\\CUCM\\StructType\\RAnalogPort',
            'RGatewayEndpointAnalog' => '\\CUCM\\StructType\\RGatewayEndpointAnalog',
            'RGatewayEndpointDigitalPri' => '\\CUCM\\StructType\\RGatewayEndpointDigitalPri',
            'RGatewayEndpointDigitalBri' => '\\CUCM\\StructType\\RGatewayEndpointDigitalBri',
            'RT1Port' => '\\CUCM\\StructType\\RT1Port',
            'RGatewayEndpointDigitalT1' => '\\CUCM\\StructType\\RGatewayEndpointDigitalT1',
            'RPickupGroupMember' => '\\CUCM\\StructType\\RPickupGroupMember',
            'RPolicyRelationship' => '\\CUCM\\StructType\\RPolicyRelationship',
            'RIpPhoneServicesParameter' => '\\CUCM\\StructType\\RIpPhoneServicesParameter',
            'RSafForwarderMember' => '\\CUCM\\StructType\\RSafForwarderMember',
            'RCcdRequestingServiceMember' => '\\CUCM\\StructType\\RCcdRequestingServiceMember',
            'RDirn' => '\\CUCM\\StructType\\RDirn',
            'RRemoteClusterMember' => '\\CUCM\\StructType\\RRemoteClusterMember',
            'RPatternMember' => '\\CUCM\\StructType\\RPatternMember',
            'dialParameters' => '\\CUCM\\StructType\\DialParameters',
            'RParameterMember' => '\\CUCM\\StructType\\RParameterMember',
            'RVmPilot' => '\\CUCM\\StructType\\RVmPilot',
            'RMobileVoiceMember' => '\\CUCM\\StructType\\RMobileVoiceMember',
            'RVpnGatewayMember' => '\\CUCM\\StructType\\RVpnGatewayMember',
            'RVpnGroupMember' => '\\CUCM\\StructType\\RVpnGroupMember',
            'RImeClientMember' => '\\CUCM\\StructType\\RImeClientMember',
            'RH323Line' => '\\CUCM\\StructType\\RH323Line',
            'RUserGroupRoles' => '\\CUCM\\StructType\\RUserGroupRoles',
            'RCertificateRole' => '\\CUCM\\StructType\\RCertificateRole',
            'RTvsCertificateService' => '\\CUCM\\StructType\\RTvsCertificateService',
            'RFeatureControlConfig' => '\\CUCM\\StructType\\RFeatureControlConfig',
            'RSipTrunkDestination' => '\\CUCM\\StructType\\RSipTrunkDestination',
            'RH323TrunkDestination' => '\\CUCM\\StructType\\RH323TrunkDestination',
            'RCcmExternalIpMap' => '\\CUCM\\StructType\\RCcmExternalIpMap',
            'UNumplanIdentifier' => '\\CUCM\\StructType\\UNumplanIdentifier',
            'UPhoneLine' => '\\CUCM\\StructType\\UPhoneLine',
            'UEnduserMember' => '\\CUCM\\StructType\\UEnduserMember',
            'UAnalogPort' => '\\CUCM\\StructType\\UAnalogPort',
            'UGatewayEndpointAnalog' => '\\CUCM\\StructType\\UGatewayEndpointAnalog',
            'UGatewayEndpointDigitalPri' => '\\CUCM\\StructType\\UGatewayEndpointDigitalPri',
            'UGatewayEndpointDigitalBri' => '\\CUCM\\StructType\\UGatewayEndpointDigitalBri',
            'UT1Port' => '\\CUCM\\StructType\\UT1Port',
            'UGatewayEndpointDigitalT1' => '\\CUCM\\StructType\\UGatewayEndpointDigitalT1',
            'UDirn' => '\\CUCM\\StructType\\UDirn',
            'XTODAccessMember' => '\\CUCM\\StructType\\XTODAccessMember',
            'XTimeScheduleTimePeriod' => '\\CUCM\\StructType\\XTimeScheduleTimePeriod',
            'XCallerFilterListMember' => '\\CUCM\\StructType\\XCallerFilterListMember',
            'XCallingSearchSpaceMember' => '\\CUCM\\StructType\\XCallingSearchSpaceMember',
            'XMediaResourceGroupMember' => '\\CUCM\\StructType\\XMediaResourceGroupMember',
            'XMediaResourceListMember' => '\\CUCM\\StructType\\XMediaResourceListMember',
            'XRegionRelationship' => '\\CUCM\\StructType\\XRegionRelationship',
            'XAarGroupRelationship' => '\\CUCM\\StructType\\XAarGroupRelationship',
            'XRouteGroupMember' => '\\CUCM\\StructType\\XRouteGroupMember',
            'XLocationRelationship' => '\\CUCM\\StructType\\XLocationRelationship',
            'XResourcePriorityNamespaceListMember' => '\\CUCM\\StructType\\XResourcePriorityNamespaceListMember',
            'XDevicePoolDeviceMobility' => '\\CUCM\\StructType\\XDevicePoolDeviceMobility',
            'XHuntListMember' => '\\CUCM\\StructType\\XHuntListMember',
            'XRouteFilterMember' => '\\CUCM\\StructType\\XRouteFilterMember',
            'XCallManagerMember' => '\\CUCM\\StructType\\XCallManagerMember',
            'XUserGroupMember' => '\\CUCM\\StructType\\XUserGroupMember',
            'XDigitDiscardInstructionMember' => '\\CUCM\\StructType\\XDigitDiscardInstructionMember',
            'XRouteListMember' => '\\CUCM\\StructType\\XRouteListMember',
            'XButton' => '\\CUCM\\StructType\\XButton',
            'XNumplanIdentifier' => '\\CUCM\\StructType\\XNumplanIdentifier',
            'XDateTimeGroupNtpReference' => '\\CUCM\\StructType\\XDateTimeGroupNtpReference',
            'XPresenceGroupMember' => '\\CUCM\\StructType\\XPresenceGroupMember',
            'XHuntForwardInfoBusy' => '\\CUCM\\StructType\\XHuntForwardInfoBusy',
            'XHuntForwardInfoNoAnswer' => '\\CUCM\\StructType\\XHuntForwardInfoNoAnswer',
            'XLineGroupMember' => '\\CUCM\\StructType\\XLineGroupMember',
            'XCallForwardAll' => '\\CUCM\\StructType\\XCallForwardAll',
            'XCallForwardBusy' => '\\CUCM\\StructType\\XCallForwardBusy',
            'XCallForwardBusyInt' => '\\CUCM\\StructType\\XCallForwardBusyInt',
            'XCallForwardNoAnswer' => '\\CUCM\\StructType\\XCallForwardNoAnswer',
            'XCallForwardNoAnswerInt' => '\\CUCM\\StructType\\XCallForwardNoAnswerInt',
            'XCallForwardNoCoverage' => '\\CUCM\\StructType\\XCallForwardNoCoverage',
            'XCallForwardNoCoverageInt' => '\\CUCM\\StructType\\XCallForwardNoCoverageInt',
            'XCallForwardOnFailure' => '\\CUCM\\StructType\\XCallForwardOnFailure',
            'XCallForwardAlternateParty' => '\\CUCM\\StructType\\XCallForwardAlternateParty',
            'XCallForwardNotRegistered' => '\\CUCM\\StructType\\XCallForwardNotRegistered',
            'XCallForwardNotRegisteredInt' => '\\CUCM\\StructType\\XCallForwardNotRegisteredInt',
            'XPhoneLine' => '\\CUCM\\StructType\\XPhoneLine',
            'XEnduserMember' => '\\CUCM\\StructType\\XEnduserMember',
            'XSpeeddial' => '\\CUCM\\StructType\\XSpeeddial',
            'XBusyLampField' => '\\CUCM\\StructType\\XBusyLampField',
            'XAddOnModule' => '\\CUCM\\StructType\\XAddOnModule',
            'XSubscribedService' => '\\CUCM\\StructType\\XSubscribedService',
            'XBLFDirectedCallPark' => '\\CUCM\\StructType\\XBLFDirectedCallPark',
            'XLineAssociation' => '\\CUCM\\StructType\\XLineAssociation',
            'XAnalogPort' => '\\CUCM\\StructType\\XAnalogPort',
            'XGatewayEndpointAnalog' => '\\CUCM\\StructType\\XGatewayEndpointAnalog',
            'XGatewayEndpointDigitalPri' => '\\CUCM\\StructType\\XGatewayEndpointDigitalPri',
            'XGatewayEndpointDigitalBri' => '\\CUCM\\StructType\\XGatewayEndpointDigitalBri',
            'XT1Port' => '\\CUCM\\StructType\\XT1Port',
            'XGatewayEndpointDigitalT1' => '\\CUCM\\StructType\\XGatewayEndpointDigitalT1',
            'XPickupGroupMember' => '\\CUCM\\StructType\\XPickupGroupMember',
            'XPolicyRelationship' => '\\CUCM\\StructType\\XPolicyRelationship',
            'XIpPhoneServicesParameter' => '\\CUCM\\StructType\\XIpPhoneServicesParameter',
            'XSafForwarderMember' => '\\CUCM\\StructType\\XSafForwarderMember',
            'XCcdRequestingServiceMember' => '\\CUCM\\StructType\\XCcdRequestingServiceMember',
            'XDirn' => '\\CUCM\\StructType\\XDirn',
            'XRemoteClusterMember' => '\\CUCM\\StructType\\XRemoteClusterMember',
            'XPatternMember' => '\\CUCM\\StructType\\XPatternMember',
            'XParameterMember' => '\\CUCM\\StructType\\XParameterMember',
            'XVmPilot' => '\\CUCM\\StructType\\XVmPilot',
            'XMobileVoiceMember' => '\\CUCM\\StructType\\XMobileVoiceMember',
            'XVpnGatewayMember' => '\\CUCM\\StructType\\XVpnGatewayMember',
            'XVpnGroupMember' => '\\CUCM\\StructType\\XVpnGroupMember',
            'XImeClientMember' => '\\CUCM\\StructType\\XImeClientMember',
            'XH323Line' => '\\CUCM\\StructType\\XH323Line',
            'XUserGroupRoles' => '\\CUCM\\StructType\\XUserGroupRoles',
            'XCertificateRole' => '\\CUCM\\StructType\\XCertificateRole',
            'XTvsCertificateService' => '\\CUCM\\StructType\\XTvsCertificateService',
            'XFeatureControlConfig' => '\\CUCM\\StructType\\XFeatureControlConfig',
            'XSipTrunkDestination' => '\\CUCM\\StructType\\XSipTrunkDestination',
            'XH323TrunkDestination' => '\\CUCM\\StructType\\XH323TrunkDestination',
            'XCcmExternalIpMap' => '\\CUCM\\StructType\\XCcmExternalIpMap',
            'StandardResponse' => '\\CUCM\\StructType\\StandardResponse',
            'NameAndGUIDRequest' => '\\CUCM\\StructType\\NameAndGUIDRequest',
            'APIRequest' => '\\CUCM\\StructType\\APIRequest',
            'APIResponse' => '\\CUCM\\StructType\\APIResponse',
            'ExecuteSQLQueryReq' => '\\CUCM\\StructType\\ExecuteSQLQueryReq',
            'ExecuteSQLQueryRes' => '\\CUCM\\StructType\\ExecuteSQLQueryRes',
            'XLoadInformation' => '\\CUCM\\StructType\\XLoadInformation',
            'XVendorConfig' => '\\CUCM\\StructType\\XVendorConfig',
            'XContent' => '\\CUCM\\StructType\\XContent',
            'ExecuteSQLUpdateReq' => '\\CUCM\\StructType\\ExecuteSQLUpdateReq',
            'ExecuteSQLUpdateRes' => '\\CUCM\\StructType\\ExecuteSQLUpdateRes',
            'DoAuthenticateUserReq' => '\\CUCM\\StructType\\DoAuthenticateUserReq',
            'DoAuthenticateUserRes' => '\\CUCM\\StructType\\DoAuthenticateUserRes',
            'DoDeviceLoginReq' => '\\CUCM\\StructType\\DoDeviceLoginReq',
            'DoDeviceLoginRes' => '\\CUCM\\StructType\\DoDeviceLoginRes',
            'DoDeviceLogoutReq' => '\\CUCM\\StructType\\DoDeviceLogoutReq',
            'DoDeviceLogoutRes' => '\\CUCM\\StructType\\DoDeviceLogoutRes',
            'DoDeviceResetReq' => '\\CUCM\\StructType\\DoDeviceResetReq',
            'DoDeviceResetRes' => '\\CUCM\\StructType\\DoDeviceResetRes',
            'GetOSVersionReq' => '\\CUCM\\StructType\\GetOSVersionReq',
            'GetOSVersionRes' => '\\CUCM\\StructType\\GetOSVersionRes',
            'GetNumDevicesReq' => '\\CUCM\\StructType\\GetNumDevicesReq',
            'GetNumDevicesRes' => '\\CUCM\\StructType\\GetNumDevicesRes',
            'getNumDevicesResponse' => '\\CUCM\\StructType\\GetNumDevicesResponse',
            'AddMobilityReq' => '\\CUCM\\StructType\\AddMobilityReq',
            'UpdateMobilityReq' => '\\CUCM\\StructType\\UpdateMobilityReq',
            'GetMobilityReq' => '\\CUCM\\StructType\\GetMobilityReq',
            'GetMobilityRes' => '\\CUCM\\StructType\\GetMobilityRes',
            'XMobility' => '\\CUCM\\StructType\\XMobility',
            'RMobility' => '\\CUCM\\StructType\\RMobility',
            'XOSVersion' => '\\CUCM\\StructType\\XOSVersion',
            'GetEnterprisePhoneConfigReq' => '\\CUCM\\StructType\\GetEnterprisePhoneConfigReq',
            'GetEnterprisePhoneConfigRes' => '\\CUCM\\StructType\\GetEnterprisePhoneConfigRes',
            'XEnterprisePhoneConfig' => '\\CUCM\\StructType\\XEnterprisePhoneConfig',
            'UpdateEnterprisePhoneConfigReq' => '\\CUCM\\StructType\\UpdateEnterprisePhoneConfigReq',
            'GetLicenseUnitReportReq' => '\\CUCM\\StructType\\GetLicenseUnitReportReq',
            'GetLicenseUnitReportRes' => '\\CUCM\\StructType\\GetLicenseUnitReportRes',
            'XLicenseUnitReport' => '\\CUCM\\StructType\\XLicenseUnitReport',
            'phoneLicenseFeature' => '\\CUCM\\StructType\\PhoneLicenseFeature',
            'ccmNodeLicenseFeature' => '\\CUCM\\StructType\\CcmNodeLicenseFeature',
            'softwareLicenseVersion' => '\\CUCM\\StructType\\SoftwareLicenseVersion',
            'GetLdapSystemReq' => '\\CUCM\\StructType\\GetLdapSystemReq',
            'GetLdapSystemRes' => '\\CUCM\\StructType\\GetLdapSystemRes',
            'XLdapSystem' => '\\CUCM\\StructType\\XLdapSystem',
            'UpdateLdapSystemReq' => '\\CUCM\\StructType\\UpdateLdapSystemReq',
            'XLdapAuthentication' => '\\CUCM\\StructType\\XLdapAuthentication',
            'GetLdapAuthenticationReq' => '\\CUCM\\StructType\\GetLdapAuthenticationReq',
            'GetLdapAuthenticationRes' => '\\CUCM\\StructType\\GetLdapAuthenticationRes',
            'UpdateLdapAuthenticationReq' => '\\CUCM\\StructType\\UpdateLdapAuthenticationReq',
            'XApplicationToSoftKeyTemplate' => '\\CUCM\\StructType\\XApplicationToSoftKeyTemplate',
            'AddApplicationToSoftkeyTemplateReq' => '\\CUCM\\StructType\\AddApplicationToSoftkeyTemplateReq',
            'removeApplicationToSoftkeyTemplateReq' => '\\CUCM\\StructType\\RemoveApplicationToSoftkeyTemplateReq',
            'GetCCMVersionReq' => '\\CUCM\\StructType\\GetCCMVersionReq',
            'GetCCMVersionRes' => '\\CUCM\\StructType\\GetCCMVersionRes',
            'componentVersion' => '\\CUCM\\StructType\\ComponentVersion',
            'XNameAttribute' => '\\CUCM\\StructType\\XNameAttribute',
            'RemoveUnitsToGatewayReq' => '\\CUCM\\StructType\\RemoveUnitsToGatewayReq',
            'RemoveGatewaySubunitsReq' => '\\CUCM\\StructType\\RemoveGatewaySubunitsReq',
            'XFkType' => '\\CUCM\\StructType\\XFkType',
            'UpdateImeFeatureConfigReq' => '\\CUCM\\StructType\\UpdateImeFeatureConfigReq',
            'UpdateFallbackFeatureConfigReq' => '\\CUCM\\StructType\\UpdateFallbackFeatureConfigReq',
            'GetImeFeatureConfigReq' => '\\CUCM\\StructType\\GetImeFeatureConfigReq',
            'GetFallbackFeatureConfigReq' => '\\CUCM\\StructType\\GetFallbackFeatureConfigReq',
            'GetFallbackFeatureConfigRes' => '\\CUCM\\StructType\\GetFallbackFeatureConfigRes',
            'RFallbackFeatureConfig' => '\\CUCM\\StructType\\RFallbackFeatureConfig',
            'RemoveImeLearnedRoutesReq' => '\\CUCM\\StructType\\RemoveImeLearnedRoutesReq',
            'UpdateImeLearnedRoutesReq' => '\\CUCM\\StructType\\UpdateImeLearnedRoutesReq',
            'GetImeLearnedRoutesReq' => '\\CUCM\\StructType\\GetImeLearnedRoutesReq',
            'GetImeLearnedRoutesRes' => '\\CUCM\\StructType\\GetImeLearnedRoutesRes',
            'RImeLearnedRoutes' => '\\CUCM\\StructType\\RImeLearnedRoutes',
            'GetImeFeatureConfigRes' => '\\CUCM\\StructType\\GetImeFeatureConfigRes',
            'RImeFeatureConfig' => '\\CUCM\\StructType\\RImeFeatureConfig',
            'RemoveAppServerInfoReq' => '\\CUCM\\StructType\\RemoveAppServerInfoReq',
            'GetAppServerInfoReq' => '\\CUCM\\StructType\\GetAppServerInfoReq',
            'GetAppServerInfoRes' => '\\CUCM\\StructType\\GetAppServerInfoRes',
            'DoLdapSyncReq' => '\\CUCM\\StructType\\DoLdapSyncReq',
            'DoLdapSyncRes' => '\\CUCM\\StructType\\DoLdapSyncRes',
            'GetLdapSyncStatusReq' => '\\CUCM\\StructType\\GetLdapSyncStatusReq',
            'GetLdapSyncStatusRes' => '\\CUCM\\StructType\\GetLdapSyncStatusRes',
            'XCommonMembersExtension' => '\\CUCM\\StructType\\XCommonMembersExtension',
            'UpdateSoftKeySetReq' => '\\CUCM\\StructType\\UpdateSoftKeySetReq',
            'removeCallStates' => '\\CUCM\\StructType\\RemoveCallStates',
            'addCallStates' => '\\CUCM\\StructType\\AddCallStates',
            'callStates' => '\\CUCM\\StructType\\CallStates',
            'XCallStateMember' => '\\CUCM\\StructType\\XCallStateMember',
            'softKeys' => '\\CUCM\\StructType\\SoftKeys',
            'RCallStateMember' => '\\CUCM\\StructType\\RCallStateMember',
            'XSoftKeyMember' => '\\CUCM\\StructType\\XSoftKeyMember',
            'RSoftKeyMember' => '\\CUCM\\StructType\\RSoftKeyMember',
            'GetSoftKeySetReq' => '\\CUCM\\StructType\\GetSoftKeySetReq',
            'GetSoftKeySetRes' => '\\CUCM\\StructType\\GetSoftKeySetRes',
            'RSoftKeySet' => '\\CUCM\\StructType\\RSoftKeySet',
            'DoUpdateRemoteClusterReq' => '\\CUCM\\StructType\\DoUpdateRemoteClusterReq',
            'DoUpdateRemoteClusterRes' => '\\CUCM\\StructType\\DoUpdateRemoteClusterRes',
        );
    }
}
