<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSoftKeyMember StructType
 * @subpackage Structs
 */
class XSoftKeyMember extends AbstractStructBase
{
    /**
     * The positionId
     * Meta informations extracted from the WSDL
     * - documentation: Read-Only.The positionId has values starting with 0 and get incremented by 1 for each call state.
     * - minOccurs: 0
     * @var int
     */
    public $positionId;
    /**
     * The softKeyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $softKeyName;
    /**
     * Constructor method for XSoftKeyMember
     * @uses XSoftKeyMember::setPositionId()
     * @uses XSoftKeyMember::setSoftKeyName()
     * @param int $positionId
     * @param string $softKeyName
     */
    public function __construct($positionId = null, $softKeyName = null)
    {
        $this
            ->setPositionId($positionId)
            ->setSoftKeyName($softKeyName);
    }
    /**
     * Get positionId value
     * @return int|null
     */
    public function getPositionId()
    {
        return $this->positionId;
    }
    /**
     * Set positionId value
     * @param int $positionId
     * @return \CUCM\StructType\XSoftKeyMember
     */
    public function setPositionId($positionId = null)
    {
        // validation for constraint: int
        if (!is_null($positionId) && !is_numeric($positionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($positionId)), __LINE__);
        }
        $this->positionId = $positionId;
        return $this;
    }
    /**
     * Get softKeyName value
     * @return string|null
     */
    public function getSoftKeyName()
    {
        return $this->softKeyName;
    }
    /**
     * Set softKeyName value
     * @param string $softKeyName
     * @return \CUCM\StructType\XSoftKeyMember
     */
    public function setSoftKeyName($softKeyName = null)
    {
        // validation for constraint: string
        if (!is_null($softKeyName) && !is_string($softKeyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($softKeyName)), __LINE__);
        }
        $this->softKeyName = $softKeyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XSoftKeyMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
