<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRegionRelationship StructType
 * @subpackage Structs
 */
class XRegionRelationship extends AbstractStructBase
{
    /**
     * The regionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \CUCM\StructType\XFkType
     */
    public $regionName;
    /**
     * The bandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $videoBandwidth;
    /**
     * The lossyNetwork
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lossyNetwork;
    /**
     * Constructor method for XRegionRelationship
     * @uses XRegionRelationship::setRegionName()
     * @uses XRegionRelationship::setBandwidth()
     * @uses XRegionRelationship::setVideoBandwidth()
     * @uses XRegionRelationship::setLossyNetwork()
     * @param \CUCM\StructType\XFkType $regionName
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $lossyNetwork
     */
    public function __construct(\CUCM\StructType\XFkType $regionName = null, $bandwidth = null, $videoBandwidth = '384', $lossyNetwork = 'Use System Default')
    {
        $this
            ->setRegionName($regionName)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setLossyNetwork($lossyNetwork);
    }
    /**
     * Get regionName value
     * @return \CUCM\StructType\XFkType
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \CUCM\StructType\XFkType $regionName
     * @return \CUCM\StructType\XRegionRelationship
     */
    public function setRegionName(\CUCM\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @uses \CUCM\EnumType\XBandwidth::valueIsValid()
     * @uses \CUCM\EnumType\XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bandwidth
     * @return \CUCM\StructType\XRegionRelationship
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBandwidth::valueIsValid($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bandwidth, implode(', ', \CUCM\EnumType\XBandwidth::getValidValues())), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \CUCM\StructType\XRegionRelationship
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses \CUCM\EnumType\XLossyNetwork::valueIsValid()
     * @uses \CUCM\EnumType\XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return \CUCM\StructType\XRegionRelationship
     */
    public function setLossyNetwork($lossyNetwork = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lossyNetwork, implode(', ', \CUCM\EnumType\XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XRegionRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
